/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.entities;

import com.rumaruka.thaumicbases.api.ITobacco;
import com.rumaruka.thaumicbases.init.TBItems;
import fr.wind_blade.isorropia.common.IsorropiaAPI;
import fr.wind_blade.isorropia.common.items.misc.ItemCat;
import fr.wind_blade.isorropia.common.research.recipes.CurativeInfusionRecipe;
import fr.wind_blade.isorropia.common.research.recipes.SpecieCurativeInfusionRecipe;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class EntityDopeSquid
extends EntityTameable {
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    public float tentacleAngle;
    public float lastTentacleAngle;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;
    private static final DataParameter<Byte> TOBACCO_TYPE = EntityDataManager.func_187226_a(EntityDopeSquid.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityDopeSquid(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.95f, 0.95f);
        this.field_70146_Z.setSeed(1 + this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new AIMoveRandom(this));
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TOBACCO_TYPE, (Object)9);
    }

    public void setTobacco(byte t) {
        this.field_70180_af.func_187227_b(TOBACCO_TYPE, (Object)t);
    }

    public byte getTobacco() {
        return (Byte)this.field_70180_af.func_187225_a(TOBACCO_TYPE);
    }

    private int getTobaccoType(ITobacco stack) {
        if (stack == TBItems.tobacco_pile) {
            return 0;
        }
        if (stack == TBItems.tobacco_eldritch) {
            return 1;
        }
        if (stack == TBItems.tobacco_fighting) {
            return 2;
        }
        if (stack == TBItems.tobacco_hunger) {
            return 3;
        }
        if (stack == TBItems.tobacco_knowledge) {
            return 4;
        }
        if (stack == TBItems.tobacco_mining) {
            return 5;
        }
        if (stack == TBItems.tobacco_sanity) {
            return 6;
        }
        if (stack == TBItems.tobacco_tainted) {
            return 7;
        }
        if (stack == TBItems.tobacco_wispy) {
            return 8;
        }
        return 0;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && !player.field_70170_p.field_72995_K) {
            if (this.func_70909_n() && this.func_70902_q() == player) {
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ITobacco) {
                    this.setTobacco((byte)this.getTobaccoType((ITobacco)stack.func_77973_b()));
                    stack.func_190918_g(1);
                } else {
                    this.func_70904_g(!this.func_70906_o());
                }
            }
            if (!stack.func_190926_b() && stack.func_77973_b() == TBItems.tobacco_tainted) {
                if (!this.func_70909_n()) {
                    this.func_193101_c(player);
                    this.func_70904_g(true);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else if (this.func_70902_q() == player) {
                    this.func_70691_i(5.0f);
                    this.func_70908_e(true);
                }
                stack.func_190918_g(1);
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void func_180430_e(float a, float b) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Item.func_150899_d((int)0);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S()) {
            boolean isInWater = this.func_70090_H();
            if (!isInWater) {
                int air = this.func_70086_ai();
                this.func_70050_g(--air);
                if (this.func_70086_ai() == -20) {
                    this.func_70050_g(0);
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            } else {
                this.func_70050_g(300);
            }
            this.prevSquidPitch = this.squidPitch;
            this.prevSquidYaw = this.squidYaw;
            this.prevSquidRotation = this.squidRotation;
            this.lastTentacleAngle = this.tentacleAngle;
            this.squidRotation += this.rotationVelocity;
            if (!this.func_70906_o() && isInWater) {
                if ((double)this.squidRotation > Math.PI * 2) {
                    this.squidRotation = 0.0f;
                    if (this.field_70146_Z.nextInt(10) == 0) {
                        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                    }
                }
                if (this.squidRotation < (float)Math.PI) {
                    float f = this.squidRotation / (float)Math.PI;
                    this.tentacleAngle = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                    if ((double)f > 0.75) {
                        this.randomMotionSpeed = 1.0f;
                        this.rotateSpeed = 1.0f;
                    } else {
                        this.rotateSpeed *= 0.8f;
                    }
                } else {
                    this.tentacleAngle = 0.0f;
                    this.randomMotionSpeed *= 0.9f;
                    this.rotateSpeed *= 0.99f;
                }
                if (!this.field_70170_p.field_72995_K) {
                    double moveSpeed = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                    this.field_70159_w = (double)(this.randomMotionVecX * this.randomMotionSpeed) * moveSpeed;
                    this.field_70181_x = (double)(this.randomMotionVecY * this.randomMotionSpeed) * moveSpeed;
                    this.field_70179_y = (double)(this.randomMotionVecZ * this.randomMotionSpeed) * moveSpeed;
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
                this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f - this.field_70761_aq) * 0.1f;
                this.field_70177_z = this.field_70761_aq;
                this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
                this.squidPitch += (-((float)MathHelper.func_181159_b((double)f, (double)this.field_70181_x)) * 57.295776f - this.squidPitch) * 0.1f;
            } else {
                this.tentacleAngle = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.squidRotation)) * (float)Math.PI * 0.25f;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70159_w = 0.0;
                    this.field_70181_x -= 0.08;
                    this.field_70181_x *= (double)0.98f;
                    this.field_70179_y = 0.0;
                    this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityLivingBase owner = this.func_70902_q();
            if (this.field_70173_aa % 400 == 0 && owner instanceof EntityPlayer && this.func_70068_e((Entity)owner) < 15.0) {
                EntityPlayer player = (EntityPlayer)owner;
                this.performTobaccoEffect(player, this.getTobacco());
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("Tobacco", this.getTobacco());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setTobacco(compound.func_74771_c("Tobacco"));
    }

    private void performTobaccoEffect(EntityPlayer player, byte tobaccoType) {
        ItemStack tobaccoStack = EntityDopeSquid.getTobaccoStack(tobaccoType);
        if (!tobaccoStack.func_190926_b() && tobaccoStack.func_77973_b() instanceof ITobacco) {
            ((ITobacco)tobaccoStack.func_77973_b()).performTobaccoEffect(player, tobaccoStack, false);
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 8; ++i) {
                double dx = this.field_70146_Z.nextGaussian() * 0.02;
                double dy = this.field_70146_Z.nextGaussian() * 0.02;
                double dz = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, dx, dy, dz, new int[0]);
            }
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
    }

    public static ItemStack getTobaccoStack(byte type) {
        Item item;
        switch (type) {
            case 0: {
                item = TBItems.tobacco_pile;
                break;
            }
            case 1: {
                item = TBItems.tobacco_eldritch;
                break;
            }
            case 2: {
                item = TBItems.tobacco_fighting;
                break;
            }
            case 3: {
                item = TBItems.tobacco_hunger;
                break;
            }
            case 4: {
                item = TBItems.tobacco_knowledge;
                break;
            }
            case 5: {
                item = TBItems.tobacco_mining;
                break;
            }
            case 6: {
                item = TBItems.tobacco_sanity;
                break;
            }
            case 7: {
                item = TBItems.tobacco_tainted;
                break;
            }
            case 8: {
                item = TBItems.tobacco_wispy;
                break;
            }
            default: {
                item = TBItems.tobacco_pile;
            }
        }
        return new ItemStack(item);
    }

    public static void makeDopeSquidRecipe() {
        IsorropiaAPI.registerCreatureInfusionRecipe(new ResourceLocation("isorropia", "dope_squid"), ((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((SpecieCurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)((CurativeInfusionRecipe.Builder)new SpecieCurativeInfusionRecipe.Builder().withAspects(new AspectList().add(Aspect.PLANT, 50).add(Aspect.MAN, 50).add(Aspect.MAGIC, 50).add(Aspect.FLIGHT, 50))).withComponents(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FIRE)}), Ingredient.func_193367_a((Item)TBItems.tobacco_knowledge), Ingredient.func_193367_a((Item)TBItems.tobacco_eldritch), Ingredient.func_193367_a((Item)TBItems.tobacco_fighting), Ingredient.func_193367_a((Item)TBItems.tobacco_hunger), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AIR)}), Ingredient.func_193367_a((Item)TBItems.tobacco_mining), Ingredient.func_193367_a((Item)TBItems.tobacco_wispy), Ingredient.func_193367_a((Item)TBItems.tobacco_sanity), Ingredient.func_193367_a((Item)TBItems.tobacco_tainted))).withInstability(8)).withResult(EntityDopeSquid.class)).withKnowledgeRequirement("DOPESQUIDINFUSION")).withPredicate(entity -> entity.getClass() == EntitySquid.class)).withFakeIngredients(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemCat.createCat(ItemCat.EnumCat.SQUID, "Squid")}), ItemCat.createCat(ItemCat.EnumCat.SQUID, "DopeSquid"))).build());
    }

    static class AIMoveRandom
    extends EntityAIBase {
        private final EntityDopeSquid squid;

        public AIMoveRandom(EntityDopeSquid p_i45859_1_) {
            this.squid = p_i45859_1_;
            this.func_75248_a(2);
        }

        public boolean func_75250_a() {
            return !this.squid.func_70906_o() && this.squid.func_70090_H();
        }

        public void func_75246_d() {
            if (this.squid.func_70654_ax() > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.func_70681_au().nextInt(50) == 0 || !this.squid.func_70090_H() || !this.squid.hasMovementVector()) {
                float f = this.squid.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.squid.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.squid.setMovementVector(f1, f2, f3);
            }
        }
    }
}

