/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.entities;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.items.ItemsTC;

public class EntityHangingLabel
extends EntityHanging
implements IEntityAdditionalSpawnData {
    private Aspect aspect;

    public EntityHangingLabel(World worldIn) {
        super(worldIn);
        this.aspect = null;
    }

    public EntityHangingLabel(World world, boolean b, BlockPos offset, EnumFacing face, Aspect aspectIn) {
        super(world, offset);
        this.func_174859_a(face);
        this.aspect = aspectIn;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public int func_82329_d() {
        return 16;
    }

    public int func_82330_g() {
        return 16;
    }

    public void func_110128_b(Entity brokenEntity) {
        this.func_184523_o();
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack stack = new ItemStack(ItemsTC.label);
            if (this.aspect != null) {
                ((IEssentiaContainerItem)ItemsTC.label).setAspects(stack, new AspectList().add(this.aspect, 1));
                stack.func_77964_b(1);
            }
            this.func_70099_a(stack, 0.0f);
        }
    }

    public void func_184523_o() {
        BlockPos hangingBlock = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
        IBlockState state = this.field_70170_p.func_180495_p(hangingBlock);
        this.func_184185_a(state.func_177230_c().getSoundType(state, this.field_70170_p, hangingBlock, (Entity)this).func_185846_f(), 1.5f, 1.0f);
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 16.0;
        return distance < (d0 = d0 * 64.0 * EntityHangingLabel.func_184183_bd()) * d0;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.field_174860_b.func_176736_b());
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)(this.aspect != null ? this.aspect.getTag() : ""));
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_174859_a(EnumFacing.func_176731_b((int)additionalData.readInt()));
        String tag = ByteBufUtils.readUTF8String((ByteBuf)additionalData);
        if (!tag.isEmpty()) {
            this.aspect = Aspect.getAspect((String)tag);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("aspect", this.aspect != null ? this.aspect.getTag() : "");
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        String tag = compound.func_74779_i("aspect");
        if (!tag.isEmpty()) {
            this.aspect = Aspect.getAspect((String)tag);
        }
    }
}

