/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.entities.ai;

import java.util.Random;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockArc;

public class EntityAILigo
extends EntityAIBase {
    protected EntityLiving living;
    protected Chunk bindChunk;
    protected int chunkRange;
    protected EntityAITasks.EntityAITaskEntry entry;

    public EntityAILigo(EntityLiving living, Chunk bindChunk, int chunkRange, EntityAITasks.EntityAITaskEntry entry) {
        this.living = living;
        this.bindChunk = bindChunk;
        this.chunkRange = chunkRange;
        this.entry = entry;
        living.field_70714_bg.field_75782_a.remove(entry);
    }

    public boolean func_75250_a() {
        Chunk targetChunk;
        PathPoint point;
        boolean havePath;
        Chunk livingChunk = this.living.field_70170_p.func_72964_e((int)this.living.field_70165_t >> 4, (int)this.living.field_70161_v >> 4);
        int distance = this.getDistance(livingChunk);
        boolean bl = havePath = !this.living.func_70661_as().func_75500_f();
        if (distance > this.chunkRange) {
            if (havePath) {
                this.living.func_70661_as().func_75499_g();
            }
            return true;
        }
        if (havePath && (point = this.living.func_70661_as().func_75505_d().func_189964_i()) != null && (distance = this.getDistance(targetChunk = this.living.field_70170_p.func_72964_e(point.field_75839_a >> 4, point.field_75838_c >> 4))) > this.chunkRange) {
            this.living.func_70661_as().func_75499_g();
        }
        return false;
    }

    public void func_75246_d() {
        BlockPos pos;
        double distance = this.getDistance((int)this.living.field_70165_t >> 4, (int)this.living.field_70161_v >> 4);
        if (distance <= (double)this.living.func_70661_as().func_111269_d() && (pos = this.findSuitableBlockPos(this.bindChunk)) != null && this.living.func_70661_as().func_75492_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0)) {
            return;
        }
        this.tpToBindedChunk();
    }

    public void tpToBindedChunk() {
        BlockPos pos = this.findSuitableBlockPos(this.bindChunk);
        if (pos != null) {
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new PacketFXBlockArc(pos, (Entity)this.living, 0.5f + new Random().nextFloat() * 0.2f, 0.0f, 0.0f), (Entity)this.living);
            this.living.func_184185_a(SoundsTC.wandfail, 1.0f, 1.0f);
            this.living.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), this.living.field_70177_z, this.living.field_70125_A);
            this.living.func_70661_as().func_75499_g();
        }
    }

    public BlockPos findSuitableBlockPos(Chunk chunk) {
        int i = chunk.field_76635_g * 16 + 8;
        int j = chunk.field_76647_h * 16 + 8;
        for (int y = 255; y > 0; --y) {
            for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.isTeleportFriendlyBlock(i, j, y, l, i1)) continue;
                    return new BlockPos((double)((float)(i + l) + 0.5f), (double)y, (double)((float)(j + i1) + 0.5f));
                }
            }
        }
        return null;
    }

    public boolean isTeleportFriendlyBlock(int x, int z, int y, int xOffset, int zOffset) {
        int distance = this.getDistance(this.living.field_70170_p.func_72964_e(x >> 4, z >> 4));
        if (distance > this.chunkRange) {
            return false;
        }
        BlockPos blockpos = new BlockPos(x + xOffset, y - 1, z + zOffset);
        IBlockState iblockstate = this.living.field_70170_p.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)this.living.field_70170_p, blockpos, EnumFacing.DOWN) == BlockFaceShape.SOLID && iblockstate.func_189884_a((Entity)this.living) && this.living.field_70170_p.func_175623_d(blockpos.func_177984_a()) && this.living.field_70170_p.func_175623_d(blockpos.func_177981_b(2));
    }

    public EntityAITasks.EntityAITaskEntry getAi() {
        return this.entry;
    }

    public int getDistance(Chunk targetChunk) {
        return this.getDistance(targetChunk.field_76635_g, targetChunk.field_76647_h);
    }

    public int getDistance(int targetX, int targetZ) {
        return (int)Math.sqrt(Math.pow(this.bindChunk.field_76635_g - targetX, 2.0) + Math.pow(this.bindChunk.field_76647_h - targetZ, 2.0));
    }

    public int getChunkRange() {
        return this.chunkRange;
    }
}

