/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.events;

import baubles.api.BaublesApi;
import fr.wind_blade.isorropia.common.Common;
import fr.wind_blade.isorropia.common.blocks.material.MaterialIR;
import fr.wind_blade.isorropia.common.capabilities.LivingBaseCapability;
import fr.wind_blade.isorropia.common.capabilities.LivingCapability;
import fr.wind_blade.isorropia.common.config.Config;
import fr.wind_blade.isorropia.common.entities.EntityHangingLabel;
import fr.wind_blade.isorropia.common.items.ItemsIS;
import fr.wind_blade.isorropia.common.lenses.Lens;
import fr.wind_blade.isorropia.common.lenses.LensManager;
import fr.wind_blade.isorropia.common.libs.helpers.IsorropiaHelper;
import fr.wind_blade.isorropia.common.network.LensRemoveMessage;
import fr.wind_blade.isorropia.common.research.recipes.OrganCurativeInfusionRecipe;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.blocks.ILabelable;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.casters.ICaster;
import thaumcraft.api.items.IGoggles;
import thaumcraft.api.items.IRevealer;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.api.research.ResearchEvent;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.items.tools.ItemThaumometer;
import thaumcraft.common.lib.research.ResearchManager;

public class EntityEventHandler {
    private static final ItemStack SHEARS = new ItemStack((Item)Items.field_151097_aZ);
    private Lens theRightLens;
    private static final Random randy = new Random();
    private Lens theLeftLens;
    private boolean hardCodedAntiRecursive = false;

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            World world = event.player.field_70170_p;
            ItemStack revealer = LensManager.getRevealer(event.player);
            if (!revealer.func_190926_b() && revealer.func_77942_o() && revealer.func_77978_p().func_74779_i("LeftLens") != null) {
                boolean doubleLens;
                this.theLeftLens = LensManager.getLens(revealer, LensManager.LENSSLOT.LEFT);
                this.theRightLens = LensManager.getLens(revealer, LensManager.LENSSLOT.RIGHT);
                boolean bl = doubleLens = this.theRightLens != null && ((Object)((Object)this.theRightLens)).equals((Object)this.theLeftLens);
                if (this.theLeftLens != null) {
                    this.theLeftLens.handleTicks(world, event.player, doubleLens);
                }
                if (!doubleLens && this.theRightLens != null) {
                    this.theRightLens.handleTicks(world, event.player, false);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof EntityLiving) {
            event.addCapability(new ResourceLocation("isorropia", "LIVING_CAPABILITY"), (ICapabilityProvider)new LivingCapability((EntityLiving)event.getObject()));
        } else if (entity instanceof EntityLivingBase) {
            event.addCapability(new ResourceLocation("isorropia", "LIVING_BASE_CAPABILITY"), (ICapabilityProvider)new LivingBaseCapability((EntityLivingBase)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onRevealerRemoved(LivingEquipmentChangeEvent event) {
        ItemStack stack = event.getFrom();
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        if (stack.func_77973_b() instanceof IRevealer && ((IRevealer)stack.func_77973_b()).showNodes(stack, event.getEntityLiving())) {
            Lens lens = LensManager.getLens(stack, LensManager.LENSSLOT.LEFT);
            Lens lens2 = LensManager.getLens(stack, LensManager.LENSSLOT.RIGHT);
            if (lens != null) {
                lens.handleRemoval(event.getEntityLiving().field_70170_p, (EntityPlayer)event.getEntityLiving());
            }
            if (lens2 != null) {
                lens2.handleRemoval(event.getEntityLiving().field_70170_p, (EntityPlayer)event.getEntityLiving());
            }
            Common.INSTANCE.sendTo((IMessage)new LensRemoveMessage(lens, lens2), (EntityPlayerMP)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onRevealerDestroy(PlayerDestroyItemEvent event) {
        ItemStack stack = event.getOriginal();
        EntityPlayer player = event.getEntityPlayer();
        if (stack.func_77973_b() instanceof IRevealer && ((IRevealer)stack.func_77973_b()).showNodes(stack, event.getEntityLiving())) {
            Lens lens = LensManager.getLens(stack, LensManager.LENSSLOT.LEFT);
            Lens lens2 = LensManager.getLens(stack, LensManager.LENSSLOT.RIGHT);
            if (lens != null && !player.field_71071_by.func_70441_a(new ItemStack((Item)lens.getItemLens()))) {
                player.func_71019_a(new ItemStack((Item)lens.getItemLens()), false);
            }
            if (lens2 != null && !player.field_71071_by.func_70441_a(new ItemStack((Item)lens.getItemLens()))) {
                player.func_71019_a(new ItemStack((Item)lens.getItemLens()), false);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        LivingBaseCapability cap = Common.getCap(entity);
        cap.update();
        if (entity.func_70055_a(MaterialIR.LIQUID_VAT)) {
            entity.func_70050_g(300);
        }
        if (!entity.field_70170_p.field_72995_K) {
            if (entity instanceof IShearable) {
                IShearable shear = (IShearable)entity;
                if (entity.field_70173_aa % 100 == 0 && cap.infusions.containsKey(new ResourceLocation("isorropia:selfshearing")) && shear.isShearable(SHEARS, (IBlockAccess)entity.field_70170_p, entity.func_180425_c())) {
                    ArrayList drops = (ArrayList)shear.onSheared(SHEARS, (IBlockAccess)entity.field_70170_p, entity.func_180425_c(), 0);
                    Random rand = new Random();
                    for (ItemStack stack : drops) {
                        EntityItem entityDropItem;
                        EntityItem ent = entityDropItem = entity.func_70099_a(stack, 1.0f);
                        entityDropItem.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                        EntityItem entityItem = ent;
                        entityItem.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                        EntityItem entityItem2 = ent;
                        entityItem2.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    }
                }
            }
            if (entity.field_70173_aa % 50 == 0 && cap.entityHasOrgan(OrganCurativeInfusionRecipe.Organ.BLOOD, "isorropia:awakened_blood") && entity.func_110143_aJ() < entity.func_110138_aP()) {
                entity.func_70691_i(1.0f);
            }
        }
    }

    @SubscribeEvent
    public void onStartTrack(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityLivingBase) {
            Common.getCap((EntityLivingBase)event.getTarget()).synchStartTracking((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Common.getCap((EntityLivingBase)event.player).synchStartTracking((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public void onPlayerBlockInterract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getEntityPlayer().func_184586_b(event.getHand());
        World world = event.getWorld();
        if (!world.field_72995_K && stack.func_77973_b() == ItemsTC.label && ThaumcraftCapabilities.getKnowledge((EntityPlayer)event.getEntityPlayer()).isResearchKnown("HANGINGLABEL") && !(world.func_180495_p(event.getPos()).func_177230_c() instanceof ILabelable) && event.getFace() != EnumFacing.DOWN && event.getFace() != EnumFacing.UP && event.getEntityPlayer().func_175151_a(event.getPos().func_177972_a(event.getFace()), event.getFace(), stack)) {
            AspectList aspects = ((IEssentiaContainerItem)stack.func_77973_b()).getAspects(stack);
            EntityHangingLabel entityMessage = new EntityHangingLabel(world, true, event.getPos().func_177972_a(event.getFace()), event.getFace(), aspects != null ? aspects.getAspects()[0] : null);
            if (entityMessage.func_70518_d()) {
                entityMessage.func_184523_o();
                world.func_72838_d((Entity)entityMessage);
                stack.func_190918_g(1);
            }
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        if (event.getEntityPlayer() != null && event.getTarget() instanceof EntityZombieVillager) {
            IPlayerKnowledge knowledge;
            EntityZombieVillager entity = (EntityZombieVillager)event.getTarget();
            if (stack.func_77973_b() == Items.field_151153_ao && stack.func_77960_j() == 0 && entity.func_70644_a(MobEffects.field_76437_t) && !entity.func_82230_o() && !(knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)event.getEntityPlayer())).isResearchKnown("!experiment.villager_zombie")) {
                knowledge.addResearch("!experiment.villager_zombie");
                knowledge.sync((EntityPlayerMP)event.getEntity());
                ((EntityPlayer)event.getEntity()).func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)"research.experiment.villager_zombie.text", (Object[])new Object[0])), false);
            }
        }
    }

    @SubscribeEvent
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        if (!event.getWorld().field_72995_K && (stack.func_77973_b() instanceof IRevealer || stack.func_77973_b() instanceof IGoggles) && stack.func_77942_o()) {
            String lens = stack.func_77978_p().func_74779_i(LensManager.LENSSLOT.LEFT.getName());
            if (!lens.equals("isorropia:ordo_lens")) {
                lens = stack.func_77978_p().func_74779_i(LensManager.LENSSLOT.RIGHT.getName());
            }
            if (lens.equals("isorropia:ordo_lens")) {
                ((ItemThaumometer)ItemsTC.thaumometer).doScan(event.getWorld(), event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getItemStack();
        if (event.getTarget() instanceof EntityLivingBase && !event.getWorld().field_72995_K) {
            EntityLivingBase target = (EntityLivingBase)event.getTarget();
            LivingBaseCapability cap = Common.getCap(target);
            if (target instanceof EntityLiving && cap.entityHasOrgan(OrganCurativeInfusionRecipe.Organ.VOID, "isorropia:portability") && stack.func_77973_b() instanceof ICaster) {
                if (!IsorropiaHelper.doPlayerHaveJar(event.getEntityPlayer(), false)) {
                    return;
                }
                if (!IsorropiaHelper.canEntityBeJarred((EntityLiving)target)) {
                    event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(String.valueOf(TextFormatting.ITALIC) + TextFormatting.GRAY + I18n.func_135052_a((String)"isorropia.containment.fail", (Object[])new Object[0])));
                    return;
                }
                IsorropiaHelper.playerJarEntity(event.getEntityPlayer(), (EntityLiving)target);
            }
        }
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        EntityLivingBase base = event.getEntityLiving();
        DamageSource source = event.getSource();
        LivingBaseCapability cap = Common.getCap(base);
        if (cap.entityHasOrgan(OrganCurativeInfusionRecipe.Organ.HEART, "isorropia:enderheart") && !base.func_180431_b(source) && source instanceof EntityDamageSourceIndirect) {
            base.field_70170_p.func_184148_a(null, base.field_70169_q, base.field_70167_r, base.field_70166_s, SoundEvents.field_187534_aX, base.func_184176_by(), 1.0f, 1.0f);
            base.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            base.func_184595_k(base.field_70165_t, base.field_70163_u, base.field_70161_v);
            base.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 3));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAttack(LivingDamageEvent event) {
        EntityLivingBase base = event.getEntityLiving();
        LivingBaseCapability cap = Common.getCap(base);
        Entity target = event.getSource().func_76346_g();
        if (target instanceof EntityLivingBase && cap.entityHasOrgan(OrganCurativeInfusionRecipe.Organ.SKIN, "isorropia:shockskin")) {
            FXDispatcher.INSTANCE.arcLightning(base.field_70165_t, base.field_70163_u, base.field_70161_v, target.field_70165_t, target.field_70163_u, target.field_70161_v, 0.2f, 0.8f, 0.8f, 1.0f);
            target.func_70097_a(DamageSource.field_180137_b, 4.0f);
        }
    }

    @SubscribeEvent
    public void onPlayerResearch(ResearchEvent.Research event) {
    }

    @SubscribeEvent
    public void onPlayerGetKnowledge(ResearchEvent.Knowledge event) {
        ItemStack stack = event.getPlayer().func_184582_a(EntityEquipmentSlot.HEAD);
        if (stack.func_77973_b() != ItemsIS.itemSomaticBrain) {
            stack = BaublesApi.getBaublesHandler((EntityPlayer)event.getPlayer()).getStackInSlot(4);
        }
        if (stack.func_77973_b() == ItemsIS.itemSomaticBrain && !this.hardCodedAntiRecursive) {
            this.hardCodedAntiRecursive = true;
            ResearchManager.addKnowledge((EntityPlayer)event.getPlayer(), (IPlayerKnowledge.EnumKnowledgeType)event.getType(), (ResearchCategory)event.getCategory(), (int)((int)Math.round((double)event.getAmount() * (event.getType() == IPlayerKnowledge.EnumKnowledgeType.THEORY ? 0.3 : 0.6))));
            this.hardCodedAntiRecursive = false;
        }
    }

    @SubscribeEvent
    public void onExperienceDrop(LivingExperienceDropEvent event) {
        EntityPlayer player = event.getAttackingPlayer();
        if (player != null) {
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (stack.func_77973_b() != ItemsIS.itemSomaticBrain) {
                stack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(4);
            }
            if (stack.func_77973_b() == ItemsIS.itemSomaticBrain) {
                event.setDroppedExperience(event.getDroppedExperience() * 2);
            }
        }
    }

    public void addDrop(LivingDropsEvent event, ItemStack drop) {
        EntityItem entityitem = new EntityItem(event.getEntityLiving().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, drop);
        entityitem.func_174867_a(10);
        event.getDrops().add(entityitem);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("Thaumic Isorropia")) {
            Config.syncConfigurable();
            if (Config.config != null && Config.config.hasChanged()) {
                Config.save();
            }
        }
    }
}

