/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.lenses;

import fr.wind_blade.isorropia.common.items.misc.ItemLens;
import fr.wind_blade.isorropia.common.lenses.Lens;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ScanningManager;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.client.lib.events.RenderEventHandler;
import thaumcraft.common.lib.utils.EntityUtils;

public class OrdoLens
extends Lens {
    private static float nameSize;

    public OrdoLens(ItemLens lensIn) {
        super(lensIn);
    }

    @Override
    public void handleTicks(World worldIn, EntityPlayer playerIn, boolean doubleLens) {
        if (worldIn.field_72995_K) {
            return;
        }
        Entity target = EntityUtils.getPointedEntity((World)worldIn, (Entity)playerIn, (double)1.0, (double)5.0, (float)0.0f, (boolean)true);
        if (target != null && ScanningManager.isThingStillScannable((EntityPlayer)playerIn, (Object)target)) {
            ScanningManager.scanTheThing((EntityPlayer)playerIn, (Object)target);
        } else {
            RayTraceResult mop = OrdoLens.rayTrace(worldIn, playerIn, true);
            if (mop != null && mop.func_178782_a() != null && ScanningManager.isThingStillScannable((EntityPlayer)playerIn, (Object)mop.func_178782_a())) {
                ScanningManager.scanTheThing((EntityPlayer)playerIn, (Object)mop.func_178782_a());
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleRenderGameOverlay(World worldIn, EntityPlayer playerIn, ScaledResolution resolution, boolean doubleLens, float partialTicks) {
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) {
            return;
        }
        Entity target = EntityUtils.getPointedEntity((World)worldIn, (Entity)playerIn, (double)1.0, (double)5.0, (float)0.0f, (boolean)true);
        if (target != null) {
            Entity entity = RenderEventHandler.thaumTarget;
            if (entity == null || entity != target) {
                RenderEventHandler.tagscale = 0.0f;
                nameSize = 0.0f;
            }
            RenderEventHandler.thaumTarget = target;
            if (ScanningManager.isThingStillScannable((EntityPlayer)playerIn, (Object)target)) {
                FXDispatcher.INSTANCE.scanHighlight(target);
            }
            return;
        }
        RayTraceResult mop = OrdoLens.rayTrace(worldIn, playerIn, true);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            List itemstacks = Minecraft.func_71410_x().field_71441_e.func_72872_a(EntityItem.class, new AxisAlignedBB(new BlockPos(mop.func_178782_a().func_177958_n(), mop.func_178782_a().func_177956_o() + 1, mop.func_178782_a().func_177952_p())));
            if (!itemstacks.isEmpty() && !((EntityItem)itemstacks.get(0)).func_92059_d().func_190926_b()) {
                OrdoLens.renderNameAndAspects(resolution, AspectHelper.getObjectAspects((ItemStack)((EntityItem)itemstacks.get(0)).func_92059_d()), ((EntityItem)itemstacks.get(0)).func_92059_d().func_82833_r());
                if (ScanningManager.isThingStillScannable((EntityPlayer)playerIn, itemstacks.get(0))) {
                    FXDispatcher.INSTANCE.scanHighlight((Entity)itemstacks.get(0));
                }
            } else {
                RayTraceResult mob = playerIn.func_174822_a(5.0, partialTicks);
                if (mob != null) {
                    Block block = worldIn.func_180495_p(mop.func_178782_a()).func_177230_c();
                    OrdoLens.renderNameAndAspects(resolution, AspectHelper.getObjectAspects((ItemStack)new ItemStack(block)), block.func_149732_F());
                    if (ScanningManager.isThingStillScannable((EntityPlayer)playerIn, (Object)mob.func_178782_a())) {
                        FXDispatcher.INSTANCE.scanHighlight(mop.func_178782_a());
                    }
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleRenderWorldLast(World worldIn, EntityPlayer playerIn, boolean doubleLens, float partialTicks) {
        Entity entity = RenderEventHandler.thaumTarget;
        if (entity != null) {
            if (entity.field_70128_L) {
                RenderEventHandler.thaumTarget = null;
                return;
            }
            double playerOffX = playerIn.field_70169_q + (playerIn.field_70165_t - playerIn.field_70169_q) * (double)partialTicks;
            double playerOffY = playerIn.field_70167_r + (playerIn.field_70163_u - playerIn.field_70167_r) * (double)partialTicks;
            double playerOffZ = playerIn.field_70166_s + (playerIn.field_70161_v - playerIn.field_70166_s) * (double)partialTicks;
            double eOffX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks;
            double eOffY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks;
            double eOffZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
            AspectList aspects = AspectHelper.getEntityAspects((Entity)entity);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-playerOffX), (double)(-playerOffY), (double)(-playerOffZ));
            GlStateManager.func_179137_b((double)eOffX, (double)(eOffY + (double)entity.field_70131_O + (aspects != null && aspects.size() > 0 ? 1.1 : 0.6)), (double)eOffZ);
            GlStateManager.func_179114_b((float)(-playerIn.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (nameSize < 1.0f) {
                nameSize += 0.031f;
            }
            float size = 0.03f * nameSize;
            GlStateManager.func_179152_a((float)size, (float)size, (float)size);
            String name = entity instanceof EntityItem ? ((EntityItem)entity).func_92059_d().func_82833_r() : entity.func_70005_c_();
            Minecraft.func_71410_x().field_71466_p.func_78276_b(name, 1 - Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2, 1, Color.WHITE.getRGB());
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void handleRemoval(World worldIn, EntityPlayer playerIn) {
        if (worldIn.field_72995_K) {
            RenderEventHandler.thaumTarget = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderNameAndAspects(ScaledResolution resolution, AspectList aspects, String text) {
        int w = resolution.func_78326_a();
        int h = resolution.func_78328_b();
        if (aspects != null && aspects.size() > 0) {
            int num = 0;
            int yOff = 0;
            int thisRow = 0;
            int size = 18;
            thisRow = aspects.size() - num < Math.max(5, aspects.size()) ? aspects.size() - num : Math.max(5, aspects.size());
            for (Aspect aspect : aspects.getAspects()) {
                yOff = num / Math.max(5, aspects.size()) * size;
                OrdoLens.drawAspectTag(aspect, aspects.getAmount(aspect), w / 2 - size * thisRow / 2 + size * num, h / 2 + 16 + yOff);
                if (++num % Math.max(5, aspects.size()) != 0) continue;
                thisRow = aspects.size() - num < Math.max(5, aspects.size()) ? aspects.size() - num : Math.max(5, aspects.size());
            }
        }
        if (text.length() > 0) {
            Minecraft.func_71410_x().field_71456_v.func_73731_b(Minecraft.func_71410_x().field_71466_p, text, w / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(text) / 2, h / 2 - 16, 0xFFFFFF);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawAspectTag(Aspect aspect, int amount, int x, int y) {
        Color color = new Color(aspect.getColor());
        GL11.glPushMatrix();
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)0.5f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(aspect.getImage());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_178994_b((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0);
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f).func_181675_d();
        buffer.func_181662_b((double)x, (double)y + 16.0, 0.0).func_187315_a(0.0, 1.0).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f).func_181675_d();
        buffer.func_181662_b((double)x + 16.0, (double)y + 16.0, 0.0).func_187315_a(1.0, 1.0).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f).func_181675_d();
        buffer.func_181662_b((double)x + 16.0, (double)y, 0.0).func_187315_a(1.0, 0.0).func_181666_a((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f).func_181675_d();
        tessellator.func_78381_a();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DecimalFormat myFormatter = new DecimalFormat("#######.##");
        String am = myFormatter.format(amount);
        Minecraft.func_71410_x().field_71466_p.func_78276_b(am, 24 + x * 2, 32 - Minecraft.func_71410_x().field_71466_p.field_78288_b + y * 2, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public static RayTraceResult rayTrace(World worldIn, EntityPlayer playerIn, boolean useLiquids) {
        float f = playerIn.field_70125_A;
        float f1 = playerIn.field_70177_z;
        double d0 = playerIn.field_70165_t;
        double d1 = playerIn.field_70163_u + (double)playerIn.func_70047_e();
        double d2 = playerIn.field_70161_v;
        Vec3d vec3d = new Vec3d(d0, d1, d2);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d3 = playerIn.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d3, (double)f5 * d3, (double)f7 * d3);
        return worldIn.func_147447_a(vec3d, vec3d1, useLiquids, !useLiquids, false);
    }
}

