/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.libs.helpers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import fr.wind_blade.isorropia.common.Common;
import fr.wind_blade.isorropia.common.blocks.BlocksIS;
import fr.wind_blade.isorropia.common.capabilities.LivingCapability;
import fr.wind_blade.isorropia.common.celestial.CelestialBody;
import fr.wind_blade.isorropia.common.celestial.ICelestialBody;
import fr.wind_blade.isorropia.common.config.ConfigContainment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.lib.utils.InventoryUtils;

public class IsorropiaHelper {
    public static GameProfile AUTHOR_GAMEPROFILE = new GameProfile(UUID.fromString("e5528ce9-e498-40e1-833b-2dceee510efb"), "Wind_Blade");
    public static final String ENTITY_ID = "ENTITY_ID";
    public static final String ENTITY_UUID = "ENTITY_UUID";
    public static final String ENTITY_DATA = "ENTITY_DATA";
    public static final Map<UUID, Float> contain = new HashMap<UUID, Float>();
    public static final DataSerializer<Aspect> ASPECT = new DataSerializer<Aspect>(){

        public DataParameter<Aspect> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public void write(PacketBuffer buf, Aspect value) {
            buf.func_180714_a(value != null ? value.getTag() : "");
        }

        public Aspect read(PacketBuffer buf) throws IOException {
            return Aspect.getAspect((String)buf.func_150789_c(Short.MAX_VALUE));
        }

        public Aspect copyValue(Aspect value) {
            return value;
        }
    };

    public static EntityPlayer getOwner(EntityLiving living) {
        EntityPlayer player = living instanceof EntityTameable ? (EntityPlayer)((EntityTameable)living).func_70902_q() : living.field_70170_p.func_152378_a(((LivingCapability)Common.getCap((EntityLivingBase)living)).uuidOwner);
        return player;
    }

    public static boolean canEntityBeJarred(EntityLiving living) {
        switch (ConfigContainment.TYPE.getName()) {
            case "whitelist": {
                return ConfigContainment.ENTRIES.contains(living.getClass());
            }
            case "blacklist": {
                return !ConfigContainment.ENTRIES.contains(living.getClass());
            }
        }
        return false;
    }

    public static boolean doPlayerHaveJar(EntityPlayer player, boolean simulate) {
        boolean flag = InventoryUtils.isPlayerCarryingAmount((EntityPlayer)player, (ItemStack)new ItemStack(BlocksTC.jarNormal, 1), (boolean)false) || player.func_184812_l_();
        boolean bl = flag;
        if (!simulate && !flag) {
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.ITALIC + "" + TextFormatting.GRAY + I18n.func_74838_a((String)"isorropia.containment.jar")));
        }
        return flag;
    }

    public static boolean containEntity(EntityLivingBase owner, EntityLivingBase target, float amount) {
        float progression = (contain.containsKey(target.func_110124_au()) ? contain.get(target.func_110124_au()).floatValue() : 0.0f) + amount;
        contain.put(target.func_110124_au(), Float.valueOf(progression));
        return progression > target.func_110143_aJ() * 20.0f;
    }

    public static void playerJarEntity(EntityPlayer player, EntityLiving target) {
        if (InventoryUtils.consumePlayerItem((EntityPlayer)player, (Item)Item.func_150898_a((Block)BlocksTC.jarNormal), (int)0) || player.func_184812_l_()) {
            ItemStack jar = new ItemStack((Block)BlocksIS.blockJarSoul);
            jar.func_77982_d(IsorropiaHelper.livingToNBT(target));
            if (!player.field_71071_by.func_70441_a(jar)) {
                player.func_70099_a(jar, 1.0f);
            }
            contain.remove(target.func_110124_au());
        }
    }

    public static NBTTagCompound livingToNBT(EntityLiving living) {
        NBTTagCompound nbt = IsorropiaHelper.livingToNBTNoWorld(living);
        living.field_70170_p.func_72900_e((Entity)living);
        return nbt;
    }

    public static NBTTagCompound livingToNBTNoWorld(EntityLiving living) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound entityData = new NBTTagCompound();
        living.func_70039_c(entityData);
        nbt.func_74782_a(ENTITY_DATA, (NBTBase)entityData);
        return nbt;
    }

    public static EntityLiving nbtToLiving(NBTTagCompound nbt, World world, BlockPos pos) {
        EntityLiving living = (EntityLiving)EntityList.func_75615_a((NBTTagCompound)nbt.func_74775_l(ENTITY_DATA), (World)world);
        if (living != null && !living.field_70128_L) {
            living.func_174828_a(pos, 0.0f, 0.0f);
            living.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            world.func_72838_d((Entity)living);
        }
        return living;
    }

    public static NBTTagCompound livingBaseToStatue(EntityLivingBase base) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (base instanceof EntityLiving) {
            nbt = IsorropiaHelper.livingToNBTNoWorld((EntityLiving)base);
            nbt.func_74778_a(ENTITY_ID, "LIVING");
        } else if (base instanceof EntityPlayer) {
            NBTTagCompound profile = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)profile, (GameProfile)((EntityPlayer)base).func_146103_bH());
            nbt.func_74778_a(ENTITY_ID, "PLAYER");
            nbt.func_74782_a(ENTITY_DATA, (NBTBase)profile);
        }
        return nbt;
    }

    public static void profileToStatueData(NBTTagCompound nbt, GameProfile profile) {
        NBTTagCompound data = new NBTTagCompound();
        NBTUtil.func_180708_a((NBTTagCompound)data, (GameProfile)profile);
        nbt.func_74782_a(ENTITY_DATA, (NBTBase)data);
        nbt.func_74778_a(ENTITY_ID, "PLAYER");
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation loadSkin(final MinecraftProfileTexture profileTexture, final MinecraftProfileTexture.Type textureType, final @Nullable SkinManager.SkinAvailableCallback skinAvailableCallback) {
        final ResourceLocation resourcelocation = new ResourceLocation("skins/" + profileTexture.getHash());
        ITextureObject itextureobject = Minecraft.func_71410_x().field_71446_o.func_110581_b(resourcelocation);
        if (itextureobject != null) {
            if (skinAvailableCallback != null) {
                skinAvailableCallback.func_180521_a(textureType, resourcelocation, profileTexture);
            }
        } else {
            File file1 = new File(new File(Minecraft.func_71410_x().field_71412_D, "skins"), profileTexture.getHash().length() > 2 ? profileTexture.getHash().substring(0, 2) : "xx");
            File file2 = new File(file1, profileTexture.getHash());
            final ImageBufferDownload iimagebuffer = textureType == MinecraftProfileTexture.Type.SKIN ? new ImageBufferDownload() : null;
            ThreadDownloadImageData threaddownloadimagedata = new ThreadDownloadImageData(file2, profileTexture.getUrl(), DefaultPlayerSkin.func_177335_a(), new IImageBuffer(){

                public BufferedImage func_78432_a(BufferedImage image) {
                    if (iimagebuffer != null) {
                        image = iimagebuffer.func_78432_a(image);
                    }
                    return image;
                }

                public void func_152634_a() {
                    if (iimagebuffer != null) {
                        iimagebuffer.func_152634_a();
                    }
                    if (skinAvailableCallback != null) {
                        skinAvailableCallback.func_180521_a(textureType, resourcelocation, profileTexture);
                    }
                }
            });
            Minecraft.func_71410_x().field_71446_o.func_110579_a(resourcelocation, (ITextureObject)threaddownloadimagedata);
        }
        return resourcelocation;
    }

    public static Entity getEntityByUUID(UUID uuid, World world) {
        for (Entity e : world.field_72996_f) {
            if (!e.getPersistentID().equals(uuid)) continue;
            return e;
        }
        return null;
    }

    public static ICelestialBody getCurrentCelestialBody(World world) {
        return CelestialBody.isDay(world) ? CelestialBody.SUN : CelestialBody.MOON;
    }

    static {
        DataSerializers.func_187189_a(ASPECT);
    }
}

