/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.network;

import fr.wind_blade.isorropia.common.IsorropiaAPI;
import fr.wind_blade.isorropia.common.lenses.Lens;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class LensRemoveMessage
implements IMessage {
    private Lens rightLens = null;
    private Lens leftLens = null;

    public LensRemoveMessage(Lens rightLens, Lens leftLens) {
        this.rightLens = rightLens;
        this.leftLens = leftLens;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.rightLens = (Lens)IsorropiaAPI.lensRegistry.getValue(buf.readInt());
        }
        if (buf.readBoolean()) {
            this.leftLens = (Lens)IsorropiaAPI.lensRegistry.getValue(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.rightLens != null);
        if (this.rightLens != null) {
            buf.writeInt(IsorropiaAPI.lensRegistry.getID((IForgeRegistryEntry)this.rightLens));
        }
        buf.writeBoolean(this.leftLens != null);
        if (this.leftLens != null) {
            buf.writeInt(IsorropiaAPI.lensRegistry.getID((IForgeRegistryEntry)this.leftLens));
        }
    }

    public LensRemoveMessage() {
    }

    public static class Handler
    implements IMessageHandler<LensRemoveMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(LensRemoveMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (message.rightLens != null) {
                    message.rightLens.handleRemoval(player.field_70170_p, (EntityPlayer)player);
                }
                if (message.leftLens != null) {
                    message.leftLens.handleRemoval(player.field_70170_p, (EntityPlayer)player);
                }
            });
            return null;
        }
    }
}

