/*
 * Decompiled with CFR 0.152.
 */
package fr.wind_blade.isorropia.common.research.recipes;

import fr.wind_blade.isorropia.Isorropia;
import fr.wind_blade.isorropia.common.Common;
import fr.wind_blade.isorropia.common.capabilities.LivingCapability;
import fr.wind_blade.isorropia.common.research.recipes.CurativeInfusionRecipe;
import fr.wind_blade.isorropia.common.tiles.TileVat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class SpecieCurativeInfusionRecipe
extends CurativeInfusionRecipe {
    protected final Class<? extends EntityLiving> result;

    public SpecieCurativeInfusionRecipe(Builder<? extends Builder<?>> builder) {
        super(builder);
        this.result = builder.result;
        if (this.result == null) {
            Isorropia.logger.error("Specie Infusion Recipe can't have a null result");
            FMLCommonHandler.instance().exitJava(1, false);
        }
    }

    @Override
    public void applyWithCheat(EntityPlayer player, EntityLivingBase old, ItemStack stack) {
        EntityLiving entity = (EntityLiving)EntityRegistry.getEntry(this.result).newInstance(old.field_70170_p);
        if (entity == null) {
            return;
        }
        ((LivingCapability)Common.getCap((EntityLivingBase)entity)).uuidOwner = player.func_110124_au();
        entity.func_70080_a(old.field_70165_t, old.field_70163_u, old.field_70165_t, old.field_70177_z, old.field_70125_A);
        old.field_70170_p.func_72838_d((Entity)entity);
        old.field_70170_p.func_72900_e((Entity)old);
        super.applyWithCheat(player, (EntityLivingBase)entity, stack);
    }

    @Override
    public void onInfusionFinish(TileVat vat) {
        EntityLivingBase old = vat.getEntityContained();
        EntityLiving entity = (EntityLiving)EntityRegistry.getEntry(this.result).newInstance(vat.func_145831_w());
        if (entity == null) {
            return;
        }
        ((LivingCapability)Common.getCap((EntityLivingBase)entity)).uuidOwner = vat.getRecipePlayer().func_110124_au();
        entity.func_70080_a(old.field_70165_t, old.field_70163_u, old.field_70165_t, old.field_70177_z, old.field_70125_A);
        vat.func_145831_w().func_72838_d((Entity)entity);
        vat.func_145831_w().func_72900_e((Entity)vat.setEntityContained((EntityLivingBase)entity, old.field_70177_z));
        super.onInfusionFinish(vat);
    }

    public Class<? extends EntityLiving> getResult() {
        return this.result;
    }

    public static class Builder<T extends Builder<T>>
    extends CurativeInfusionRecipe.Builder<T> {
        protected Class<? extends EntityLiving> result = null;

        public T withResult(Class<? extends EntityLiving> result) {
            this.result = result;
            return (T)((Builder)this.self());
        }

        @Override
        public CurativeInfusionRecipe build() {
            return new SpecieCurativeInfusionRecipe(this);
        }
    }
}

