/*
 * Decompiled with CFR 0.152.
 */
package meldexun.asmutil2;

import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import meldexun.asmutil2.Lazy;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public interface ITransformInfo<T extends ClassVisitor> {
    public T visitor(Lazy<ClassWriter> var1);

    public boolean transform(T var1, Lazy<ClassWriter> var2);

    public int writeFlags();

    public int readFlags();

    public static <T extends ClassVisitor> ITransformInfo<T> create(Supplier<T> classVisitorFactory, BiPredicate<T, Lazy<ClassWriter>> transformFunction, int writeFlags, int readFlags) {
        return ITransformInfo.createTransformInfo(classWriter -> (ClassVisitor)classVisitorFactory.get(), transformFunction, writeFlags, readFlags);
    }

    public static <T extends ClassVisitor> ITransformInfo<T> create(Function<ClassWriter, T> classVisitorFactory, BiPredicate<T, Lazy<ClassWriter>> transformFunction, int writeFlags, int readFlags) {
        return ITransformInfo.createTransformInfo(classVisitorFactory.compose(Lazy::get), transformFunction, writeFlags, readFlags);
    }

    public static <T extends ClassVisitor> ITransformInfo<T> createTransformInfo(final Function<Lazy<ClassWriter>, T> classVisitorFactory, final BiPredicate<T, Lazy<ClassWriter>> transformFunction, final int writeFlags, final int readFlags) {
        return new ITransformInfo<T>(){

            @Override
            public T visitor(Lazy<ClassWriter> classWriter) {
                return (ClassVisitor)classVisitorFactory.apply(classWriter);
            }

            @Override
            public boolean transform(T classVisitor, Lazy<ClassWriter> classWriter) {
                return transformFunction.test(classVisitor, classWriter);
            }

            @Override
            public int writeFlags() {
                return writeFlags;
            }

            @Override
            public int readFlags() {
                return readFlags;
            }
        };
    }
}

