/*
 * Decompiled with CFR 0.152.
 */
package meldexun.asmutil2;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public interface SignatureMatcher<T>
extends Predicate<T>,
Consumer<StringBuilder> {
    @Override
    public void accept(StringBuilder var1);

    public static SignatureMatcher<FieldNode> matchingFieldName(String name) {
        return SignatureMatcher.matchingName(Signature::of, name);
    }

    public static SignatureMatcher<FieldNode> matchingFieldNameDesc(String name, String desc) {
        return SignatureMatcher.matchingNameDesc(Signature::of, name, desc);
    }

    public static SignatureMatcher<FieldNode> matchingFieldOwnerNameDesc(String owner, String name, String desc) {
        return SignatureMatcher.matchingOwnerNameDesc(Signature::of, owner, name, desc);
    }

    public static SignatureMatcher<FieldNode> matchingFieldNameObf(String name, String obfName) {
        return SignatureMatcher.matchingNameObf(Signature::of, name, obfName);
    }

    public static SignatureMatcher<FieldNode> matchingFieldNameDescObf(String name, String obfName, String desc) {
        return SignatureMatcher.matchingNameDescObf(Signature::of, name, obfName, desc);
    }

    public static SignatureMatcher<FieldNode> matchingFieldNameDescObf(String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.matchingNameDescObf(Signature::of, name, obfName, desc, obfDesc);
    }

    public static SignatureMatcher<FieldNode> matchingFieldOwnerNameDescObf(String owner, String name, String obfName, String desc) {
        return SignatureMatcher.matchingOwnerNameDescObf(Signature::of, owner, name, obfName, desc);
    }

    public static SignatureMatcher<FieldNode> matchingFieldOwnerNameDescObf(String owner, String obfOwner, String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.matchingOwnerNameDescObf(Signature::of, owner, obfOwner, name, obfName, desc, obfDesc);
    }

    public static SignatureMatcher<MethodNode> matchingMethodName(String name) {
        return SignatureMatcher.matchingName(Signature::of, name);
    }

    public static SignatureMatcher<MethodNode> matchingMethodNameDesc(String name, String desc) {
        return SignatureMatcher.matchingNameDesc(Signature::of, name, desc);
    }

    public static SignatureMatcher<MethodNode> matchingMethodOwnerNameDesc(String owner, String name, String desc) {
        return SignatureMatcher.matchingOwnerNameDesc(Signature::of, owner, name, desc);
    }

    public static SignatureMatcher<MethodNode> matchingMethodNameObf(String name, String obfName) {
        return SignatureMatcher.matchingNameObf(Signature::of, name, obfName);
    }

    public static SignatureMatcher<MethodNode> matchingMethodNameDescObf(String name, String obfName, String desc) {
        return SignatureMatcher.matchingNameDescObf(Signature::of, name, obfName, desc);
    }

    public static SignatureMatcher<MethodNode> matchingMethodNameDescObf(String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.matchingNameDescObf(Signature::of, name, obfName, desc, obfDesc);
    }

    public static SignatureMatcher<MethodNode> matchingMethodOwnerNameDescObf(String owner, String name, String obfName, String desc) {
        return SignatureMatcher.matchingOwnerNameDescObf(Signature::of, owner, name, obfName, desc);
    }

    public static SignatureMatcher<MethodNode> matchingMethodOwnerNameDescObf(String owner, String obfOwner, String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.matchingOwnerNameDescObf(Signature::of, owner, obfOwner, name, obfName, desc, obfDesc);
    }

    public static SignatureMatcher<FieldInsnNode> matchingFieldInsnName(String name) {
        return SignatureMatcher.matchingName(Signature::of, name);
    }

    public static SignatureMatcher<FieldInsnNode> matchingFieldInsnNameDesc(String name, String desc) {
        return SignatureMatcher.matchingNameDesc(Signature::of, name, desc);
    }

    public static SignatureMatcher<FieldInsnNode> matchingFieldInsnOwnerNameDesc(String owner, String name, String desc) {
        return SignatureMatcher.matchingOwnerNameDesc(Signature::of, owner, name, desc);
    }

    public static SignatureMatcher<FieldInsnNode> matchingFieldInsnNameObf(String name, String obfName) {
        return SignatureMatcher.matchingNameObf(Signature::of, name, obfName);
    }

    public static SignatureMatcher<FieldInsnNode> matchingFieldInsnNameDescObf(String name, String obfName, String desc) {
        return SignatureMatcher.matchingNameDescObf(Signature::of, name, obfName, desc);
    }

    public static SignatureMatcher<FieldInsnNode> matchingFieldInsnNameDescObf(String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.matchingNameDescObf(Signature::of, name, obfName, desc, obfDesc);
    }

    public static SignatureMatcher<FieldInsnNode> matchingFieldInsnOwnerNameDescObf(String owner, String name, String obfName, String desc) {
        return SignatureMatcher.matchingOwnerNameDescObf(Signature::of, owner, name, obfName, desc);
    }

    public static SignatureMatcher<FieldInsnNode> matchingFieldInsnOwnerNameDescObf(String owner, String obfOwner, String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.matchingOwnerNameDescObf(Signature::of, owner, obfOwner, name, obfName, desc, obfDesc);
    }

    public static SignatureMatcher<MethodInsnNode> matchingMethodInsnName(String name) {
        return SignatureMatcher.matchingName(Signature::of, name);
    }

    public static SignatureMatcher<MethodInsnNode> matchingMethodInsnNameDesc(String name, String desc) {
        return SignatureMatcher.matchingNameDesc(Signature::of, name, desc);
    }

    public static SignatureMatcher<MethodInsnNode> matchingMethodInsnOwnerNameDesc(String owner, String name, String desc) {
        return SignatureMatcher.matchingOwnerNameDesc(Signature::of, owner, name, desc);
    }

    public static SignatureMatcher<MethodInsnNode> matchingMethodInsnNameObf(String name, String obfName) {
        return SignatureMatcher.matchingNameObf(Signature::of, name, obfName);
    }

    public static SignatureMatcher<MethodInsnNode> matchingMethodInsnNameDescObf(String name, String obfName, String desc) {
        return SignatureMatcher.matchingNameDescObf(Signature::of, name, obfName, desc);
    }

    public static SignatureMatcher<MethodInsnNode> matchingMethodInsnNameDescObf(String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.matchingNameDescObf(Signature::of, name, obfName, desc, obfDesc);
    }

    public static SignatureMatcher<MethodInsnNode> matchingMethodInsnOwnerNameDescObf(String owner, String name, String obfName, String desc) {
        return SignatureMatcher.matchingOwnerNameDescObf(Signature::of, owner, name, obfName, desc);
    }

    public static SignatureMatcher<MethodInsnNode> matchingMethodInsnOwnerNameDescObf(String owner, String obfOwner, String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.matchingOwnerNameDescObf(Signature::of, owner, obfOwner, name, obfName, desc, obfDesc);
    }

    public static <T> SignatureMatcher<T> matchingName(Function<T, Signature> wrapper, String name) {
        return SignatureMatcher.create(wrapper, signature -> name.equals(signature.name()), sb -> sb.append("name=").append(name));
    }

    public static <T> SignatureMatcher<T> matchingNameDesc(Function<T, Signature> wrapper, String name, String desc) {
        return SignatureMatcher.create(wrapper, signature -> name.equals(signature.name()) && desc.equals(signature.desc()), sb -> {
            sb.append("name=").append(name);
            sb.append(" ");
            sb.append("desc=").append(desc);
        });
    }

    public static <T> SignatureMatcher<T> matchingOwnerNameDesc(Function<T, Signature> wrapper, String owner, String name, String desc) {
        return SignatureMatcher.create(wrapper, signature -> owner.equals(signature.owner()) && name.equals(signature.name()) && desc.equals(signature.desc()), sb -> {
            sb.append("owner=").append(owner);
            sb.append(" ");
            sb.append("name=").append(name);
            sb.append(" ");
            sb.append("desc=").append(desc);
        });
    }

    public static <T> SignatureMatcher<T> matchingNameObf(Function<T, Signature> wrapper, String name, String obfName) {
        return SignatureMatcher.create(wrapper, signature -> obfName.equals(signature.name()) || name.equals(signature.name()), sb -> sb.append("name=[").append(name).append(", ").append(obfName).append("]"));
    }

    public static <T> SignatureMatcher<T> matchingNameDescObf(Function<T, Signature> wrapper, String name, String obfName, String desc) {
        return SignatureMatcher.create(wrapper, signature -> (obfName.equals(signature.name()) || name.equals(signature.name())) && desc.equals(signature.desc()), sb -> {
            sb.append("name=[").append(name).append(", ").append(obfName).append("]");
            sb.append(" ");
            sb.append("desc=").append(desc);
        });
    }

    public static <T> SignatureMatcher<T> matchingNameDescObf(Function<T, Signature> wrapper, String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.create(wrapper, signature -> !(!obfName.equals(signature.name()) && !name.equals(signature.name()) || !obfDesc.equals(signature.desc()) && !desc.equals(signature.desc())), sb -> {
            sb.append("name=[").append(name).append(", ").append(obfName).append("]");
            sb.append(" ");
            sb.append("desc=[").append(desc).append(", ").append(obfDesc).append("]");
        });
    }

    public static <T> SignatureMatcher<T> matchingOwnerNameDescObf(Function<T, Signature> wrapper, String owner, String name, String obfName, String desc) {
        return SignatureMatcher.create(wrapper, signature -> owner.equals(signature.owner()) && (obfName.equals(signature.name()) || name.equals(signature.name())) && desc.equals(signature.desc()), sb -> {
            sb.append("owner=").append(owner);
            sb.append(" ");
            sb.append("name=[").append(name).append(", ").append(obfName).append("]");
            sb.append(" ");
            sb.append("desc=").append(desc);
        });
    }

    public static <T> SignatureMatcher<T> matchingOwnerNameDescObf(Function<T, Signature> wrapper, String owner, String obfOwner, String name, String obfName, String desc, String obfDesc) {
        return SignatureMatcher.create(wrapper, signature -> !(!obfOwner.equals(signature.owner()) && !owner.equals(signature.owner()) || !obfName.equals(signature.name()) && !name.equals(signature.name()) || !obfDesc.equals(signature.desc()) && !desc.equals(signature.desc())), sb -> {
            sb.append("owner=[").append(owner).append(", ").append(obfOwner).append("]");
            sb.append(" ");
            sb.append("name=[").append(name).append(", ").append(obfName).append("]");
            sb.append(" ");
            sb.append("desc=[").append(desc).append(", ").append(obfDesc).append("]");
        });
    }

    public static <T> SignatureMatcher<T> create(final Function<T, Signature> wrapper, final Predicate<Signature> predicate, final Consumer<StringBuilder> errorDetailAppender) {
        return new SignatureMatcher<T>(){

            @Override
            public boolean test(T t) {
                return predicate.test(wrapper.apply(t));
            }

            @Override
            public void accept(StringBuilder sb) {
                errorDetailAppender.accept(sb);
            }
        };
    }

    public static interface Signature {
        public String owner();

        public String name();

        public String desc();

        public static Signature of(final String owner, final String name, final String desc) {
            return new Signature(){

                @Override
                public String owner() {
                    return owner;
                }

                @Override
                public String name() {
                    return name;
                }

                @Override
                public String desc() {
                    return desc;
                }
            };
        }

        public static Signature of(FieldNode field) {
            return Signature.of(null, field.name, field.desc);
        }

        public static Signature of(MethodNode method) {
            return Signature.of(null, method.name, method.desc);
        }

        public static Signature of(FieldInsnNode fieldInsn) {
            return Signature.of(fieldInsn.owner, fieldInsn.name, fieldInsn.desc);
        }

        public static Signature of(MethodInsnNode methodInsn) {
            return Signature.of(methodInsn.owner, methodInsn.name, methodInsn.desc);
        }
    }
}

