/*
 * Decompiled with CFR 0.152.
 */
package meldexun.memoryutil;

import java.util.Objects;
import meldexun.memoryutil.MemoryUtil;
import meldexun.memoryutil.UnsafeUtil;
import sun.misc.Unsafe;

public interface MemoryAccess {
    public static MemoryAccess of(long address) {
        return () -> address;
    }

    public static MemoryAccess of(final Object object, final long offset) {
        Objects.requireNonNull(object);
        return new DoubleRegister(){

            @Override
            public Object getObject() {
                return object;
            }

            @Override
            public long getAddress() {
                return offset;
            }
        };
    }

    public static MemoryAccess of(boolean[] array) {
        return MemoryAccess.of(array, Unsafe.ARRAY_BOOLEAN_BASE_OFFSET);
    }

    public static MemoryAccess of(byte[] array) {
        return MemoryAccess.of(array, Unsafe.ARRAY_BYTE_BASE_OFFSET);
    }

    public static MemoryAccess of(short[] array) {
        return MemoryAccess.of(array, Unsafe.ARRAY_SHORT_BASE_OFFSET);
    }

    public static MemoryAccess of(int[] array) {
        return MemoryAccess.of(array, Unsafe.ARRAY_INT_BASE_OFFSET);
    }

    public static MemoryAccess of(long[] array) {
        return MemoryAccess.of(array, Unsafe.ARRAY_LONG_BASE_OFFSET);
    }

    public static MemoryAccess of(float[] array) {
        return MemoryAccess.of(array, Unsafe.ARRAY_FLOAT_BASE_OFFSET);
    }

    public static MemoryAccess of(double[] array) {
        return MemoryAccess.of(array, Unsafe.ARRAY_DOUBLE_BASE_OFFSET);
    }

    public static MemoryAccess of(char[] array) {
        return MemoryAccess.of(array, Unsafe.ARRAY_CHAR_BASE_OFFSET);
    }

    public static void copyMemory(MemoryAccess src, long srcOffset, MemoryAccess dest, long destOffset, long bytes) {
        MemoryUtil.copyMemory(src.getObject(), src.getAddress() + srcOffset, dest.getObject(), dest.getAddress() + destOffset, bytes);
    }

    public Object getObject();

    public long getAddress();

    public boolean getBoolean(long var1);

    public void putBoolean(long var1, boolean var3);

    public byte getByte(long var1);

    public void putByte(long var1, byte var3);

    public short getShort(long var1);

    public void putShort(long var1, short var3);

    public int getInt(long var1);

    public void putInt(long var1, int var3);

    public long getLong(long var1);

    public void putLong(long var1, long var3);

    public float getFloat(long var1);

    public void putFloat(long var1, float var3);

    public double getDouble(long var1);

    public void putDouble(long var1, double var3);

    public char getChar(long var1);

    public void putChar(long var1, char var3);

    public static interface DoubleRegister
    extends MemoryAccess {
        @Override
        default public boolean getBoolean(long offset) {
            return UnsafeUtil.UNSAFE.getBoolean(this.getObject(), this.getAddress() + offset);
        }

        @Override
        default public void putBoolean(long offset, boolean data) {
            UnsafeUtil.UNSAFE.putBoolean(this.getObject(), this.getAddress() + offset, data);
        }

        @Override
        default public byte getByte(long offset) {
            return UnsafeUtil.UNSAFE.getByte(this.getObject(), this.getAddress() + offset);
        }

        @Override
        default public void putByte(long offset, byte data) {
            UnsafeUtil.UNSAFE.putByte(this.getObject(), this.getAddress() + offset, data);
        }

        @Override
        default public short getShort(long offset) {
            return UnsafeUtil.UNSAFE.getShort(this.getObject(), this.getAddress() + offset);
        }

        @Override
        default public void putShort(long offset, short data) {
            UnsafeUtil.UNSAFE.putShort(this.getObject(), this.getAddress() + offset, data);
        }

        @Override
        default public int getInt(long offset) {
            return UnsafeUtil.UNSAFE.getInt(this.getObject(), this.getAddress() + offset);
        }

        @Override
        default public void putInt(long offset, int data) {
            UnsafeUtil.UNSAFE.putInt(this.getObject(), this.getAddress() + offset, data);
        }

        @Override
        default public long getLong(long offset) {
            return UnsafeUtil.UNSAFE.getLong(this.getObject(), this.getAddress() + offset);
        }

        @Override
        default public void putLong(long offset, long data) {
            UnsafeUtil.UNSAFE.putLong(this.getObject(), this.getAddress() + offset, data);
        }

        @Override
        default public float getFloat(long offset) {
            return UnsafeUtil.UNSAFE.getFloat(this.getObject(), this.getAddress() + offset);
        }

        @Override
        default public void putFloat(long offset, float data) {
            UnsafeUtil.UNSAFE.putFloat(this.getObject(), this.getAddress() + offset, data);
        }

        @Override
        default public double getDouble(long offset) {
            return UnsafeUtil.UNSAFE.getDouble(this.getObject(), this.getAddress() + offset);
        }

        @Override
        default public void putDouble(long offset, double data) {
            UnsafeUtil.UNSAFE.putDouble(this.getObject(), this.getAddress() + offset, data);
        }

        @Override
        default public char getChar(long offset) {
            return UnsafeUtil.UNSAFE.getChar(this.getObject(), this.getAddress() + offset);
        }

        @Override
        default public void putChar(long offset, char data) {
            UnsafeUtil.UNSAFE.putChar(this.getObject(), this.getAddress() + offset, data);
        }
    }

    public static interface SingleRegister
    extends MemoryAccess {
        @Override
        default public Object getObject() {
            return null;
        }

        @Override
        default public boolean getBoolean(long offset) {
            return UnsafeUtil.UNSAFE.getBoolean(null, this.getAddress() + offset);
        }

        @Override
        default public void putBoolean(long offset, boolean data) {
            UnsafeUtil.UNSAFE.putBoolean(null, this.getAddress() + offset, data);
        }

        @Override
        default public byte getByte(long offset) {
            return UnsafeUtil.UNSAFE.getByte(this.getAddress() + offset);
        }

        @Override
        default public void putByte(long offset, byte data) {
            UnsafeUtil.UNSAFE.putByte(this.getAddress() + offset, data);
        }

        @Override
        default public short getShort(long offset) {
            return UnsafeUtil.UNSAFE.getShort(this.getAddress() + offset);
        }

        @Override
        default public void putShort(long offset, short data) {
            UnsafeUtil.UNSAFE.putShort(this.getAddress() + offset, data);
        }

        @Override
        default public int getInt(long offset) {
            return UnsafeUtil.UNSAFE.getInt(this.getAddress() + offset);
        }

        @Override
        default public void putInt(long offset, int data) {
            UnsafeUtil.UNSAFE.putInt(this.getAddress() + offset, data);
        }

        @Override
        default public long getLong(long offset) {
            return UnsafeUtil.UNSAFE.getLong(this.getAddress() + offset);
        }

        @Override
        default public void putLong(long offset, long data) {
            UnsafeUtil.UNSAFE.putLong(this.getAddress() + offset, data);
        }

        @Override
        default public float getFloat(long offset) {
            return UnsafeUtil.UNSAFE.getFloat(this.getAddress() + offset);
        }

        @Override
        default public void putFloat(long offset, float data) {
            UnsafeUtil.UNSAFE.putFloat(this.getAddress() + offset, data);
        }

        @Override
        default public double getDouble(long offset) {
            return UnsafeUtil.UNSAFE.getDouble(this.getAddress() + offset);
        }

        @Override
        default public void putDouble(long offset, double data) {
            UnsafeUtil.UNSAFE.putDouble(this.getAddress() + offset, data);
        }

        @Override
        default public char getChar(long offset) {
            return UnsafeUtil.UNSAFE.getChar(this.getAddress() + offset);
        }

        @Override
        default public void putChar(long offset, char data) {
            UnsafeUtil.UNSAFE.putChar(this.getAddress() + offset, data);
        }
    }
}

