/*
 * Decompiled with CFR 0.152.
 */
package keletu.forbiddenmagicre.blocks.tiles;

import keletu.forbiddenmagicre.ConfigFM;
import keletu.forbiddenmagicre.blocks.tiles.TileEntityWrathCage;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import thaumcraft.api.aspects.Aspect;

public class WrathSpawnerLogic {
    final TileEntityWrathCage mobSpawnerEntity;
    public boolean mobSet = false;
    public int spawnDelay = 20;
    private int mobID = 0;
    Aspect aspect = Aspect.DESIRE;
    private boolean slothful = false;
    private int fuel = 0;
    public double mobRotation;
    public double prevMobRotation;
    private final int minSpawnDelay = 200;
    private final int maxSpawnDelay = 300;
    private final int spawnCount = 3;
    private Entity renderEntity;
    private int maxNearbyEntities = 6;
    private final int activatingRangeFromPlayer = 16;
    private int spawnRange = 4;

    WrathSpawnerLogic(TileEntityWrathCage par1TileEntityMobSpawner) {
        this.mobSpawnerEntity = par1TileEntityMobSpawner;
    }

    public int getEntityNameToSpawn() {
        return this.mobID;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public static Class<? extends Entity> getClassFromID(int entityID) {
        EntityEntry entry = (EntityEntry)GameData.getEntityRegistry().getValue(entityID);
        return entry == null ? null : entry.getEntityClass();
    }

    public static Entity createEntityByID(int entityID, World worldIn) {
        EntityEntry entry = (EntityEntry)GameData.getEntityRegistry().getValue(entityID);
        return entry == null ? null : entry.newInstance(worldIn);
    }

    public void setMobID(int par1Str) {
        this.mobID = par1Str;
        this.aspect = ConfigFM.spawnerMobs.containsKey(WrathSpawnerLogic.getClassFromID(this.mobID)) ? Aspect.getAspect((String)ConfigFM.spawnerMobs.get(WrathSpawnerLogic.getClassFromID(this.mobID))) : Aspect.DESIRE;
    }

    public void mobIsSet(boolean inp) {
        this.mobSet = inp;
    }

    public boolean isMobSet() {
        return this.mobSet;
    }

    public void updateSpawnerBlock(int par1) {
        this.mobSpawnerEntity.func_145831_w().func_175641_c(this.mobSpawnerEntity.func_174877_v(), Blocks.field_150474_ac, par1, 0);
    }

    public World getSpawnerWorld() {
        return this.mobSpawnerEntity.func_145831_w();
    }

    public int getSpawnerX() {
        return this.mobSpawnerEntity.func_174877_v().func_177958_n();
    }

    public int getSpawnerY() {
        return this.mobSpawnerEntity.func_174877_v().func_177956_o();
    }

    public int getSpawnerZ() {
        return this.mobSpawnerEntity.func_174877_v().func_177952_p();
    }

    public void updateSpawner() {
        IBlockState iblockstate = this.getSpawnerWorld().func_180495_p(new BlockPos(this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ()));
        if (!this.mobSet) {
            return;
        }
        if (this.getSpawnerWorld().field_72995_K && (this.fuel > 0 || ConfigFM.wrathCost <= 0)) {
            double d1 = (float)this.getSpawnerX() + this.getSpawnerWorld().field_73012_v.nextFloat();
            double d2 = (float)this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextFloat();
            double d0 = (float)this.getSpawnerZ() + this.getSpawnerWorld().field_73012_v.nextFloat();
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.prevMobRotation = this.mobRotation;
            this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
        } else {
            if (ConfigFM.wrathCost > 0 && this.fuel <= 0) {
                if (this.mobSpawnerEntity.special >= ConfigFM.wrathCost) {
                    this.mobSpawnerEntity.special -= ConfigFM.wrathCost;
                    this.slothful = false;
                    this.fuel = ConfigFM.wrathEff;
                    this.mobSpawnerEntity.func_145831_w().func_184138_a(new BlockPos(this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ()), iblockstate, iblockstate, 0);
                } else if (this.mobSpawnerEntity.wrath >= ConfigFM.wrathCost) {
                    this.mobSpawnerEntity.wrath -= ConfigFM.wrathCost;
                    this.slothful = false;
                    this.fuel = ConfigFM.wrathEff;
                    this.mobSpawnerEntity.func_145831_w().func_184138_a(new BlockPos(this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ()), iblockstate, iblockstate, 0);
                } else if (this.mobSpawnerEntity.sloth >= ConfigFM.wrathCost) {
                    this.mobSpawnerEntity.sloth -= ConfigFM.wrathCost;
                    this.slothful = true;
                    this.fuel = ConfigFM.wrathEff;
                    this.mobSpawnerEntity.func_145831_w().func_184138_a(new BlockPos(this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ()), iblockstate, iblockstate, 0);
                }
            }
            if (this.spawnDelay == -1) {
                this.updateDelay();
            }
            if (this.fuel <= 0 && ConfigFM.wrathCost > 0) {
                return;
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
                return;
            }
            for (int i = 0; i < this.spawnCount && (this.fuel > 0 || ConfigFM.wrathCost <= 0); ++i) {
                Entity entity = WrathSpawnerLogic.createEntityByID(this.getEntityNameToSpawn(), this.getSpawnerWorld());
                if (entity == null) {
                    return;
                }
                int j = this.getSpawnerWorld().func_72872_a(entity.getClass(), new AxisAlignedBB((double)this.getSpawnerX(), (double)this.getSpawnerY(), (double)this.getSpawnerZ(), (double)(this.getSpawnerX() + 1), (double)(this.getSpawnerY() + 1), (double)(this.getSpawnerZ() + 1)).func_72321_a((double)(this.spawnRange * 2), 4.0, (double)(this.spawnRange * 2))).size();
                if (j >= this.maxNearbyEntities) {
                    this.updateDelay();
                    return;
                }
                double d0 = (double)this.getSpawnerX() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                double d3 = this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextInt(3) - 1;
                double d4 = (double)this.getSpawnerZ() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                entity.func_70012_b(d0, d3, d4, this.getSpawnerWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (this.entityCanSpawn(entityliving)) {
                    this.spawnMob(entity);
                    if (entityliving != null) {
                        entityliving.func_70656_aK();
                        --this.fuel;
                    }
                    this.updateDelay();
                    continue;
                }
                if (entityliving == null) continue;
                entityliving.field_70128_L = true;
            }
        }
    }

    public boolean entityCanSpawn(EntityLiving entity) {
        return entity.field_70170_p.func_72855_b(entity.func_174813_aQ()) && entity.field_70170_p.func_72872_a(entity.getClass(), entity.func_174813_aQ()).isEmpty() && !entity.field_70170_p.func_72953_d(entity.func_174813_aQ());
    }

    private void updateDelay() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        if (this.slothful) {
            this.spawnDelay += 200;
        }
        this.updateSpawnerBlock(1);
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.mobID = par1NBTTagCompound.func_74762_e("EntityId");
        this.aspect = ConfigFM.spawnerMobs.containsKey(WrathSpawnerLogic.getClassFromID(this.mobID)) ? Aspect.getAspect((String)ConfigFM.spawnerMobs.get(WrathSpawnerLogic.getClassFromID(this.mobID))) : Aspect.DESIRE;
        this.mobSet = par1NBTTagCompound.func_74767_n("MobSet");
        this.slothful = par1NBTTagCompound.func_74767_n("Slothful");
        this.fuel = par1NBTTagCompound.func_74765_d("Fuel");
        this.spawnDelay = par1NBTTagCompound.func_74765_d("Delay");
        if (par1NBTTagCompound.func_74764_b("MaxNearbyEntities")) {
            this.maxNearbyEntities = par1NBTTagCompound.func_74765_d("MaxNearbyEntities");
        }
        if (par1NBTTagCompound.func_74764_b("SpawnRange")) {
            this.spawnRange = par1NBTTagCompound.func_74765_d("SpawnRange");
        }
        if (this.getSpawnerWorld() != null && this.getSpawnerWorld().field_72995_K) {
            this.renderEntity = null;
        }
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74768_a("EntityId", this.getEntityNameToSpawn());
        par1NBTTagCompound.func_74757_a("MobSet", this.mobSet);
        par1NBTTagCompound.func_74757_a("Slothful", this.slothful);
        par1NBTTagCompound.func_74777_a("Fuel", (short)this.fuel);
        par1NBTTagCompound.func_74777_a("Delay", (short)this.spawnDelay);
        par1NBTTagCompound.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        par1NBTTagCompound.func_74777_a("SpawnRange", (short)this.spawnRange);
    }

    public Entity spawnMob(Entity par1Entity) {
        if (par1Entity instanceof EntityLivingBase && par1Entity.field_70170_p != null) {
            ((EntityLiving)par1Entity).func_180482_a(this.getSpawnerWorld().func_175649_E(par1Entity.func_180425_c()), null);
            AnvilChunkLoader.func_186052_a((Entity)par1Entity, (World)this.getSpawnerWorld());
        }
        return par1Entity;
    }

    public boolean setDelayToMin(int par1) {
        if (par1 == 1 && this.getSpawnerWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getEntityForRender() {
        if (this.renderEntity == null) {
            Entity entity = WrathSpawnerLogic.createEntityByID(this.getEntityNameToSpawn(), null);
            this.renderEntity = entity = this.spawnMob(entity);
        }
        return this.renderEntity;
    }
}

