/*
 * Decompiled with CFR 0.152.
 */
package keletu.forbiddenmagicre.compat.psi;

import keletu.forbiddenmagicre.compat.botania.flowers.SubTileMindLotus;
import net.minecraft.tileentity.TileEntity;
import vazkii.botania.api.subtile.ISubTileContainer;
import vazkii.botania.api.subtile.SubTileEntity;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickGenMana
extends PieceTrick {
    SpellParam position;
    SpellParam power;
    SpellParam stability;

    public PieceTrickGenMana(Spell spell) {
        super(spell);
    }

    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.GREEN, false, false);
        this.addParam(this.position);
        this.power = new ParamNumber("psi.spellparam.power", SpellParam.RED, false, true);
        this.addParam(this.power);
        this.stability = new ParamNumber("psi.spellparam.stability", SpellParam.PURPLE, true, true);
        this.addParam(this.stability);
    }

    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        Double powerVal = (Double)this.getParamEvaluation(this.power);
        Double stabVal = (Double)this.getParamEvaluation(this.stability);
        if (powerVal == null || powerVal <= 0.0) {
            throw new SpellCompilationException("psi.spellerror.nonpositivevalue", this.x, this.y);
        }
        if (stabVal == null || stabVal < 0.0) {
            stabVal = 0.0;
        }
        double absPower = Math.max(Math.abs(powerVal), 1.0);
        double abstability = Math.abs(stabVal);
        double abstotal = absPower + abstability;
        meta.addStat(EnumSpellStat.POTENCY, (int)this.multiplySafe(abstotal, new double[]{abstotal, 5.0}));
        meta.addStat(EnumSpellStat.COST, (int)this.multiplySafe(abstotal, new double[]{100.0}));
    }

    public Object execute(SpellContext context) throws SpellRuntimeException {
        SubTileMindLotus lotus;
        if (context.caster.field_70170_p.field_72995_K) {
            return null;
        }
        Vector3 targetPos = (Vector3)this.getParamValue(context, this.position);
        Double powerVal = (Double)this.getParamValue(context, this.power);
        Double stabVal = (Double)this.getParamValue(context, this.stability);
        if (stabVal == null || stabVal < 0.0) {
            stabVal = 0.0;
        }
        int burnout = 50 * Math.max(10 - stabVal.intValue(), 0);
        TileEntity tile = context.caster.field_70170_p.func_175625_s(targetPos.toBlockPos());
        if (tile == null) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        if (!(tile instanceof ISubTileContainer)) {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        SubTileEntity subtile = ((ISubTileContainer)tile).getSubTile();
        if (subtile instanceof SubTileMindLotus) {
            lotus = (SubTileMindLotus)subtile;
            lotus.passiveDecayTicks += burnout;
        } else {
            throw new SpellRuntimeException("psi.spellerror.nulltarget");
        }
        lotus.addMana(powerVal.intValue() * 150);
        return null;
    }
}

