/*
 * Decompiled with CFR 0.152.
 */
package keletu.forbiddenmagicre.init;

import keletu.forbiddenmagicre.LogHandler;
import keletu.forbiddenmagicre.compat.Compat;
import keletu.forbiddenmagicre.enchantments.EnchantmentsFM;
import keletu.forbiddenmagicre.enchantments.inchantment.EnumInfusionEnchantmentFM;
import keletu.forbiddenmagicre.enchantments.inchantment.InfusionEnchantmentRecipeFM;
import keletu.forbiddenmagicre.init.ModBlocks;
import keletu.forbiddenmagicre.init.ModItems;
import keletu.forbiddenmagicre.items.tools.ItemDragonslayer;
import keletu.forbiddenmagicre.util.CompatIsorropia;
import keletu.forbiddenmagicre.util.RegistryHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.Level;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.IngredientNBTTC;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class InitRecipes {
    public static final Aspect ENVY;
    public static final Aspect GLUTTONY;
    public static final Aspect LUST;
    public static final Aspect NETHER;
    public static final Aspect PRIDE;
    public static final Aspect SLOTH;
    public static final Aspect WRATH;
    private static final ResourceLocation defaultGroup;

    public static void initRecipes() {
        InitRecipes.initArcaneRecipes();
        InitRecipes.initCrucibleRecipes();
        InitRecipes.initInfusionRecipes();
        if (Loader.isModLoaded((String)"botania")) {
            InitRecipes.initBotaniaRecipe();
        }
    }

    private static void initArcaneRecipes() {
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "arcane_to_tainted_stone"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TAINTED_BLOCKS", 50, new AspectList(), new ItemStack(ModBlocks.BLOCKSTONETAINTED, 9, 0), new Object[]{"AAA", "ATA", "AAA", Character.valueOf('T'), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), Character.valueOf('A'), new ItemStack(BlocksTC.stoneArcane)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "crystal_scribing_tools"), (IArcaneRecipe)new ShapelessArcaneRecipe(defaultGroup, "FM_CRYSTAL_SCRIBING_TOOLS", 15, new AspectList(), new ItemStack(ModItems.CRYSTAL_WELL), new Object[]{ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.MIND), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.MIND), "dyeBlack", new ItemStack(ItemsTC.scribingTools, 1, Short.MAX_VALUE)}));
    }

    private static void initCrucibleRecipes() {
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "fm_black_rose"), (CrucibleRecipe)new CrucibleRecipe("SAVE_THE_SQUID", new ItemStack(ModBlocks.BLACK_FLOWER_BUSH), (Object)new ItemStack((Block)Blocks.field_150398_cm, 1, 4), new AspectList().add(Aspect.DARKNESS, 30).add(Aspect.LIFE, 30)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "fm_emerald_DUPE"), (CrucibleRecipe)new CrucibleRecipe("EMERALD_DUPE", new ItemStack(ModItems.ResourceFM, 4, 0), (Object)new ItemStack(ModItems.ResourceFM, 1, 0), new AspectList().add(Aspect.CRYSTAL, 8).add(Aspect.DESIRE, 8)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "fm_tainted_sapling"), (CrucibleRecipe)new CrucibleRecipe("TAINTED_BLOCKS", new ItemStack(ModBlocks.BLOCK_SAPLING_TAINTED), (Object)new ItemStack(Blocks.field_150345_g, 1, 0), new AspectList().add(Aspect.DEATH, 30).add(Aspect.FLUX, 30)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "fm_mob_crystal"), (CrucibleRecipe)new CrucibleRecipe("WRATH_CAGE@1", new ItemStack(ModItems.MOB_CRYSTAL), (Object)new ItemStack(Items.field_151045_i), new AspectList().add(Aspect.MIND, 20).add(Aspect.ENERGY, 20)));
    }

    private static void initInfusionRecipes() {
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "morph_shovel"), (InfusionRecipe)new InfusionRecipe("MORPH_TOOLS", (Object)new ItemStack((Item)ModItems.MorphShovel), 1, new AspectList().add(Aspect.TOOL, 30).add(Aspect.SENSES, 30).add(ENVY, 30), (Object)new ItemStack(ItemsTC.thaumiumShovel), new Object[]{new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(BlocksTC.logSilverwood)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "morph_axe"), (InfusionRecipe)new InfusionRecipe("MORPH_TOOLS", (Object)new ItemStack((Item)ModItems.MorphAxe), 1, new AspectList().add(Aspect.TOOL, 15).add(Aspect.SENSES, 30).add(ENVY, 30).add(Aspect.AVERSION, 15), (Object)new ItemStack(ItemsTC.thaumiumAxe), new Object[]{new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(BlocksTC.logSilverwood)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "morph_pick"), (InfusionRecipe)new InfusionRecipe("MORPH_TOOLS", (Object)new ItemStack((Item)ModItems.MorphPickaxe), 1, new AspectList().add(Aspect.TOOL, 30).add(Aspect.SENSES, 30).add(ENVY, 30), (Object)new ItemStack(ItemsTC.thaumiumPick), new Object[]{new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(BlocksTC.logSilverwood)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "morph_sword"), (InfusionRecipe)new InfusionRecipe("MORPH_TOOLS", (Object)new ItemStack((Item)ModItems.MorphSword), 1, new AspectList().add(Aspect.AVERSION, 30).add(Aspect.SENSES, 30).add(ENVY, 30), (Object)new ItemStack(ItemsTC.thaumiumSword), new Object[]{new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(BlocksTC.logSilverwood)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "distortion_pick"), (InfusionRecipe)new InfusionRecipe("DISTORTION_PICK", (Object)new ItemStack((Item)ModItems.DISTORTIONPICK), 1, new AspectList().add(Aspect.ENTROPY, 30).add(Aspect.TOOL, 30).add(Aspect.FLUX, 45), (Object)new ItemStack(ItemsTC.thaumiumPick), new Object[]{new ItemStack(ItemsTC.nuggets, 1, 10), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.ENTROPY), new ItemStack(BlocksTC.logGreatwood)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "skull_axe"), (InfusionRecipe)new InfusionRecipe("SKULLAXE", (Object)new ItemStack((Item)ModItems.SkullAxe), 1, new AspectList().add(Aspect.AVERSION, 60).add(NETHER, 30).add(WRATH, 30), (Object)new ItemStack(ItemsTC.thaumiumAxe), new Object[]{new ItemStack(ModItems.ResourceNS, 1, 0), new ItemStack(ModItems.ResourceNS, 1, 0), "gemDiamond", new ItemStack(Items.field_151144_bL, 1, 1)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "arcane_cake"), (InfusionRecipe)new InfusionRecipe("FM_ARCANECAKE", (Object)new ItemStack(ModBlocks.BLOCK_ARCANE_CAKE), 3, new AspectList().add(Aspect.DESIRE, 30).add(GLUTTONY, 30).add(SLOTH, 30).add(Aspect.CRAFT, 45), (Object)new ItemStack(Items.field_151105_aU), new Object[]{new ItemStack(ItemsTC.salisMundus), new ItemStack(Items.field_151110_aK), new ItemStack((Item)ModItems.GluttonyShard), new ItemStack(Items.field_151117_aB), new ItemStack(Items.field_151110_aK), new ItemStack((Item)ModItems.GluttonyShard)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "wrath_cage"), (InfusionRecipe)new InfusionRecipe("WRATH_CAGE", (Object)new ItemStack(ModBlocks.WRATH_CAGE), 10, new AspectList().add(RegistryHandler.WRATH, 125).add(Aspect.MAGIC, 125).add(Aspect.BEAST, 125).add(Aspect.MECHANISM, 75).add(SLOTH, 75), (Object)new ItemStack(BlocksTC.metalBlockThaumium), new Object[]{new ItemStack(Items.field_151045_i), new ItemStack(ModItems.ResourceNS, 1, 0), new ItemStack(BlocksTC.jarNormal), new ItemStack(Items.field_151045_i), new ItemStack(ModItems.ResourceNS, 1, 0), new ItemStack(BlocksTC.jarNormal), new ItemStack(Items.field_151045_i), new ItemStack(ModItems.ResourceNS, 1, 0), new ItemStack(BlocksTC.jarNormal), new ItemStack(Items.field_151045_i), new ItemStack(ModItems.ResourceNS, 1, 0), new ItemStack(BlocksTC.jarNormal)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "diabolist_fork"), (InfusionRecipe)new InfusionRecipe("DIABOLIST_FORK", (Object)new ItemStack((Item)ModItems.DIABOLISTFORK), 1, new AspectList().add(RegistryHandler.NETHER, 15).add(Aspect.MECHANISM, 15).add(Aspect.ENERGY, 15), (Object)new ItemStack(ItemsTC.thaumiumSword), new Object[]{new ItemStack(Items.field_151137_ax), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "PureShovel"), (InfusionRecipe)new InfusionRecipe("PURESHOVEL", (Object)new ItemStack(ModItems.shovelPurifier), 2, new AspectList().add(Aspect.LIFE, 40).add(Aspect.LIGHT, 40).add(Aspect.TOOL, 40), (Object)new ItemStack(ItemsTC.thaumiumShovel, 1, Short.MAX_VALUE), new Object[]{ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AURA, (int)1), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.AURA, (int)1), new ItemStack(ItemsTC.quicksilver), new ItemStack(ItemsTC.nuggets, 1, 10), new ItemStack(BlocksTC.logSilverwood)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "RingNutrition"), (InfusionRecipe)new InfusionRecipe("RINGNUTRITION", (Object)new ItemStack(ModItems.ringNutrition), 1, new AspectList().add(RegistryHandler.GLUTTONY, 20).add(Aspect.ALCHEMY, 20).add(Aspect.ENERGY, 20), (Object)new ItemStack(ItemsTC.baubles, 1, 5), new Object[]{new ItemStack((Item)ModItems.GluttonyShard), new ItemStack((Item)ModItems.GluttonyShard), new ItemStack((Item)ModItems.GluttonyShard)}));
        try {
            Item ingot = Items.field_151042_j;
            Item sword = Items.field_151040_l;
            if (Loader.isModLoaded((String)"twilightforest")) {
                try {
                    ingot = Compat.getItem("twilightforest", "knightmetal_ingot");
                    sword = Compat.getItem("twilightforest", "knightmetal_sword");
                }
                catch (Exception e) {
                    LogHandler.log(Level.INFO, e, "Forbidden Magic couldn't figure out Twilight Forest's progression.");
                }
            }
            ((ItemDragonslayer)ModItems.DRAGONSLAYER).repair = ingot;
            ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "dragon_slayer"), (InfusionRecipe)new InfusionRecipe("DRAGONSLAYER", (Object)new ItemStack(ModItems.DRAGONSLAYER, 1), 6, new AspectList().add(Aspect.LIGHT, 60).add(Aspect.ORDER, 60).add(Aspect.MAN, 60).add(PRIDE, 40).add(Aspect.METAL, 100), (Object)new ItemStack(sword), new Object[]{new ItemStack(Items.field_151156_bN, 1), new ItemStack((Item)Items.field_151169_ag, 1, 0), new ItemStack(Items.field_151099_bA, 1), new ItemStack(ModItems.ResourceNS, 1, 2)}));
        }
        catch (Exception e) {
            LogHandler.log(Level.INFO, e, "Forbidden Magic wasn't unbalanced enough for Draconic Evolution.");
        }
        ItemStack wrath = new ItemStack((Item)ModItems.DIABOLISTFORK);
        EnumInfusionEnchantmentFM.addInfusionEnchantment(wrath, EnchantmentsFM.wrath, 1);
        InfusionEnchantmentRecipeFM IECONWRATH = new InfusionEnchantmentRecipeFM(EnchantmentsFM.wrath, new AspectList().add(WRATH, 30).add(Aspect.AVERSION, 30).add(NETHER, 20), new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(ModItems.ResourceNS, 1, 0));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IEWRATH"), (InfusionRecipe)IECONWRATH);
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IEWRATHFAKE"), (Object)((Object)new InfusionEnchantmentRecipeFM(IECONWRATH, wrath)));
        ItemStack greedy = new ItemStack(Items.field_151010_B);
        EnumInfusionEnchantmentFM.addInfusionEnchantment(greedy, EnchantmentsFM.greedy, 1);
        InfusionEnchantmentRecipeFM IEGREEDY = new InfusionEnchantmentRecipeFM(EnchantmentsFM.greedy, new AspectList().add(Aspect.EARTH, 20).add(Aspect.ORDER, 20).add(Aspect.DESIRE, 50), new IngredientNBTTC(new ItemStack(ItemsTC.salisMundus)), new ItemStack(BlocksTC.hungryChest), new ItemStack(Items.field_151166_bC), new ItemStack(ModItems.ResourceNS, 1, 5), new ItemStack(ModItems.ResourceNS, 1, 5));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IEGREEDY"), (InfusionRecipe)IEGREEDY);
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IEGREEDYFAKE"), (Object)((Object)new InfusionEnchantmentRecipeFM(IEGREEDY, greedy)));
        ItemStack consuming = new ItemStack(Items.field_151005_D);
        EnumInfusionEnchantmentFM.addInfusionEnchantment(consuming, EnchantmentsFM.consuming, 1);
        InfusionEnchantmentRecipeFM IECONSUMING = new InfusionEnchantmentRecipeFM(EnchantmentsFM.consuming, new AspectList().add(Aspect.FIRE, 40).add(SLOTH, 40).add(Aspect.VOID, 40), new IngredientNBTTC(new ItemStack(ItemsTC.salisMundus)), new ItemStack(Items.field_151035_b), new ItemStack(Items.field_151129_at), new ItemStack(ModItems.ResourceNS, 1, 4), new ItemStack(ModItems.ResourceNS, 1, 4));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IECONSUMING"), (InfusionRecipe)IECONSUMING);
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IECONSUMINGFAKE"), (Object)((Object)new InfusionEnchantmentRecipeFM(IECONSUMING, consuming)));
        ItemStack educational = new ItemStack(Items.field_151048_u);
        EnumInfusionEnchantmentFM.addInfusionEnchantment(educational, EnchantmentsFM.educational, 1);
        InfusionEnchantmentRecipeFM IECEDU = new InfusionEnchantmentRecipeFM(EnchantmentsFM.educational, new AspectList().add(Aspect.MIND, 30).add(Aspect.MAGIC, 20).add(Aspect.AVERSION, 20), new IngredientNBTTC(new ItemStack(Items.field_151134_bR)), new ItemStack(ItemsTC.brain));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IECEDU"), (InfusionRecipe)IECEDU);
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IECEDUFAKE"), (Object)((Object)new InfusionEnchantmentRecipeFM(IECEDU, educational)));
        ItemStack voidtouched = new ItemStack((Item)ModItems.MorphPickaxe);
        EnumInfusionEnchantmentFM.addInfusionEnchantment(voidtouched, EnchantmentsFM.void_touched, 1);
        InfusionEnchantmentRecipeFM IECVOID = new InfusionEnchantmentRecipeFM(EnchantmentsFM.void_touched, new AspectList().add(Aspect.ELDRITCH, 50).add(ENVY, 30).add(Aspect.DARKNESS, 50).add(Aspect.VOID, 50), new IngredientNBTTC(new ItemStack(ItemsTC.salisMundus)), "ingotVoid", "ingotVoid", "ingotVoid", "ingotVoid", new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(ModItems.ResourceNS, 1, 1), new ItemStack(ModItems.ResourceNS, 1, 1));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IECVOID"), (InfusionRecipe)IECVOID);
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre:IECVOIDFAKE"), (Object)((Object)new InfusionEnchantmentRecipeFM(IECVOID, voidtouched)));
    }

    private static void initBotaniaRecipe() {
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "whisper_weed"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "MAGICAL_FLOWER", 100, new AspectList(), ItemBlockSpecialFlower.ofType((String)"whisperweed"), new Object[]{"GMR", "Wgp", "BA ", Character.valueOf('G'), new ItemStack((Block)Blocks.field_150329_H, 1, 1), Character.valueOf('M'), "manaDiamond", Character.valueOf('R'), new ItemStack(vazkii.botania.common.item.ModItems.manaResource, 1, 6), Character.valueOf('W'), new ItemStack(ItemsTC.curio, 1, 5), Character.valueOf('g'), "petalGray", Character.valueOf('p'), "petalPink", Character.valueOf('B'), "runeEnvyB", Character.valueOf('A'), "gemAmber"}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "astral_bloom"), (InfusionRecipe)new InfusionRecipe("MAGICAL_FLOWER", (Object)ItemBlockSpecialFlower.ofType((String)"astralbloom"), 4, new AspectList().add(Aspect.LIGHT, 60).add(Aspect.AURA, 15).add(Aspect.LIFE, 40), (Object)new ItemStack(BlocksTC.shimmerleaf), new Object[]{new ItemStack(ItemsTC.filter), new ItemStack(ItemsTC.filter), "manaDiamond", new ItemStack(vazkii.botania.common.item.ModItems.manaResource, 1, 6), "petalLightBlue", "petalLightGray", "runePrideB", "runeAirB"}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "euclidaisy"), (InfusionRecipe)new InfusionRecipe("MAGICAL_FLOWER", (Object)ItemBlockSpecialFlower.ofType((String)"euclidaisy"), 4, new AspectList().add(Aspect.ELDRITCH, 40).add(Aspect.AURA, 15).add(Aspect.PLANT, 30), (Object)"mysticFlowerPink", new Object[]{new ItemStack(ItemsTC.salisMundus), "manaPearl", new ItemStack(vazkii.botania.common.item.ModItems.manaResource, 1, 6), "petalPink", "petalPink", "runeSlothB", "runeGreedB"}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("forbiddenmagicre", "tainthistle"), (InfusionRecipe)new InfusionRecipe("MAGICAL_FLOWER", (Object)ItemBlockSpecialFlower.ofType((String)"tainthistle"), 4, new AspectList().add(Aspect.AIR, 30).add(Aspect.WATER, 30).add(RegistryHandler.GLUTTONY, 30).add(Aspect.FLUX, 45), (Object)ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), new Object[]{new ItemStack(vazkii.botania.common.item.ModItems.petal, 1, 10), new ItemStack(vazkii.botania.common.item.ModItems.petal, 1, 10), new ItemStack(vazkii.botania.common.item.ModItems.petal, 1, 10), "runeManaB", "runeGluttonyB"}));
    }

    static {
        if (Loader.isModLoaded((String)"isorropia")) {
            WRATH = CompatIsorropia.WRATH;
            ENVY = CompatIsorropia.ENVY;
            GLUTTONY = CompatIsorropia.GLUTTONY;
            LUST = CompatIsorropia.LUST;
            NETHER = CompatIsorropia.NETHER;
            PRIDE = CompatIsorropia.PRIDE;
            SLOTH = CompatIsorropia.SLOTH;
        } else {
            WRATH = RegistryHandler.WRATH;
            ENVY = RegistryHandler.ENVY;
            GLUTTONY = RegistryHandler.GLUTTONY;
            LUST = RegistryHandler.LUST;
            NETHER = RegistryHandler.NETHER;
            PRIDE = RegistryHandler.PRIDE;
            SLOTH = RegistryHandler.SLOTH;
        }
        defaultGroup = new ResourceLocation("");
    }
}

