/*
 * Decompiled with CFR 0.152.
 */
package keletu.forbiddenmagicre.items.tools;

import cofh.redstoneflux.api.IEnergyContainerItem;
import keletu.forbiddenmagicre.ReForbiddenMagic;
import keletu.forbiddenmagicre.init.ModItems;
import keletu.forbiddenmagicre.util.IHasModel;
import keletu.forbiddenmagicre.util.RegistryHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemDragonslayer
extends ItemSword
implements IHasModel {
    public Item repair;

    public ItemDragonslayer() {
        super(Item.ToolMaterial.DIAMOND);
        this.setRegistryName("dragon_slayer");
        this.func_77655_b("sword_dragon_slayer");
        this.func_77637_a(ReForbiddenMagic.tab);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModItems.ITEMS.add((Item)this);
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack stack2) {
        return stack2.func_77973_b() == this.repair || super.func_82789_a(stack, stack2);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase victim, EntityLivingBase player) {
        stack.func_77972_a(1, player);
        if (!victim.field_70170_p.field_72995_K && ItemDragonslayer.isDragon((Entity)victim)) {
            ItemDragonslayer.absoluteDamage(victim, new EntityDamageSource("dragonslayer", (Entity)player).func_76348_h(), Math.max(4.0f, victim.func_110138_aP() / 5.0f));
            if (victim instanceof EntityPlayer) {
                EntityPlayer target = (EntityPlayer)victim;
                for (EntityEquipmentSlot x : EntityEquipmentSlot.values()) {
                    ItemStack equip;
                    if (target.func_184582_a(x) == ItemStack.field_190927_a || !((equip = target.func_184582_a(x)).func_77973_b() instanceof IEnergyContainerItem)) continue;
                    IEnergyContainerItem battery = (IEnergyContainerItem)equip.func_77973_b();
                    battery.extractEnergy(equip, battery.getMaxEnergyStored(equip) / 20, false);
                }
            }
            victim.func_70690_d(new PotionEffect((Potion)RegistryHandler.dragonwrack, 300));
        }
        return true;
    }

    public static boolean isDragon(Entity target) {
        if (target == null) {
            return false;
        }
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            for (EntityEquipmentSlot x : EntityEquipmentSlot.values()) {
                String id;
                if (player.func_184582_a(x) == ItemStack.field_190927_a || (id = ModItems.DRAGONSLAYER.getCreatorModId(player.func_184582_a(x))) == null || !id.equals("draconicevolution")) continue;
                return true;
            }
        } else if (target instanceof EntityDragon || target.func_70005_c_().toLowerCase().contains("dragon") || target.func_70005_c_().toLowerCase().contains("drake") || target.func_70005_c_().toLowerCase().contains("dracon")) {
            return true;
        }
        return false;
    }

    public static void absoluteDamage(EntityLivingBase target, DamageSource src, float damage) {
        target.func_110142_aN().func_94547_a(src, target.func_110143_aJ(), damage);
        target.func_70606_j(target.func_110143_aJ() - damage);
        if (target.func_110143_aJ() < 1.0f) {
            target.func_70645_a(src);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGetHurt(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack equip;
        if (event.getEntityLiving() instanceof EntityPlayer && event.getSource().func_76346_g() != null && (equip = (player = (EntityPlayer)event.getEntityLiving()).func_184614_ca()) != ItemStack.field_190927_a && equip.func_77973_b() == this && ItemDragonslayer.isDragon(event.getSource().func_76346_g())) {
            event.setAmount(Math.min(event.getAmount(), 3.0f));
        }
    }

    @SubscribeEvent
    public void onAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        ItemStack equip;
        if (event.getEntityLiving() instanceof EntityPlayer && event.getSource().func_76346_g() != null && (equip = (player = (EntityPlayer)event.getEntityLiving()).func_184614_ca()) != ItemStack.field_190927_a && player.func_175144_cb() && equip.func_77973_b() == this && ItemDragonslayer.isDragon(event.getSource().func_76346_g())) {
            event.setCanceled(true);
            if (event.getSource().func_76346_g() instanceof EntityPlayer) {
                EntityPlayer other = (EntityPlayer)event.getSource().func_76346_g();
                other.func_70690_d(new PotionEffect((Potion)RegistryHandler.dragonwrack, 300));
                for (EntityEquipmentSlot x : EntityEquipmentSlot.values()) {
                    ItemStack gear;
                    if (other.func_184582_a(x) == ItemStack.field_190927_a || !((gear = other.func_184582_a(x)).func_77973_b() instanceof IEnergyContainerItem)) continue;
                    IEnergyContainerItem battery = (IEnergyContainerItem)gear.func_77973_b();
                    battery.extractEnergy(gear, battery.getMaxEnergyStored(gear) / 50, false);
                }
            }
        }
    }

    @Override
    public void registerModels() {
        ReForbiddenMagic.proxy.registerItemRenderer((Item)this, 0, "inventory");
    }
}

