/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.api.core.IStackFilter;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.lib.inventory.filter.StackFilter;
import buildcraft.transport.pipe.flow.PipeFlowItems;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class PipeBehaviorGravityFeed
extends APPipe {
    private int ticksSincePull = 0;

    public PipeBehaviorGravityFeed(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.ticksSincePull = nbt.func_74762_e("ticksSincePull");
    }

    public PipeBehaviorGravityFeed(IPipe pipe) {
        super(pipe);
    }

    private boolean shouldTick() {
        return this.ticksSincePull >= APConfiguration.gravityFeedPipeTicksPerPull;
    }

    public void onTick() {
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            return;
        }
        ++this.ticksSincePull;
        if (this.shouldTick() && this.pipe.isConnected(EnumFacing.UP) && this.pipe.getConnectedType(EnumFacing.UP) == IPipe.ConnectedType.TILE) {
            ((PipeFlowItems)this.pipe.getFlow()).tryExtractItems(1, EnumFacing.UP, null, (IStackFilter)StackFilter.ALL, false);
        }
    }

    public int getTextureIndex(EnumFacing direction) {
        if (direction == EnumFacing.UP) {
            return 0;
        }
        return 1;
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74768_a("ticksSincePull", this.ticksSincePull);
        return nbt;
    }
}

