/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.api.ITeleportPipe;
import buildcraft.additionalpipes.api.TeleportManagerBase;
import buildcraft.additionalpipes.api.TeleportPipeType;
import buildcraft.additionalpipes.utils.Log;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.world.World;

public class TeleportManager
extends TeleportManagerBase {
    public static final TeleportManager instance = new TeleportManager();
    private static HashMap<TeleportPipeType, Multimap<Integer, ITeleportPipe>> pipes;
    public final Map<Integer, String> frequencyNames;

    private TeleportManager() {
        pipes = new HashMap();
        for (TeleportPipeType type : TeleportPipeType.values()) {
            pipes.put(type, (Multimap<Integer, ITeleportPipe>)LinkedListMultimap.create());
        }
        this.frequencyNames = new HashMap<Integer, String>();
    }

    private Collection<ITeleportPipe> getPipesInChannel(int frequency, TeleportPipeType type) {
        return pipes.get((Object)type).get((Object)frequency);
    }

    @Override
    public void add(ITeleportPipe newPipe, int frequency) {
        Collection pipesInChannel = pipes.get((Object)newPipe.getType()).get((Object)frequency);
        Iterator pipesIter = pipesInChannel.iterator();
        while (pipesIter.hasNext()) {
            ITeleportPipe pipe = (ITeleportPipe)pipesIter.next();
            if (!pipe.equals(newPipe)) continue;
            pipesIter.remove();
        }
        pipesInChannel.add(newPipe);
        if (newPipe.getContainer() != null) {
            Log.debug(String.format("[TeleportManager] Pipe added: %s @ (%s), %d pipes in channel", newPipe.getType().toString().toLowerCase(), newPipe.getPosition().toString(), this.getPipesInChannel(frequency, newPipe.getType()).size()));
        }
    }

    @Override
    public void remove(ITeleportPipe pipeToRemove, int frequency) {
        Collection pipesInChannel = pipes.get((Object)pipeToRemove.getType()).get((Object)frequency);
        Iterator pipesIter = pipesInChannel.iterator();
        while (pipesIter.hasNext()) {
            ITeleportPipe pipe = (ITeleportPipe)pipesIter.next();
            if (!pipe.equals(pipeToRemove)) continue;
            pipesIter.remove();
        }
        if (pipeToRemove.getContainer() != null) {
            Log.debug(String.format("[TeleportManager] Pipe removed: %s @ (%s), %d pipes in channel", pipeToRemove.getType().toString().toLowerCase(), pipeToRemove.getPosition().toString(), this.getPipesInChannel(frequency, pipeToRemove.getType()).size()));
        }
    }

    @Override
    public void reset() {
        for (TeleportPipeType type : TeleportPipeType.values()) {
            pipes.get((Object)type).clear();
        }
        this.frequencyNames.clear();
        Log.debug("Reset teleport manager.");
    }

    public ArrayList<ITeleportPipe> getConnectedPipes(ITeleportPipe pipe, boolean includeSend, boolean includeReceive) {
        Collection<ITeleportPipe> channel = this.getPipesInChannel(pipe.getFrequency(), pipe.getType());
        ArrayList<ITeleportPipe> connected = new ArrayList<ITeleportPipe>();
        for (ITeleportPipe other : channel) {
            if (other.getContainer() != null && other.getContainer().func_145837_r() || pipe == other || (!other.canReceive() || !includeReceive) && (!other.canSend() || !includeSend) || !(pipe.isPublic() ? other.isPublic() : other.getOwnerUUID() != null && other.getOwnerUUID().equals(pipe.getOwnerUUID()))) continue;
            connected.add(other);
        }
        return connected;
    }

    public Collection<ITeleportPipe> getAllPipesInNetwork(TeleportPipeType type) {
        return pipes.get((Object)type).values();
    }

    @Override
    public String getFrequencyName(int frequency) {
        String name = this.frequencyNames.get(frequency);
        return name == null ? "" : name;
    }

    @Override
    public void setFrequencyName(int frequency, String name) {
        this.frequencyNames.put(frequency, name);
    }

    public File getWorldSave(World world) {
        return world.func_72860_G().func_75758_b("foo").getParentFile().getParentFile();
    }
}

