/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.block;

import com.fuzs.aquaacrobatics.client.particle.ParticleBubbleColumnUp;
import com.fuzs.aquaacrobatics.client.particle.ParticleCurrentDown;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.IBubbleColumnInteractable;
import com.fuzs.aquaacrobatics.proxy.CommonProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBubbleColumn
extends BlockStaticLiquid {
    public static final PropertyBool DRAG = PropertyBool.func_177716_a((String)"drag");

    public BlockBubbleColumn() {
        super(Material.field_151586_h);
        this.setRegistryName("bubble_column");
        this.func_149663_c("tile.aquaacrobatics.bubble.column.name");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DRAG, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        BlockStateContainer.Builder builder = new BlockStateContainer.Builder((Block)this).add(new IProperty[]{field_176367_b, DRAG});
        if (Loader.isModLoaded((String)"fluidlogged_api")) {
            builder = builder.add((IUnlistedProperty[])BlockFluidBase.FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0]));
        }
        return builder.build();
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        boolean downwards;
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177984_a());
        IBubbleColumnInteractable bubbleEntity = (IBubbleColumnInteractable)entityIn;
        boolean bl = downwards = (Boolean)state.func_177229_b((IProperty)DRAG) == false;
        if (iblockstate.func_177230_c() == Blocks.field_150350_a) {
            bubbleEntity.onEnterBubbleColumnWithAirAbove(downwards);
        } else {
            bubbleEntity.onEnterBubbleColumn(downwards);
        }
    }

    public static void placeBubbleColumn(World world, BlockPos pos, boolean isUpwards) {
        if (!ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            return;
        }
        if (BlockBubbleColumn.canHoldBubbleColumn(world, pos)) {
            world.func_180501_a(pos, CommonProxy.BUBBLE_COLUMN.func_176223_P().func_177226_a((IProperty)DRAG, (Comparable)Boolean.valueOf(isUpwards)), 2);
        }
    }

    public static boolean canHoldBubbleColumn(World world, BlockPos pos) {
        if (world.field_73011_w.func_177500_n()) {
            return false;
        }
        IBlockState self = world.func_180495_p(pos);
        if (self.func_185904_a() != Material.field_151586_h) {
            return false;
        }
        if (!(self.func_177230_c() instanceof BlockLiquid)) {
            return false;
        }
        return (Integer)self.func_177229_b((IProperty)field_176367_b) == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        Minecraft mc = Minecraft.func_71410_x();
        if (!((Boolean)stateIn.func_177229_b((IProperty)DRAG)).booleanValue()) {
            mc.field_71452_i.func_78873_a((Particle)new ParticleCurrentDown(worldIn, d0 + 0.5, d1 + 0.8, d2));
        } else {
            mc.field_71452_i.func_78873_a((Particle)new ParticleBubbleColumnUp(worldIn, d0 + 0.5, d1, d2 + 0.5, 0.0, 0.04, 0.0));
            mc.field_71452_i.func_78873_a((Particle)new ParticleBubbleColumnUp(worldIn, d0 + (double)rand.nextFloat(), d1 + (double)rand.nextFloat(), d2 + (double)rand.nextFloat(), 0.0, 0.04, 0.0));
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.isValidPosition(worldIn, pos)) {
            worldIn.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            return;
        }
        if (fromPos.func_177984_a().equals((Object)pos)) {
            worldIn.func_180501_a(pos, CommonProxy.BUBBLE_COLUMN.func_176223_P().func_177226_a((IProperty)DRAG, (Comparable)Boolean.valueOf(BlockBubbleColumn.getDrag((IBlockAccess)worldIn, fromPos))), 2);
        } else if (fromPos.func_177977_b().equals((Object)pos) && worldIn.func_180495_p(fromPos).func_177230_c() != this && BlockBubbleColumn.canHoldBubbleColumn(worldIn, fromPos)) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
        if (fromPos.func_177958_n() != pos.func_177958_n() || fromPos.func_177952_p() != pos.func_177952_p()) {
            super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        }
    }

    public boolean isValidPosition(World worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block == this || block == ((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)DRAG) != false ? Blocks.field_150425_aM : Blocks.field_189877_df);
    }

    private static boolean getDrag(IBlockAccess p_203157_0_, BlockPos p_203157_1_) {
        IBlockState iblockstate = p_203157_0_.func_180495_p(p_203157_1_);
        Block block = iblockstate.func_177230_c();
        if (block == CommonProxy.BUBBLE_COLUMN) {
            return (Boolean)iblockstate.func_177229_b((IProperty)DRAG);
        }
        return block == Blocks.field_150425_aM;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        BlockBubbleColumn.placeBubbleColumn(worldIn, pos.func_177984_a(), BlockBubbleColumn.getDrag((IBlockAccess)worldIn, pos.func_177977_b()));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        BlockBubbleColumn.placeBubbleColumn(worldIn, pos.func_177984_a(), BlockBubbleColumn.getDrag((IBlockAccess)worldIn, pos));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DRAG, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_149738_a(World worldIn) {
        return 5;
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)DRAG) != false ? 1 : 0;
    }
}

