/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.api;

import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.api.MobAspect;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.jetbrains.annotations.Contract;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.entities.monster.EntityFireBat;
import thaumcraft.common.entities.monster.EntityWisp;

public class MobAspects {
    private static final HashMap<Class<?>, MobAspect> aspects = new HashMap();
    private static final Method setSlimeSizeMethod;

    @Contract(pure=true)
    public static HashMap<Class<?>, MobAspect> getAspects() {
        return aspects;
    }

    public static void checkAspects() {
        for (MobAspect mobAspect : aspects.values()) {
            AspectList curAspects = mobAspect.getAspects();
            for (MobAspect mobAspect2 : aspects.values()) {
                if (mobAspect.equals(mobAspect2)) continue;
                AspectList checkAspects = mobAspect2.getAspects();
                boolean same = true;
                for (Aspect aspect : curAspects.getAspects()) {
                    if (checkAspects.getAmount(aspect) == curAspects.getAmount(aspect)) continue;
                    same = false;
                }
                if (!same) continue;
                ThaumicTinkerer.logger.error("Warning, Two entities have the same mob aspects" + mobAspect.toString() + ", " + mobAspect2.toString());
            }
        }
        ThaumicTinkerer.logger.info("Checked Mob Aspects");
    }

    public static MobAspect getByAspects(AspectList aspectList) {
        for (MobAspect mobAspect2 : aspects.values()) {
            AspectList checkAspects = mobAspect2.getAspects();
            boolean same = true;
            for (Aspect aspect : aspectList.getAspects()) {
                if (checkAspects.getAmount(aspect) == aspectList.getAmount(aspect)) continue;
                same = false;
            }
            if (!same) continue;
            if (aspectList.getAspects().length == 1 && aspectList.getAmount(aspectList.getAspects()[0]) == 3) {
                return mobAspect2;
            }
            if (aspectList.getAspects().length == 2 && (aspectList.getAmount(aspectList.getAspects()[0]) == 2 || aspectList.getAmount(aspectList.getAspects()[1]) == 2)) {
                return mobAspect2;
            }
            if (aspectList.getAspects().length == 3) {
                return mobAspect2;
            }
            return null;
        }
        return null;
    }

    static void putAspect(Class<?> clazz, String entityName, AspectList aspectsList) {
        aspects.put(clazz, new MobAspect(clazz, entityName, aspectsList));
    }

    static void putAspect(Class<?> clazz, String entityName, AspectList aspectsList, String prefix) {
        aspects.put(clazz, new MobAspect(clazz, entityName, aspectsList).setPrefix(prefix));
    }

    static void putAspect(Class<?> clazz, String entityName, AspectList aspectsList, float scale, float offset) {
        aspects.put(clazz, new MobAspect(clazz, entityName, aspectsList).setScale(scale).setOffset(offset));
    }

    static void putSlimeAspect(Class<?> clazz, String entityName, AspectList aspectsList) {
        aspects.put(clazz, new MobAspect((Class)clazz, entityName, aspectsList){

            @Override
            public Entity createEntity(World worldObj) {
                Entity entity = super.createEntity(worldObj);
                if (entity instanceof EntitySlime) {
                    try {
                        setSlimeSizeMethod.invoke((Object)entity, 1, true);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new ReportedException(new CrashReport("Could not call method '" + setSlimeSizeMethod.getName() + "'", (Throwable)e));
                    }
                }
                return entity;
            }
        });
    }

    static {
        MobAspects.putAspect(EntityBat.class, "Bat", new AspectList().add(Aspect.AIR, 2).add(Aspect.FLIGHT, 1));
        MobAspects.putAspect(EntityChicken.class, "Chicken", new AspectList().add(Aspect.LIFE, 1).add(Aspect.FLIGHT, 1).add(Aspect.BEAST, 1));
        MobAspects.putAspect(EntityCow.class, "Cow", new AspectList().add(Aspect.BEAST, 2).add(Aspect.EARTH, 1));
        MobAspects.putAspect(EntityHorse.class, "Horse", new AspectList().add(Aspect.BEAST, 2).add(Aspect.AIR, 1));
        MobAspects.putAspect(EntityIronGolem.class, "VillagerGolem", new AspectList().add(Aspect.METAL, 2).add(Aspect.MAN, 1), 0.3f, 0.0f);
        MobAspects.putAspect(EntityMooshroom.class, "Mooshroom", new AspectList().add(Aspect.BEAST, 1).add(Aspect.EARTH, 1).add(Aspect.PLANT, 1));
        MobAspects.putAspect(EntityOcelot.class, "Ocelot", new AspectList().add(Aspect.BEAST, 1).add(Aspect.EARTH, 1).add(Aspect.ELDRITCH, 1));
        MobAspects.putAspect(EntityPig.class, "Pig", new AspectList().add(Aspect.BEAST, 1).add(Aspect.EARTH, 1).add(Aspect.MOTION, 1));
        MobAspects.putAspect(EntitySheep.class, "Sheep", new AspectList().add(Aspect.EARTH, 2).add(Aspect.BEAST, 1));
        MobAspects.putAspect(EntitySquid.class, "Squid", new AspectList().add(Aspect.WATER, 3));
        MobAspects.putAspect(EntitySnowman.class, "SnowMan", new AspectList().add(Aspect.WATER, 2).add(Aspect.MAN, 1));
        MobAspects.putAspect(EntityIronGolem.class, "Villager", new AspectList().add(Aspect.MAN, 3), 0.3f, 0.0f);
        MobAspects.putAspect(EntityWolf.class, "Wolf", new AspectList().add(Aspect.BEAST, 3));
        MobAspects.putAspect(EntityBrainyZombie.class, "BrainyZombie", new AspectList().add(Aspect.MAGIC, 1).add(Aspect.UNDEAD, 1).add(Aspect.DARKNESS, 1), "thaumcraft");
        MobAspects.putAspect(EntityBlaze.class, "Blaze", new AspectList().add(Aspect.FIRE, 3));
        MobAspects.putAspect(EntityCaveSpider.class, "CaveSpider", new AspectList().add(Aspect.BEAST, 1).add(Aspect.DEATH, 2));
        MobAspects.putAspect(EntityCreeper.class, "Creeper", new AspectList().add(Aspect.MAGIC, 1).add(Aspect.BEAST, 1).add(Aspect.ELDRITCH, 1));
        MobAspects.putAspect(EntityEnderman.class, "Enderman", new AspectList().add(Aspect.ELDRITCH, 2).add(Aspect.MAN, 1), 0.3f, 0.0f);
        MobAspects.putAspect(EntityFireBat.class, "Firebat", new AspectList().add(Aspect.FLIGHT, 1).add(Aspect.FIRE, 1).add(Aspect.MAGIC, 1), "thaumcraft");
        MobAspects.putAspect(EntityGhast.class, "Ghast", new AspectList().add(Aspect.FIRE, 1).add(Aspect.FLIGHT, 2), 0.1f, 0.2f);
        MobAspects.putSlimeAspect(EntityMagmaCube.class, "Magma_Cube", new AspectList().add(Aspect.FIRE, 1).add(Aspect.WATER, 2));
        MobAspects.putAspect(EntityPigZombie.class, "Zombie_Pigman", new AspectList().add(Aspect.UNDEAD, 1).add(Aspect.BEAST, 1).add(Aspect.FIRE, 1));
        MobAspects.putAspect(EntitySilverfish.class, "Silverfish", new AspectList().add(Aspect.METAL, 2).add(Aspect.EARTH, 1));
        MobAspects.putAspect(EntitySkeleton.class, "Skeleton", new AspectList().add(Aspect.UNDEAD, 1).add(Aspect.MAN, 1).add(Aspect.FLIGHT, 1));
        MobAspects.putAspect(EntityWitherSkeleton.class, "Wither_Skeleton", new AspectList().add(Aspect.UNDEAD, 1).add(Aspect.MAN, 1).add(Aspect.AVERSION, 1));
        MobAspects.putSlimeAspect(EntitySlime.class, "Slime", new AspectList().add(Aspect.WATER, 2).add(Aspect.BEAST, 1));
        MobAspects.putAspect(EntitySpider.class, "Spider", new AspectList().add(Aspect.BEAST, 1).add(Aspect.UNDEAD, 2));
        MobAspects.putAspect(EntityWisp.class, "Wisp", new AspectList().add(Aspect.AIR, 1).add(Aspect.MAGIC, 2), "thaumcraft");
        MobAspects.putAspect(EntityWitch.class, "Witch", new AspectList().add(Aspect.MAGIC, 1).add(Aspect.UNDEAD, 1).add(Aspect.ELDRITCH, 1));
        MobAspects.putAspect(EntityZombie.class, "Zombie", new AspectList().add(Aspect.MAN, 1).add(Aspect.UNDEAD, 2));
        MobAspects.putAspect(EntityRabbit.class, "Rabbit", new AspectList().add(Aspect.BEAST, 1).add(Aspect.LIFE, 1).add(Aspect.MOTION, 1));
        MobAspects.putAspect(EntityGuardian.class, "Guardian", new AspectList().add(Aspect.PROTECT, 1).add(Aspect.WATER, 1).add(Aspect.AVERSION, 1));
        MobAspects.putAspect(EntityPolarBear.class, "Polar_Bear", new AspectList().add(Aspect.BEAST, 2).add(Aspect.COLD, 1));
        MobAspects.putAspect(EntityHusk.class, "Husk", new AspectList().add(Aspect.MAN, 1).add(Aspect.UNDEAD, 1).add(Aspect.FIRE, 1));
        MobAspects.putAspect(EntityStray.class, "Stray", new AspectList().add(Aspect.UNDEAD, 1).add(Aspect.MAN, 1).add(Aspect.COLD, 1));
        MobAspects.putAspect(EntityLlama.class, "Llama", new AspectList().add(Aspect.BEAST, 1).add(Aspect.AIR, 1).add(Aspect.EXCHANGE, 3));
        MobAspects.putAspect(EntityVindicator.class, "Vindication_Illager", new AspectList().add(Aspect.AVERSION, 1).add(Aspect.MAN, 2), 0.3f, 0.0f);
        MobAspects.putAspect(EntityVex.class, "Vex", new AspectList().add(Aspect.FLIGHT, 1).add(Aspect.MAGIC, 1).add(Aspect.ELDRITCH, 1));
        MobAspects.putAspect(EntityParrot.class, "Parrot", new AspectList().add(Aspect.MAN, 1).add(Aspect.FLIGHT, 1).add(Aspect.BEAST, 1));
        setSlimeSizeMethod = ObfuscationReflectionHelper.findMethod(EntitySlime.class, (String)"func_70799_a", Void.TYPE, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
    }
}

