/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.client.gui;

import com.nekokittygames.thaumictinkerer.common.items.Kami.ItemSkyPearl;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import com.nekokittygames.thaumictinkerer.common.packets.PacketHandler;
import com.nekokittygames.thaumictinkerer.common.packets.PacketWarpGateTeleport;
import com.nekokittygames.thaumictinkerer.common.tileentity.Kami.TileWarpGate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.codechicken.lib.vec.Vector3;

public class GuiWarpGateDestinations
extends GuiScreen {
    private static final ResourceLocation enderField = new ResourceLocation("textures/entity/end_portal.png");
    TileWarpGate warpGate;
    RenderItem render = Minecraft.func_71410_x().func_175599_af();
    int lastMouseX;
    int lastMouseY;
    int x;
    int y;
    int ticks;
    List<String> tooltip = new ArrayList<String>();

    public GuiWarpGateDestinations(TileWarpGate warpGate) {
        this.warpGate = warpGate;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.x = this.warpGate.func_174877_v().func_177958_n() - this.field_146294_l / 2;
        this.y = this.warpGate.func_174877_v().func_177952_p() - this.field_146295_m / 2;
    }

    public void func_73876_c() {
        ++this.ticks;
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        int i = res.func_78326_a();
        int j = res.func_78328_b();
        int mx = Mouse.getX() * i / this.field_146297_k.field_71443_c;
        int my = j - Mouse.getY() * j / this.field_146297_k.field_71440_d - 1;
        if (Mouse.isButtonDown((int)0)) {
            int deltaX = mx - this.lastMouseX;
            int deltaY = my - this.lastMouseY;
            this.x -= deltaX;
            this.y -= deltaY;
        }
        this.lastMouseX = mx;
        this.lastMouseY = my;
    }

    protected void func_73869_a(char par1, int par2) throws IOException {
        int num;
        ItemStack stack;
        super.func_73869_a(par1, par2);
        if (par2 == 57) {
            this.x = this.warpGate.func_174877_v().func_177958_n() - this.field_146294_l / 2;
            this.y = this.warpGate.func_174877_v().func_177952_p() - this.field_146295_m / 2;
            return;
        }
        if (par2 >= 2 && par2 < 12 && (stack = this.warpGate.func_70301_a(num = par2 - 2)) != null && ItemSkyPearl.isAttuned(stack) && ItemSkyPearl.getDim(stack) == this.warpGate.func_145831_w().field_73011_w.getDimension()) {
            int x = ItemSkyPearl.getX(stack);
            int z = ItemSkyPearl.getZ(stack);
            this.x = x - this.field_146294_l / 2;
            this.y = z - this.field_146295_m / 2;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        this.tooltip.clear();
        int gateX = this.warpGate.func_174877_v().func_177958_n() - this.x;
        int gateY = this.warpGate.func_174877_v().func_177952_p() - this.y;
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        ArrayList<Object[]> coords = new ArrayList<Object[]>();
        for (int i = 0; i < this.warpGate.func_70302_i_(); ++i) {
            ItemStack stack = this.warpGate.func_70301_a(i);
            if (stack == null || !ItemSkyPearl.isAttuned(stack)) continue;
            int dim = ItemSkyPearl.getDim(stack);
            if (this.warpGate.func_145831_w().field_73011_w.getDimension() != dim) continue;
            int x = ItemSkyPearl.getX(stack);
            int y = ItemSkyPearl.getY(stack);
            int z = ItemSkyPearl.getZ(stack);
            if (y == -1) continue;
            coords.add(new Object[]{x - this.x, z - this.y, stack, i});
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)((Math.sin((double)this.ticks / 10.0) + 1.0) / 4.0 + 0.25)));
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        for (Object[] coords_ : coords) {
            int x = (Integer)coords_[0];
            int y = (Integer)coords_[1];
            GL11.glBegin((int)1);
            GL11.glVertex2i((int)gateX, (int)gateY);
            GL11.glVertex2i((int)x, (int)y);
            GL11.glEnd();
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        this.field_146289_q.func_175063_a(TextFormatting.UNDERLINE + I18n.func_74838_a((String)"ttmisc.destinations"), 3.0f, 40.0f, 0xFFFFFF);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawPearlAt(0, null, gateX, gateY, par1, par2);
        for (Object[] coords_ : coords) {
            this.drawPearlAt((Integer)coords_[3], (ItemStack)coords_[2], (Integer)coords_[0], (Integer)coords_[1], par1, par2);
        }
        this.func_73732_a(this.field_146289_q, I18n.func_74838_a((String)"ttmisc.numberKeys"), this.field_146294_l / 2, 5, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_74838_a((String)"ttmisc.spaceToReset"), this.field_146294_l / 2, 16, 0xFFFFFF);
    }

    public void drawPearlAt(int index, ItemStack stack, int xp, int yp, int mx, int my) {
        int x = xp + this.x;
        int y = yp + this.y;
        this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)xp, (float)yp, (float)0.0f);
        GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
        this.render.func_175042_a(ModItems.sky_pearl.func_190903_i(), -8, -8);
        GL11.glPopMatrix();
        String destNum = " " + TextFormatting.ITALIC + String.format(I18n.func_74838_a((String)"ttmisc.destinationInd"), index + 1);
        String destName = stack != null && stack.func_82837_s() ? stack.func_82833_r() : I18n.func_74838_a((String)(stack == ItemStack.field_190927_a ? "ttmisc.entrancePoint" : "ttmisc.destination"));
        if (stack != null) {
            this.field_146289_q.func_78276_b(index + 1 + ": " + destName, 5, 54 + index * 11, 0xFFFFFF);
        }
        if (mx >= xp - 4 && mx <= xp + 4 && my >= yp - 4 && my < yp + 4) {
            this.tooltip.add(TextFormatting.AQUA + destName + destNum);
            if (stack != null) {
                ItemSkyPearl.addInfo(stack, this.warpGate.func_145831_w().field_73011_w.getDimension(), Vector3.fromTile((TileEntity)this.warpGate), this.tooltip, true);
                this.tooltip.add(I18n.func_74838_a((String)"ttmisc.clickToTeleport"));
            } else {
                this.tooltip.add("X: " + x);
                this.tooltip.add("Z: " + y);
            }
            if (Mouse.isButtonDown((int)0) && GuiWarpGateDestinations.func_146272_n() && stack != null) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketWarpGateTeleport(this.warpGate, index));
                this.field_146297_k.func_147108_a(null);
            }
        }
    }

    public void func_146276_q_() {
        boolean par1 = false;
        GlStateManager.func_179140_f();
        GlStateManager.func_179106_n();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        this.field_146297_k.func_110434_K().func_110577_a(enderField);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 256.0f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        buffer.func_181662_b(0.0, (double)this.field_146295_m, 0.0).func_187315_a(0.0, (double)((float)this.field_146295_m / f + (float)par1)).func_181669_b(64, 64, 64, 255).func_181675_d();
        buffer.func_181662_b((double)this.field_146294_l, (double)this.field_146295_m, 0.0).func_187315_a((double)((float)this.field_146294_l / f), (double)((float)this.field_146295_m / f + (float)par1)).func_181669_b(64, 64, 64, 255).func_181675_d();
        buffer.func_181662_b((double)this.field_146294_l, 0.0, 0.0).func_187315_a((double)((float)this.field_146294_l / f), (double)par1).func_181669_b(64, 64, 64, 255).func_181675_d();
        buffer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(0.0, (double)par1).func_181669_b(64, 64, 64, 255).func_181675_d();
        tessellator.func_78381_a();
    }
}

