/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.client.rendering;

import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.common.blocks.ModBlocks;
import com.nekokittygames.thaumictinkerer.common.helper.IItemVariants;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import com.nekokittygames.thaumictinkerer.common.utils.IVariant;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="thaumictinkerer")
public class ModelManager {
    private static final ModelManager INSTANCE = new ModelManager();
    private Map<Item, Map<String, ModelResourceLocation>> Item_Variants_baked = new HashMap<Item, Map<String, ModelResourceLocation>>();
    private final StateMapperBase propertyStringMapper = new StateMapperBase(){

        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            return new ModelResourceLocation("minecraft:air");
        }
    };
    private final Set<Item> itemsRegistered = new HashSet<Item>();

    private ModelManager() {
    }

    public static ModelManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        INSTANCE.registerBlockModels();
        INSTANCE.registerItemModels();
    }

    private void registerBlockModels() {
        OBJLoader.INSTANCE.addDomain("thaumictinkerer");
        ModBlocks.RegistrationHandler.ITEM_BLOCKS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    private void registerBlockItemModel(IBlockState state) {
        Block block = state.func_177230_c();
        Item item = Item.func_150898_a((Block)block);
        if (item != Items.field_190931_a) {
            ResourceLocation registryName = Objects.requireNonNull(block.getRegistryName());
            ModelResourceLocation mrl = new ModelResourceLocation(registryName, this.propertyStringMapper.func_178131_a((Map)state.func_177228_b()));
            this.registerItemModel(item, mrl);
        }
    }

    private void registerItemModels() {
        ModItems.RegistrationHandler.ITEMS.stream().filter(item -> !this.itemsRegistered.contains(item)).forEach(this::registerItemModel);
    }

    private <T extends IVariant> void registerVariantItemModels(Item item, String variantName, T[] values) {
        for (T value : values) {
            this.registerItemModelForMeta(item, value.getMeta(), variantName + "=" + value.func_176610_l());
        }
    }

    private void registerItemModel(Item item) {
        ResourceLocation registryName = Objects.requireNonNull(item.getRegistryName());
        this.registerItemModel(item, registryName.toString());
    }

    private void registerItemModel(Item item, String modelLocation) {
        ModelResourceLocation fullModelLocation = new ModelResourceLocation(modelLocation, "inventory");
        this.registerItemModel(item, fullModelLocation);
    }

    private void registerItemModel(Item item, ModelResourceLocation fullModelLocation) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{fullModelLocation});
        if (item instanceof IItemVariants) {
            for (String variant : ((IItemVariants)item).GetVariants()) {
                ModelResourceLocation mrl;
                block6: {
                    ResourceLocation loc = new ResourceLocation("thaumictinkerer", fullModelLocation.func_110623_a() + "/" + variant);
                    mrl = new ModelResourceLocation(loc, fullModelLocation.func_177518_c());
                    try {
                        ResourceLocation test = new ResourceLocation("thaumictinkerer", "models/item/" + loc.func_110623_a() + ".json");
                        if (Minecraft.func_71410_x().func_110442_L().func_110536_a(test) == null) {
                            ThaumicTinkerer.logger.info("Unable to find model file for item: " + item.toString() + " variant: " + variant);
                            this.Item_Variants_baked.putIfAbsent(item, new HashMap());
                            this.Item_Variants_baked.get(item).put(variant, fullModelLocation);
                        }
                        break block6;
                    }
                    catch (IOException e) {
                        ThaumicTinkerer.logger.info("Unable to find model file for item: " + item.toString() + " variant: " + variant);
                        this.Item_Variants_baked.putIfAbsent(item, new HashMap());
                        this.Item_Variants_baked.get(item).put(variant, fullModelLocation);
                    }
                    continue;
                }
                this.Item_Variants_baked.putIfAbsent(item, new HashMap());
                this.Item_Variants_baked.get(item).put(variant, mrl);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{mrl});
            }
            this.registerItemModel(item, stack -> {
                String var = ((IItemVariants)item).GetVariant(stack);
                if (((Map)this.Item_Variants_baked.getOrDefault(stack.func_77973_b(), new HashMap())).containsKey(var)) {
                    return (ModelResourceLocation)((Map)this.Item_Variants_baked.getOrDefault(stack.func_77973_b(), new HashMap())).get(var);
                }
                ThaumicTinkerer.logger.error("Variant " + var + " Has been added to item " + stack.func_77973_b().toString() + "since loading. Variant list should  not change");
                return fullModelLocation;
            });
        } else {
            this.registerItemModel(item, stack -> fullModelLocation);
        }
    }

    private void registerItemModel(Item item, ItemMeshDefinition meshDefinition) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)meshDefinition);
    }

    private void registerItemModelForMeta(Item item, int metadata, String variant) {
        this.registerItemModelForMeta(item, metadata, new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), variant));
    }

    private void registerItemModelForMeta(Item item, int metadata, ModelResourceLocation modelResourceLocation) {
        this.itemsRegistered.add(item);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)modelResourceLocation);
    }
}

