/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.dim;

import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.dim.OreClusterGenerator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreFrequency {
    private static final Map<String, Integer> ORES = new Object2IntOpenHashMap();

    public static void init() {
        ORES.clear();
        try {
            for (String entry : TTConfig.BedRockDimensionOres) {
                String[] splits = entry.split(",");
                ORES.put(splits[0], Integer.valueOf(splits[1]));
                ThaumicTinkerer.logger.debug("OreClusterGenerator ore added via config: {}", (Object)splits[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getSum() {
        int total = 0;
        for (Map.Entry<String, Integer> entry : ORES.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    public static List<String> getValidOres() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : ORES.keySet()) {
            if (!OreFrequency.isValid(key)) continue;
            result.add(key);
        }
        return result;
    }

    public static ItemStack getRandomOre(Random rand) {
        int randInt = rand.nextInt(OreFrequency.getSum());
        for (String key : OreFrequency.getValidOres()) {
            if ((randInt -= ORES.get(key).intValue()) >= 0) continue;
            return (ItemStack)OreDictionary.getOres((String)key).get(0);
        }
        return new ItemStack(Blocks.field_150366_p);
    }

    public static boolean isValid(String name) {
        return !Arrays.asList(OreClusterGenerator.blacklist).contains(name) && !OreDictionary.getOres((String)name).isEmpty() && ((ItemStack)OreDictionary.getOres((String)name).get(0)).func_77973_b() instanceof ItemBlock;
    }
}

