/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.foci;

import com.google.common.collect.Lists;
import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.api.ThaumicTinkererAPI;
import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.ICaster;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.BlockUtils;

public class FocusEffectDislocate
extends FocusEffect {
    private static final String TAG_AVAILABLE = "available";
    private static final String TAG_TILE_CMP = "tileCmp";
    private static final String TAG_BLOCK_NAME = "blockName";
    private static final String TAG_BLOCK_META = "blockMeta";

    public boolean execute(RayTraceResult rayTraceResult, @Nullable Trajectory trajectory, float v, int i) {
        this.getPackage().world.func_184148_a(null, rayTraceResult.field_72307_f.field_72450_a, rayTraceResult.field_72307_f.field_72448_b, rayTraceResult.field_72307_f.field_72449_c, SoundsTC.hhon, SoundCategory.PLAYERS, 0.8f, 0.85f + (float)(this.getPackage().getCaster().field_70170_p.field_73012_v.nextGaussian() * (double)0.05f));
        if (rayTraceResult == null) {
            return false;
        }
        if (rayTraceResult.field_72313_a != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockPos pos = rayTraceResult.func_178782_a();
        IBlockState blockState = this.getPackage().world.func_180495_p(pos);
        TileEntity tileEntity = this.getPackage().world.func_175625_s(pos);
        ItemStack casterStack = ItemStack.field_190927_a;
        if (this.getPackage().getCaster().func_184614_ca() != ItemStack.field_190927_a && this.getPackage().getCaster().func_184614_ca().func_77973_b() instanceof ICaster) {
            casterStack = this.getPackage().getCaster().func_184614_ca();
        } else if (this.getPackage().getCaster().func_184592_cb() != ItemStack.field_190927_a && this.getPackage().getCaster().func_184592_cb().func_77973_b() instanceof ICaster) {
            casterStack = this.getPackage().getCaster().func_184592_cb();
        }
        if (casterStack == null) {
            return false;
        }
        if (casterStack == ItemStack.field_190927_a) {
            return false;
        }
        ItemStack focus = ((ICaster)casterStack.func_77973_b()).getFocusStack(casterStack);
        if (this.getPackage().getCaster() instanceof EntityPlayer && ((EntityPlayer)this.getPackage().getCaster()).func_175151_a(pos, rayTraceResult.field_178784_b, casterStack)) {
            IBlockState stateStored = this.getStoredState(focus);
            if (stateStored != null) {
                switch (rayTraceResult.field_178784_b) {
                    case UP: {
                        pos = pos.func_177984_a();
                        break;
                    }
                    case DOWN: {
                        pos = pos.func_177977_b();
                        break;
                    }
                    case NORTH: {
                        pos = pos.func_177978_c();
                        break;
                    }
                    case EAST: {
                        pos = pos.func_177974_f();
                        break;
                    }
                    case SOUTH: {
                        pos = pos.func_177968_d();
                        break;
                    }
                    case WEST: {
                        pos = pos.func_177976_e();
                        break;
                    }
                }
                if (blockState.func_177230_c().func_176198_a(this.getPackage().world, pos, rayTraceResult.field_178784_b) && !this.getPackage().world.field_72995_K) {
                    NBTTagCompound tileCmp = this.getStackTileEntity(focus);
                    if (FocusEffectDislocate.PlaceBlock(this.getPackage().world, (EntityPlayerMP)this.getPackage().getCaster(), pos, rayTraceResult.field_178784_b, EnumHand.MAIN_HAND, stateStored, tileCmp) == EnumActionResult.SUCCESS) {
                        this.clearPickedBlock(focus);
                    }
                }
            } else if (!(blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.getPackage().world, pos) || BlockUtils.isPortableHoleBlackListed((IBlockState)blockState) || ThaumicTinkererAPI.getDislocationBlacklist().contains(blockState.func_177230_c().getClass().getName()) || this.getPackage().world.field_72995_K)) {
                this.storePickedBlock(blockState, tileEntity, focus);
                if (FocusEffectDislocate.BreakBlock(this.getPackage().world, (EntityPlayerMP)this.getPackage().getCaster(), pos) == EnumActionResult.FAIL) {
                    this.clearPickedBlock(focus);
                }
            }
        }
        return false;
    }

    private static EnumActionResult PlaceBlock(World world, EntityPlayerMP entityPlayerMP, BlockPos pos, EnumFacing side, EnumHand hand, IBlockState state, NBTTagCompound tileCmp) {
        EnumActionResult ret;
        world.captureBlockSnapshots = true;
        world.func_180501_a(pos, state, 3);
        if (tileCmp != null && !tileCmp.func_82582_d()) {
            TileEntity tile1 = TileEntity.func_190200_a((World)world, (NBTTagCompound)tileCmp);
            Objects.requireNonNull(tile1).func_174878_a(pos);
            world.func_175690_a(pos, tile1);
        }
        world.captureBlockSnapshots = false;
        BlockEvent.MultiPlaceEvent placeEvent = null;
        List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
        world.capturedBlockSnapshots.clear();
        if (blockSnapshots.size() > 1) {
            placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace((EntityPlayer)entityPlayerMP, (List)blockSnapshots, (EnumFacing)side, (EnumHand)hand);
        } else if (blockSnapshots.size() == 1) {
            placeEvent = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)entityPlayerMP, (BlockSnapshot)((BlockSnapshot)blockSnapshots.get(0)), (EnumFacing)side, (EnumHand)hand);
        }
        if (placeEvent != null && placeEvent.isCanceled()) {
            ret = EnumActionResult.FAIL;
            for (BlockSnapshot snap : Lists.reverse((List)blockSnapshots)) {
                world.restoringBlockSnapshots = true;
                snap.restore(true, false);
                world.restoringBlockSnapshots = false;
            }
        } else {
            for (BlockSnapshot snap : blockSnapshots) {
                int updateFlag = snap.getFlag();
                IBlockState oldBlock = snap.getReplacedBlock();
                IBlockState newBlock = world.func_180495_p(snap.getPos());
                if (!newBlock.func_177230_c().hasTileEntity(newBlock)) {
                    newBlock.func_177230_c().func_176213_c(world, snap.getPos(), newBlock);
                }
                world.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
            }
            ret = EnumActionResult.SUCCESS;
        }
        return ret;
    }

    private static EnumActionResult BreakBlock(World world, EntityPlayerMP entityPlayer, BlockPos pos) {
        boolean preCancelEvent = world.func_180495_p(pos).func_185887_b(world, pos) == -1.0f;
        IBlockState state = world.func_180495_p(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (EntityPlayer)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return EnumActionResult.FAIL;
        }
        world.func_175713_t(pos);
        world.func_175698_g(pos);
        return EnumActionResult.SUCCESS;
    }

    private void storePickedBlock(IBlockState blockState, TileEntity tileEntity, ItemStack focus) {
        ResourceLocation blockName = blockState.func_177230_c().getRegistryName();
        int metadata = blockState.func_177230_c().func_176201_c(blockState);
        ItemNBTHelper.setString(focus, TAG_BLOCK_NAME, Objects.requireNonNull(blockName).toString());
        ItemNBTHelper.setInteger(focus, TAG_BLOCK_META, metadata);
        NBTTagCompound cmp = new NBTTagCompound();
        if (tileEntity != null) {
            tileEntity.func_189515_b(cmp);
        }
        ThaumicTinkerer.logger.info("Storing a " + blockName + " with metadata " + metadata + " With NBT: " + cmp);
        ItemNBTHelper.getItemTag(focus).func_74782_a(TAG_TILE_CMP, (NBTBase)cmp);
        ItemNBTHelper.setBool(focus, TAG_AVAILABLE, true);
    }

    private void clearPickedBlock(ItemStack focus) {
        ItemNBTHelper.setBool(focus, TAG_AVAILABLE, false);
        ItemNBTHelper.getItemTag(focus).func_82580_o(TAG_TILE_CMP);
        ItemNBTHelper.getItemTag(focus).func_82580_o(TAG_BLOCK_NAME);
        ItemNBTHelper.getItemTag(focus).func_82580_o(TAG_BLOCK_META);
    }

    private NBTTagCompound getStackTileEntity(ItemStack focus) {
        NBTTagCompound cmp;
        if (ItemNBTHelper.getItemTag(focus).func_74764_b(TAG_TILE_CMP) && (cmp = ItemNBTHelper.getItemTag(focus).func_74775_l(TAG_TILE_CMP)).func_186856_d() != 0) {
            return cmp;
        }
        return null;
    }

    private IBlockState getStoredState(ItemStack focus) {
        if (!ItemNBTHelper.getBool(focus, TAG_AVAILABLE, false)) {
            return null;
        }
        ResourceLocation location = new ResourceLocation(ItemNBTHelper.getString(focus, TAG_BLOCK_NAME, "minecraft:air"));
        int metadata = ItemNBTHelper.getInteger(focus, TAG_BLOCK_META, 0);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(location);
        IBlockState state = Objects.requireNonNull(block).func_176203_a(metadata);
        return state;
    }

    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundsTC.hhoff, SoundCategory.PLAYERS, 0.8f, 0.45f + (float)(caster.field_70170_p.field_73012_v.nextGaussian() * (double)0.05f));
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        FXGeneric pp = new FXGeneric(world, posX, posY, posZ, velX, velY, velZ);
        pp.func_187114_a(9);
        pp.func_70538_b(0.25f + world.field_73012_v.nextFloat() * 0.25f, 0.25f + world.field_73012_v.nextFloat() * 0.25f, 0.25f + world.field_73012_v.nextFloat() * 0.25f);
        pp.setAlphaF(new float[]{0.0f, 0.6f, 0.6f, 0.0f});
        pp.setGridSize(64);
        pp.setParticles(448, 9, 1);
        pp.setScale(new float[]{0.5f, 0.25f});
        pp.setGravity((float)(world.field_73012_v.nextGaussian() * (double)0.009f));
        pp.setRandomMovementScale(0.0025f, 0.0025f, 0.0025f);
        ParticleEngine.addEffect((World)world, (Particle)pp);
    }

    public int getComplexity() {
        return 20;
    }

    public Aspect getAspect() {
        return Aspect.DESIRE;
    }

    public String getKey() {
        return "thaumictinkerer.dislocation";
    }

    public String getResearch() {
        return "TT_DISLOCATE";
    }
}

