/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items;

import com.google.common.collect.Multimap;
import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.api.Materials;
import com.nekokittygames.thaumictinkerer.api.MobAspect;
import com.nekokittygames.thaumictinkerer.api.MobAspects;
import com.nekokittygames.thaumictinkerer.common.items.ItemMobAspect;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;

@Mod.EventBusSubscriber(modid="thaumictinkerer")
public class ItemBloodSword
extends ItemSword {
    private static final int DAMAGE = 10;
    static int handleNext = 0;
    private final String baseName;

    public ItemBloodSword() {
        super(Materials.BLOOD_MATERIAL);
        this.baseName = "blood_sword";
        TTItem.setItemName((Item)this, this.baseName);
        this.func_77637_a(ThaumicTinkerer.getTab());
        this.func_185043_a(new ResourceLocation("active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return stack.func_77978_p() != null && stack.func_77978_p().func_74762_e("active") != 0 ? 1.0f : 0.0f;
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            if (nbtTagCompound == null) {
                nbtTagCompound = new NBTTagCompound();
                stack.func_77982_d(nbtTagCompound);
            }
            nbtTagCompound.func_74768_a("active", (nbtTagCompound.func_74762_e("active") + 1) % 2);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 10.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 0.25, 1));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(UUID.fromString("66666666-2333-1234-CBAD-BCCE9785ACA6"), "Movement Speed", 0.25, 2));
        }
        return multimap;
    }

    public float func_150931_i() {
        return 10.0f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        boolean handle;
        boolean sup = super.func_77644_a(stack, target, attacker);
        boolean bl = handle = handleNext == 0;
        if (!handle) {
            --handleNext;
        }
        if (sup && handle) {
            attacker.func_70097_a(DamageSource.field_76376_m, 2.0f);
        }
        return sup;
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        MobAspect mobAspect;
        EntityPlayer player;
        ItemStack stack;
        if (event.getSource() != null && event.getSource().func_76346_g() instanceof EntityPlayer && event.getSource().func_76346_g() != null && (stack = (player = (EntityPlayer)event.getSource().func_76346_g()).func_184614_ca()) != ItemStack.field_190927_a && stack.func_77973_b() == this && stack.func_77978_p() != null && stack.func_77978_p().func_74762_e("active") == 1 && (mobAspect = MobAspects.getAspects().get(event.getEntity().getClass())) != null) {
            event.getDrops().clear();
            ThaumicTinkerer.logger.debug("Outputting: " + mobAspect);
            for (Aspect aspect : mobAspect.getAspects().getAspects()) {
                int amount = mobAspect.getAspects().getAmount(aspect);
                ItemStack aspectStack = new ItemStack((Item)ModItems.mob_aspect);
                ItemMobAspect.setAspectType(aspectStack, aspect);
                aspectStack.func_190920_e(amount);
                EntityItem item = new EntityItem(event.getEntity().func_130014_f_(), event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, aspectStack);
                event.getDrops().add(item);
            }
        }
    }
}

