/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items;

import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.common.items.ItemCondensedMobAspect;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntitySummon;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;

public class ItemMobAspect
extends TTItem
implements IEssentiaContainerItem {
    public static String ASPECT_NAME = "aspectName";

    public ItemMobAspect(String name) {
        super(name);
    }

    public CreativeTabs func_77640_w() {
        return ThaumicTinkerer.getTabAspects();
    }

    public String GetVariant(ItemStack stack) {
        return stack.func_77978_p() != null ? stack.func_77978_p().func_74779_i(ASPECT_NAME) : "aer";
    }

    public static boolean isInfused(ItemStack item) {
        return item.func_77973_b() instanceof ItemCondensedMobAspect;
    }

    public Set<String> GetVariants() {
        return Aspect.aspects.keySet();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(ASPECT_NAME)) {
            Aspect aspect = Aspect.getAspect((String)stack.func_77978_p().func_74779_i(ASPECT_NAME));
            if (aspect != null) {
                tooltip.add(I18n.func_135052_a((String)"thaumictinkerer.mobaspect.type", (Object[])new Object[]{aspect.getName()}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"thaumictinkerer.mobaspect.invalid", (Object[])new Object[0]));
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"thaumictinkerer.mobaspect.invalid", (Object[])new Object[0]));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            TreeSet<String> sortedAspects = new TreeSet<String>(this.GetVariants());
            for (String aspect : sortedAspects) {
                ItemStack itemStack = new ItemStack((Item)this);
                NBTTagCompound cmp = itemStack.func_77978_p();
                if (cmp == null) {
                    cmp = new NBTTagCompound();
                }
                cmp.func_74778_a(ASPECT_NAME, aspect);
                itemStack.func_77982_d(cmp);
                ModItems.mob_aspect.setAspects(itemStack, new AspectList().add(Aspect.getAspect((String)aspect), 1));
                items.add((Object)itemStack);
            }
        }
    }

    public static boolean lastUsedTabletMatches(ItemStack stack, TileEntitySummon tablet) {
        if (stack.func_77978_p() == null) {
            return true;
        }
        return stack.func_77978_p().func_74762_e("LastX") == tablet.func_174877_v().func_177958_n() && stack.func_77978_p().func_74762_e("LastY") == tablet.func_174877_v().func_177956_o() && stack.func_77978_p().func_74762_e("LastZ") == tablet.func_174877_v().func_177952_p();
    }

    public static boolean isReadyForSummon(ItemStack stack, long currentTime) {
        return stack.func_77978_p() == null || stack.func_77978_p().func_74763_f("NextSummonTime") <= currentTime;
    }

    public static ItemStack setAspectType(ItemStack stack, Aspect aspect) {
        NBTTagCompound cmp = stack.func_77978_p();
        if (cmp == null) {
            cmp = new NBTTagCompound();
        }
        cmp.func_74778_a(ASPECT_NAME, aspect.getTag());
        stack.func_77982_d(cmp);
        ModItems.mob_aspect.setAspects(stack, new AspectList().add(aspect, 1));
        return stack;
    }

    public static void markLastUsedTablet(ItemStack stack, TileEntitySummon tablet) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("LastX", tablet.func_174877_v().func_177958_n());
        stack.func_77978_p().func_74768_a("LastY", tablet.func_174877_v().func_177956_o());
        stack.func_77978_p().func_74768_a("LastZ", tablet.func_174877_v().func_177952_p());
    }

    public static void markNextSummon(ItemStack stack, long nextTime) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74772_a("NextSummonTime", nextTime);
    }

    public static Aspect getAspectType(ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return null;
        }
        NBTTagCompound cmp = stack.func_77978_p();
        if (cmp == null) {
            return null;
        }
        String aspectName = cmp.func_74779_i(ASPECT_NAME);
        return Aspect.getAspect((String)aspectName);
    }

    public AspectList getAspects(ItemStack itemstack) {
        if (itemstack.func_77942_o()) {
            AspectList aspects = new AspectList();
            aspects.readFromNBT(itemstack.func_77978_p());
            return aspects.size() > 0 ? aspects : null;
        }
        return null;
    }

    public void setAspects(ItemStack itemstack, AspectList aspects) {
        if (!itemstack.func_77942_o()) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        aspects.writeToNBT(itemstack.func_77978_p());
    }

    public boolean ignoreContainedAspects() {
        return false;
    }
}

