/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items;

import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategory;
import thaumcraft.common.lib.CommandThaumcraft;

public class ItemShareBook
extends TTItem {
    private static final String TAG_PLAYER = "player";
    private static final String NON_ASIGNED = "[none]";

    public ItemShareBook() {
        super("share_book");
        this.func_77625_d(1);
    }

    private static String getPlayerName(ItemStack stack) {
        return ItemNBTHelper.getString(stack, TAG_PLAYER, NON_ASIGNED);
    }

    private static void setPlayerName(ItemStack stack, String name) {
        ItemNBTHelper.setString(stack, TAG_PLAYER, name);
    }

    private static void clearPlayerResearch(ItemStack stack) {
        ItemNBTHelper.getItemTag(stack).func_82580_o("research");
    }

    protected static void setPlayerObservations(ItemStack stack, EntityPlayer player) {
        NBTTagCompound cmp = ItemNBTHelper.getItemTag(stack);
        NBTTagList list = new NBTTagList();
        for (ResearchCategory category : ResearchCategories.researchCategories.values()) {
            int obs = ThaumcraftCapabilities.getKnowledge((EntityPlayer)player).getKnowledgeRaw(IPlayerKnowledge.EnumKnowledgeType.OBSERVATION, category);
            NBTTagCompound obsCmp = new NBTTagCompound();
            obsCmp.func_74778_a("category", category.key);
            obsCmp.func_74768_a("amount", obs);
            list.func_74742_a((NBTBase)obsCmp);
        }
        cmp.func_74782_a("observations", (NBTBase)list);
    }

    private static void setPlayerResearch(ItemStack stack, EntityPlayer playername) {
        Set researchesDone = ThaumcraftCapabilities.getKnowledge((EntityPlayer)playername).getResearchList();
        NBTTagCompound cmp = ItemNBTHelper.getItemTag(stack);
        NBTTagList list = new NBTTagList();
        for (String tag : researchesDone) {
            if (!ThaumcraftCapabilities.getKnowledge((EntityPlayer)playername).isResearchComplete(tag)) continue;
            list.func_74742_a((NBTBase)new NBTTagString(tag));
        }
        cmp.func_74782_a("research", (NBTBase)list);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack item = playerIn.func_184586_b(handIn);
        if (!playerIn.func_70093_af()) {
            if (item.func_77973_b() instanceof ItemShareBook) {
                String name = ItemShareBook.getPlayerName(item);
                if (name.endsWith(NON_ASIGNED)) {
                    ItemShareBook.setPlayerName(item, playerIn.func_146103_bH().getName());
                    ItemShareBook.setPlayerResearch(item, playerIn);
                    ItemShareBook.setPlayerObservations(item, playerIn);
                    if (!worldIn.field_72995_K) {
                        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("ttmisc.shareTome.write", new Object[0]), true);
                    }
                } else if (!worldIn.field_72995_K) {
                    Set<String> researchesDone = this.getPlayerResearch(item);
                    for (String researchkey : researchesDone) {
                        CommandThaumcraft.giveRecursiveResearch((EntityPlayer)playerIn, (String)researchkey);
                        ThaumcraftCapabilities.getKnowledge((EntityPlayer)playerIn).sync((EntityPlayerMP)playerIn);
                    }
                    Map<String, Integer> observations = this.getPlayerObservations(item);
                    for (String category : observations.keySet()) {
                        int curAmmount = ThaumcraftCapabilities.getKnowledge((EntityPlayer)playerIn).getKnowledgeRaw(IPlayerKnowledge.EnumKnowledgeType.OBSERVATION, ResearchCategories.getResearchCategory((String)category));
                        int amtToAdd = Math.abs(observations.get(category) - curAmmount);
                        ThaumcraftCapabilities.getKnowledge((EntityPlayer)playerIn).addKnowledge(IPlayerKnowledge.EnumKnowledgeType.OBSERVATION, ResearchCategories.getResearchCategory((String)category), amtToAdd);
                    }
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("ttmisc.shareTome.sync", new Object[0]), true);
                }
            }
        } else {
            ItemShareBook.clearPlayerResearch(item);
            ItemShareBook.setPlayerName(item, NON_ASIGNED);
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("ttmisc.shareTome.clear", new Object[0]), true);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)item);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        String name = ItemShareBook.getPlayerName(stack);
        tooltip.add(name.equals(NON_ASIGNED) ? ThaumicTinkerer.proxy.localize("ttmisc.shareTome.noAssign", new Object[0]) : ThaumicTinkerer.proxy.localize("ttmisc.shareTome.playerName", name));
    }

    private Set<String> getPlayerResearch(ItemStack stack) {
        HashSet<String> retVals = new HashSet<String>();
        NBTTagCompound cmp = ItemNBTHelper.getItemTag(stack);
        if (!cmp.func_74764_b("research")) {
            return retVals;
        }
        NBTTagList list = cmp.func_150295_c("research", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            retVals.add(list.func_150307_f(i));
        }
        return retVals;
    }

    private Map<String, Integer> getPlayerObservations(ItemStack stack) {
        HashMap<String, Integer> retVals = new HashMap<String, Integer>();
        NBTTagCompound cmp = ItemNBTHelper.getItemTag(stack);
        if (!cmp.func_74764_b("observations")) {
            return retVals;
        }
        NBTTagList list = cmp.func_150295_c("observations", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound listCmp = list.func_150305_b(i);
            retVals.put(listCmp.func_74779_i("category"), listCmp.func_74762_e("amount"));
        }
        return retVals;
    }
}

