/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.SoundsTC;

public class ItemXPTalisman
extends TTItem
implements IBauble {
    private static final String TAG_XP = "xp";

    public ItemXPTalisman() {
        super("experience_charm");
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return ItemXPTalisman.this.getMetadata(stack);
            }
        });
    }

    public static boolean hasCmp(ItemStack stack) {
        return ItemNBTHelper.detectNBT(stack);
    }

    public static int getXP(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_XP, 0);
    }

    public static void setXP(ItemStack stack, int xp) {
        ItemNBTHelper.setInt(stack, TAG_XP, xp);
    }

    public ActionResult<ItemStack> func_77659_a(World par2World, EntityPlayer par3EntityPlayer, EnumHand hand) {
        ItemStack stack;
        boolean has;
        ItemStack par1ItemStack = par3EntityPlayer.func_184586_b(hand);
        if (par3EntityPlayer.func_70093_af()) {
            if (ItemXPTalisman.getXP(par1ItemStack) < 1500) {
                int dmg = par1ItemStack.func_77952_i();
                par1ItemStack.func_77964_b(~dmg & 1);
                par2World.func_184133_a(null, par3EntityPlayer.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.NEUTRAL, 0.3f, 0.1f);
            }
        } else if (ItemXPTalisman.getXP(par1ItemStack) >= 10 && (has = par3EntityPlayer.field_71071_by.func_70431_c(stack = new ItemStack(Items.field_151069_bo)))) {
            if (!par2World.field_72995_K) {
                par3EntityPlayer.field_71071_by.func_70301_a(par3EntityPlayer.field_71071_by.func_184429_b(stack)).func_190918_g(1);
                if (!par3EntityPlayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151062_by, 1))) {
                    par3EntityPlayer.func_145779_a(Items.field_151062_by, 1);
                }
            }
            int xp = ItemXPTalisman.getXP(par1ItemStack);
            ItemXPTalisman.setXP(par1ItemStack, xp - 10);
            par2World.func_184133_a(null, par3EntityPlayer.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.NEUTRAL, 0.1f, (float)((double)0.1f + Math.random() / 2.0));
            for (int i = 0; par2World.field_72995_K && i < 6; ++i) {
                FXDispatcher.INSTANCE.sparkle((float)(par3EntityPlayer.field_70165_t + (Math.random() - 0.5)), (float)(par3EntityPlayer.field_70163_u + Math.random() - 0.5), (float)(par3EntityPlayer.field_70161_v + (Math.random() - 0.5)), 3.0f, 0.0f, 0.0f);
            }
        }
        return super.func_77659_a(par2World, par3EntityPlayer, hand);
    }

    private void consumeXPOrb(EntityXPOrb orb) {
        orb.func_70106_y();
        orb.field_70170_p.func_184133_a(null, orb.func_180425_c(), SoundsTC.zap, SoundCategory.NEUTRAL, (float)orb.func_70526_d() / 10.0f, 1.0f);
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World par2EntityPlayer, List<String> par3List, ITooltipFlag par4) {
        par3List.add("XP: " + ItemXPTalisman.getXP(par1ItemStack));
        if (ItemXPTalisman.getXP(par1ItemStack) >= 1500) {
            par3List.add(I18n.func_135052_a((String)"ttmisc.full", (Object[])new Object[0]));
        } else if (par1ItemStack.func_77952_i() == 0) {
            par3List.add(I18n.func_135052_a((String)"ttmisc.notAbsorbing", (Object[])new Object[0]));
        } else {
            par3List.add(I18n.func_135052_a((String)"ttmisc.absorbing", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.UNCOMMON;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.CHARM;
    }

    public void onWornTick(ItemStack par1ItemStack, EntityLivingBase player) {
        World par2World = player.field_70170_p;
        if (par1ItemStack.func_77952_i() == 1 && !par2World.field_72995_K) {
            int r = 3;
            int currentXP = ItemXPTalisman.getXP(par1ItemStack);
            int xpToAdd = 0;
            int maxXP = 1500 - currentXP;
            if (maxXP <= 0) {
                par1ItemStack.func_77964_b(0);
                return;
            }
            AxisAlignedBB boundingBox = new AxisAlignedBB(player.field_70165_t - (double)r, player.field_70163_u - (double)r, player.field_70161_v - (double)r, player.field_70165_t + (double)r, player.field_70163_u + (double)r, player.field_70161_v + (double)r);
            List orbs = par2World.func_72872_a(EntityXPOrb.class, boundingBox);
            for (EntityXPOrb orb : orbs) {
                if (orb.field_70128_L) continue;
                int xp = orb.func_70526_d();
                if (xpToAdd + xp <= maxXP) {
                    xpToAdd += xp;
                    this.consumeXPOrb(orb);
                }
                if ((maxXP -= xpToAdd) > 0) continue;
                break;
            }
            ItemXPTalisman.setXP(par1ItemStack, Math.min(1500, currentXP + xpToAdd));
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

