/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items.Kami;

import com.nekokittygames.thaumictinkerer.client.misc.ModelWings;
import com.nekokittygames.thaumictinkerer.common.helper.ProjectileHelper;
import com.nekokittygames.thaumictinkerer.common.items.ItemEnergeticNitor;
import com.nekokittygames.thaumictinkerer.common.items.Kami.ItemIchorArmor;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IGoggles;
import thaumcraft.codechicken.lib.vec.Vector3;
import thaumcraft.common.lib.events.PlayerEvents;

public class ItemKamiArmor
extends ItemIchorArmor
implements IGoggles {
    public static List<String> playersWith1Step = new ArrayList<String>();
    private static final WeakHashMap<EntityLivingBase, Object> armorModels = new WeakHashMap();

    public ItemKamiArmor(String name, ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(name, materialIn, renderIndexIn, equipmentSlotIn);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    void tickPlayer(EntityPlayer player) {
        ItemStack armor = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (armor.func_77952_i() == 1) {
            return;
        }
        player.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 100, 1, true, false));
        if (player.field_70170_p.field_72995_K) {
            float f = player.field_70138_W = player.func_70093_af() ? 0.5f : 1.0f;
        }
        if (!player.field_71075_bZ.field_75100_b && player.field_191988_bg > 0.0f) {
            if (player.field_70170_p.field_72995_K && !player.func_70093_af()) {
                if (!PlayerEvents.prevStep.containsKey(player.func_145782_y())) {
                    PlayerEvents.prevStep.put(player.func_145782_y(), Float.valueOf(player.field_70138_W));
                }
                player.field_70138_W = 1.0f;
            }
            if (player.field_70122_E) {
                float bonus = 0.15f;
                if (player.func_70090_H()) {
                    bonus *= 1.25f;
                }
                player.func_191958_b(0.0f, 0.0f, bonus, 1.0f);
            } else if (player.func_70090_H()) {
                player.func_191958_b(0.0f, 0.0f, 0.075f, 1.0f);
            }
        }
        player.field_70747_aH = player.func_70051_ag() ? 0.05f : 0.04f;
        player.field_70143_R = 0.0f;
        if (player.field_70170_p.func_180495_p(player.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150346_d && Blocks.field_150346_d.func_176201_c(player.field_70170_p.func_180495_p(player.func_180425_c().func_177977_b())) == 0) {
            player.field_70170_p.func_180501_a(player.func_180425_c().func_177977_b(), Blocks.field_150349_c.func_176223_P(), 2);
        }
    }

    private void setNearBrightNitor(EntityPlayer player) {
        int x = (int)Math.floor(player.field_70165_t);
        int y = (int)player.field_70163_u + 1;
        int z = (int)Math.floor(player.field_70161_v);
        float yaw = MathHelper.func_76142_g((float)(player.field_70177_z + 90.0f)) * (float)Math.PI / 180.0f;
        Vector3 lookVector = new Vector3(Math.cos(yaw), Math.sin(yaw), 0.0).normalize();
        Vector3 newVector = new Vector3(lookVector.x, lookVector.y, 0.0);
        for (int i = 0; i < 5; ++i) {
            newVector = newVector.add(lookVector);
            int x1 = x + (int)newVector.x;
            int z1 = z + (int)newVector.y;
            ItemEnergeticNitor.setBlock(new BlockPos(x1, y, z1), player.field_70170_p);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().field_70170_p.field_72995_K) {
            boolean hasHighStep;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean highStepListed = playersWith1Step.contains(player.func_146103_bH().getName());
            boolean bl = hasHighStep = player.func_184582_a(EntityEquipmentSlot.FEET) != ItemStack.field_190927_a && player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == this;
            if (!highStepListed && hasHighStep && player.func_184582_a(EntityEquipmentSlot.FEET).func_77952_i() == 0) {
                playersWith1Step.add(player.func_146103_bH().getName());
            }
            if ((!hasHighStep || player.func_184582_a(EntityEquipmentSlot.FEET).func_77952_i() == 1) && highStepListed) {
                playersWith1Step.remove(player.func_146103_bH().getName());
                player.field_70138_W = 0.5f;
            }
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        switch (this.field_77881_a) {
            case HEAD: {
                int food;
                if (itemStack.func_77952_i() == 1) break;
                player.func_70050_g(300);
                if (player.func_130014_f_().func_180495_p(player.func_180425_c().func_177984_a()).func_185904_a() == Material.field_151586_h) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 400, 0, true, false));
                }
                if (player.func_130014_f_().func_180495_p(player.func_180425_c().func_177984_a()).func_185904_a() == Material.field_151587_i && player.field_70173_aa % 10 == 0) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 31, 0, true, false));
                }
                if ((food = player.func_71024_bL().func_75116_a()) <= 0 || food >= 18 || !player.func_70996_bM() || player.field_70173_aa % 80 != 0) break;
                player.func_70691_i(1.0f);
                break;
            }
            case CHEST: {
                if (itemStack.func_77952_i() == 1) break;
                player.getEntityData().func_74757_a("can_fly", true);
                this.doProjectileEffect(player);
                break;
            }
            case LEGS: {
                if (itemStack.func_77952_i() == 1) break;
                if (player.func_70660_b(MobEffects.field_76426_n) == null || player.func_70660_b(MobEffects.field_76426_n).func_76459_b() <= 1) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 20, 0, false, false));
                    if (player.func_70027_ad()) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 20, 1, true, false));
                        player.func_70066_B();
                    }
                }
                this.setNearBrightNitor(player);
                break;
            }
            case FEET: {
                this.tickPlayer(player);
            }
        }
    }

    @Override
    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.EPIC;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "thaumictinkerer:textures/models/armor/kami_layer_" + (slot == EntityEquipmentSlot.LEGS ? "2" : "1") + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return armorSlot == EntityEquipmentSlot.CHEST ? (ModelWings)((Object)armorModels.computeIfAbsent(entityLiving, ignored -> new ModelWings())) : super.getArmorModel(entityLiving, itemStack, armorSlot, _default);
    }

    public boolean showIngamePopups(ItemStack stack, EntityLivingBase owner) {
        return this.field_77881_a == EntityEquipmentSlot.HEAD;
    }

    private void doProjectileEffect(EntityPlayer mp) {
        if (!mp.func_70093_af()) {
            List projectiles = mp.field_70170_p.func_175647_a(Entity.class, new AxisAlignedBB(mp.field_70165_t - 4.0, mp.field_70163_u - 4.0, mp.field_70161_v - 4.0, mp.field_70165_t + 3.0, mp.field_70163_u + 3.0, mp.field_70161_v + 3.0), e -> e instanceof IProjectile);
            for (Entity potion : projectiles) {
                if (ProjectileHelper.getOwner(potion) == mp) continue;
                Vector3 motionVec = new Vector3(potion.field_70159_w, potion.field_70181_x, potion.field_70179_y).normalize().multiply(Math.sqrt((potion.field_70165_t - mp.field_70165_t) * (potion.field_70165_t - mp.field_70165_t) + (potion.field_70163_u - mp.field_70163_u) * (potion.field_70163_u - mp.field_70163_u) + (potion.field_70161_v - mp.field_70161_v) * (potion.field_70161_v - mp.field_70161_v)) * 2.0);
                potion.field_70165_t += motionVec.x;
                potion.field_70163_u += motionVec.y;
                potion.field_70161_v += motionVec.z;
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            int dmg = stack.func_77952_i();
            stack.func_77964_b(~dmg & 1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77952_i() == 1) {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"tip.awakenarmor.name1", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tip.awakenarmor.name0", (Object[])new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

