/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.items.Kami;

import com.nekokittygames.thaumictinkerer.common.blocks.ModBlocks;
import com.nekokittygames.thaumictinkerer.common.items.TTItem;
import com.nekokittygames.thaumictinkerer.common.misc.MiscHelper;
import com.nekokittygames.thaumictinkerer.common.utils.ItemNBTHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.codechicken.lib.vec.Vector3;

public class ItemSkyPearl
extends TTItem {
    public static final String TAG_X = "x";
    public static final String TAG_Y = "y";
    public static final String TAG_Z = "z";
    public static final String TAG_DIM = "dim";

    public ItemSkyPearl() {
        super("sky_pearl");
        this.func_77625_d(1);
    }

    public static void addInfo(ItemStack stack, int dim, Vector3 pos, List<String> list, boolean simpleMode) {
        if (ItemSkyPearl.isAttuned(stack)) {
            int x = ItemSkyPearl.getX(stack);
            int y = ItemSkyPearl.getY(stack);
            int z = ItemSkyPearl.getZ(stack);
            list.add("X: " + x);
            if (!simpleMode) {
                list.add("Y: " + y);
            }
            list.add("Z: " + z);
            if (ItemSkyPearl.getDim(stack) != dim) {
                if (!simpleMode) {
                    list.add(TextFormatting.RED + I18n.func_74838_a((String)"ttmisc.differentDim"));
                }
            } else {
                list.add(TextFormatting.BLUE + I18n.func_74838_a((String)"ttmisc.distance") + ": " + BigDecimal.valueOf(MiscHelper.pointDistanceSpace(x, simpleMode ? 0.0 : (double)y, z, pos.x, simpleMode ? 0.0 : pos.y, pos.z)).setScale(2, RoundingMode.UP) + "m");
            }
        }
    }

    public static void setValues(ItemStack stack, BlockPos pos, int dim) {
        ItemNBTHelper.setInt(stack, TAG_X, pos.func_177958_n());
        ItemNBTHelper.setInt(stack, TAG_Y, pos.func_177956_o());
        ItemNBTHelper.setInt(stack, TAG_Z, pos.func_177952_p());
        ItemNBTHelper.setInt(stack, TAG_DIM, dim);
    }

    public static boolean isAttuned(ItemStack stack) {
        return stack.func_77942_o() && ItemNBTHelper.getInt(stack, TAG_Y, -1) != -1;
    }

    public static int getX(ItemStack stack) {
        if (!ItemSkyPearl.isAttuned(stack)) {
            return 0;
        }
        return ItemNBTHelper.getInt(stack, TAG_X, 0);
    }

    public static int getY(ItemStack stack) {
        if (!ItemSkyPearl.isAttuned(stack)) {
            return 0;
        }
        return ItemNBTHelper.getInt(stack, TAG_Y, 0);
    }

    public static int getZ(ItemStack stack) {
        if (!ItemSkyPearl.isAttuned(stack)) {
            return 0;
        }
        return ItemNBTHelper.getInt(stack, TAG_Z, 0);
    }

    public static int getDim(ItemStack stack) {
        if (!ItemSkyPearl.isAttuned(stack)) {
            return 0;
        }
        return ItemNBTHelper.getInt(stack, TAG_DIM, 0);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == ModBlocks.warp_gate && !ItemSkyPearl.isAttuned(stack)) {
            ItemSkyPearl.setValues(stack, pos, player.field_71093_bK);
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.3f, 0.1f);
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() && ItemSkyPearl.isAttuned(stack)) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.3f, 0.1f);
            ItemNBTHelper.setInt(stack, TAG_Y, -1);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (ItemSkyPearl.isAttuned(stack)) {
            int x = ItemSkyPearl.getX(stack);
            int y = ItemSkyPearl.getY(stack);
            int z = ItemSkyPearl.getZ(stack);
            list.add("X: " + x);
            list.add("Y: " + y);
            list.add("Z: " + z);
        }
    }

    public boolean func_77636_d(ItemStack par1ItemStack) {
        return ItemSkyPearl.isAttuned(par1ItemStack);
    }

    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return EnumRarity.EPIC;
    }
}

