/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.misc;

import com.nekokittygames.thaumictinkerer.common.enchantments.TTEnchantments;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thaumcraft.common.lib.SoundsTC;

@Mod.EventBusSubscriber(modid="thaumictinkerer")
public class EnchantmentEvents {
    public static final String NBTLastTarget = "TTEnchantLastTarget";
    public static final String NBTSuccessiveStrike = "TTEnchantSuccessiveStrike";
    public static final String NBTTunnelDirection = "TTEnchantTunnelDir";

    public static void register(ResourceLocation resourceLocation) {
    }

    @SubscribeEvent
    public static void playerJumps(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack1 = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS);
            int boost = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.ascentboost, (ItemStack)stack1);
            if (boost >= 1 && !player.func_70093_af()) {
                player.field_70181_x *= (double)(boost + 2) / 2.0;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayer player;
        int slowfall;
        double min = -0.0784000015258789;
        if (event.getEntityLiving() instanceof EntityPlayer && (slowfall = EnchantmentHelper.func_185284_a((Enchantment)TTEnchantments.slowfall, (EntityLivingBase)(player = (EntityPlayer)event.getEntityLiving()))) > 0 && !event.getEntityLiving().func_70093_af() && event.getEntityLiving().field_70181_x < -0.0784000015258789 && (double)event.getEntityLiving().field_70143_R >= 2.9) {
            event.getEntityLiving().field_70181_x /= (double)(1.0f + (float)slowfall * 0.33f);
            event.getEntityLiving().field_70143_R = Math.max(2.9f, player.field_70143_R - (float)slowfall / 3.0f);
            player.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, player.field_70165_t + 0.25, player.field_70163_u - 1.0, player.field_70161_v + 0.25, -player.field_70159_w, player.field_70181_x, -player.field_70179_y, new int[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onEvent(LivingEntityUseItemEvent.Tick event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            ItemStack item = event.getItem();
            int time = event.getDuration();
            int quickDraw = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.quickdraw, (ItemStack)item);
            if (item.func_190926_b()) {
                return;
            }
            if (quickDraw > 0 && item.func_77973_b() instanceof ItemBow && (item.func_77973_b().func_77626_a(item) - time) % (6 - quickDraw) == 0) {
                event.setDuration(time - 1);
            }
        }
    }

    @SubscribeEvent
    public static void fall(LivingFallEvent e) {
        int shockwave;
        ItemStack boots = e.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET);
        if (e.getEntityLiving() instanceof EntityPlayer && (shockwave = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.shockwave, (ItemStack)boots)) > 0) {
            for (EntityLivingBase target : e.getEntity().field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(e.getEntity().field_70165_t - 10.0, e.getEntity().field_70163_u - 10.0, e.getEntity().field_70161_v - 10.0, e.getEntity().field_70165_t + 10.0, e.getEntity().field_70163_u + 10.0, e.getEntity().field_70161_v + 10.0))) {
                if (target == e.getEntity() || !(e.getDistance() > 3.0f)) continue;
                target.func_70097_a(DamageSource.field_76379_h, 0.1f * (float)shockwave * e.getDistance());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDamaged(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityLivingBase) {
            int vampirism;
            int valiance;
            Random rand;
            int finalStrike;
            BlockPos pos;
            EntityPlayer player;
            ItemStack legs;
            int pounce;
            EntityLivingBase attacker = (EntityLivingBase)event.getSource().func_76346_g();
            ItemStack heldItem = attacker.func_184586_b(EnumHand.MAIN_HAND);
            if (heldItem == null) {
                return;
            }
            if (attacker instanceof EntityPlayer && (pounce = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.pounce, (ItemStack)(legs = (player = (EntityPlayer)attacker).func_184582_a(EntityEquipmentSlot.LEGS)))) > 0 && player.field_70170_p.func_180495_p(pos = new BlockPos((int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u) - 1, (int)Math.floor(player.field_70161_v))) == Blocks.field_150350_a.func_176223_P()) {
                event.setAmount((float)((double)event.getAmount() * (1.0 + 0.25 * (double)pounce)));
            }
            if ((finalStrike = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.finalStrike, (ItemStack)heldItem)) > 0 && (rand = new Random()).nextInt(20 - finalStrike) == 0) {
                event.setAmount(event.getAmount() * 3.0f);
            }
            if ((valiance = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.valiance, (ItemStack)heldItem)) > 0 && attacker.func_110143_aJ() / attacker.func_110138_aP() < 0.5f) {
                event.setAmount((float)((double)event.getAmount() * (1.0 + 0.1 * (double)valiance)));
            }
            if ((vampirism = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.vamprisim, (ItemStack)heldItem)) > 0) {
                attacker.func_70691_i((float)vampirism);
                event.getEntityLiving().field_70170_p.func_184134_a(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, SoundsTC.zap, SoundCategory.NEUTRAL, 0.6f, 1.0f, false);
            }
            int focusedStrikes = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.focusedStrikes, (ItemStack)heldItem);
            int dispersedStrikes = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.dispersedStrikes, (ItemStack)heldItem);
            if (focusedStrikes > 0 || dispersedStrikes > 0) {
                int lastTarget = heldItem.func_77978_p().func_74762_e(NBTLastTarget);
                int successiveStrikes = heldItem.func_77978_p().func_74762_e(NBTSuccessiveStrike);
                int entityId = event.getEntityLiving().func_145782_y();
                if (lastTarget != entityId) {
                    heldItem.func_77978_p().func_74768_a(NBTSuccessiveStrike, 0);
                    successiveStrikes = 0;
                } else {
                    heldItem.func_77978_p().func_74768_a(NBTSuccessiveStrike, successiveStrikes + 1);
                    successiveStrikes = 1;
                }
                if (focusedStrikes > 0) {
                    event.setAmount(event.getAmount() / 2.0f);
                    event.setAmount((float)((double)event.getAmount() + 0.5 * (double)successiveStrikes * (double)event.getAmount() * (double)focusedStrikes));
                }
                if (dispersedStrikes > 0) {
                    event.setAmount((float)((double)event.getAmount() * (1.0 + 0.2 * (double)successiveStrikes)));
                    event.setAmount(event.getAmount() / (float)(1 + successiveStrikes * 2));
                }
                heldItem.func_77978_p().func_74768_a(NBTLastTarget, entityId);
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        ItemStack item = event.getPlayer().func_184586_b(EnumHand.MAIN_HAND);
        int tunnel = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.tunnel, (ItemStack)item);
        if (tunnel > 0) {
            float dir = event.getPlayer().field_70177_z;
            item.func_77978_p().func_74776_a(NBTTunnelDirection, dir);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGetHarvestSpeed(PlayerEvent.BreakSpeed event) {
        boolean autoSmeltApplies;
        int tunnel;
        ItemStack heldItem = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (heldItem == null) {
            return;
        }
        int shatter = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.shatter, (ItemStack)heldItem);
        if (shatter > 0) {
            if (event.getState().func_185887_b(event.getEntityPlayer().field_70170_p, BlockPos.field_177992_a) > 20.0f) {
                event.setNewSpeed(event.getOriginalSpeed() * 3.0f * (float)shatter);
            } else {
                event.setNewSpeed((float)((double)event.getOriginalSpeed() * 0.8));
            }
        }
        if ((tunnel = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.tunnel, (ItemStack)heldItem)) > 0) {
            float dir = event.getEntityPlayer().field_70177_z;
            if (heldItem.func_77978_p() != null && heldItem.func_77978_p().func_74764_b(NBTTunnelDirection)) {
                float oldDir = heldItem.func_77978_p().func_74760_g(NBTTunnelDirection);
                float dif = Math.abs(oldDir - dir);
                if (dif < 50.0f) {
                    event.setNewSpeed((float)((double)event.getOriginalSpeed() * (1.0 + 0.2 * (double)tunnel)));
                } else {
                    event.setNewSpeed((float)((double)event.getOriginalSpeed() * 0.3));
                }
            }
        }
        int desintegrate = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.desintegrate, (ItemStack)heldItem);
        int autoSmelt = EnchantmentHelper.func_77506_a((Enchantment)TTEnchantments.autosmelt, (ItemStack)heldItem);
        boolean desintegrateApplies = desintegrate > 0 && event.getState().func_185887_b(event.getEntityPlayer().field_70170_p, BlockPos.field_177992_a) <= 1.5f;
        boolean bl = autoSmeltApplies = autoSmelt > 0 && event.getState().func_185904_a() == Material.field_151575_d;
        if (desintegrateApplies || autoSmeltApplies) {
            heldItem.func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
            event.setNewSpeed(Float.MAX_VALUE);
        } else if (desintegrate > 0 || autoSmelt > 0) {
            event.setCanceled(true);
        }
    }
}

