/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.multiblocks;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class MultiblockBlockType {
    private String blockName;
    private List<IBlockState> blockTypes = new ArrayList<IBlockState>();

    MultiblockBlockType(JsonObject object) throws Exception {
        if (!object.has("name")) {
            throw new IOException("Multiblock json malformed, missing name for object " + object.toString());
        }
        this.blockName = object.get("name").getAsString();
        if (!object.has("block")) {
            throw new IOException("Multiblock json malformed, missing block array for object " + object.toString());
        }
        JsonElement blocksObject = object.get("block");
        if (blocksObject.isJsonArray()) {
            JsonArray blocks = (JsonArray)blocksObject;
            for (JsonElement block : blocks) {
                this.addBlock(block);
            }
        } else {
            this.addBlock(blocksObject);
        }
    }

    private void addBlock(JsonElement blocksObject) throws Exception {
        IBlockState state;
        if (blocksObject.isJsonObject()) {
            JsonObject blockObj = (JsonObject)blocksObject;
            if (!blockObj.has("blockType")) {
                throw new IOException("Multiblock json malformed, missing block array for object " + blockObj.toString());
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockObj.get("blockType").getAsString()));
            int meta = 0;
            if (blockObj.has("blockMeta")) {
                meta = blockObj.get("blockMeta").getAsInt();
            }
            state = Objects.requireNonNull(block).func_176203_a(meta);
        } else {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blocksObject.getAsString()));
            state = Objects.requireNonNull(block).func_176203_a(0);
        }
        this.blockTypes.add(state);
    }

    protected String getBlockName() {
        return this.blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public List<IBlockState> getBlockTypes() {
        return this.blockTypes;
    }
}

