/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.recipes;

import com.nekokittygames.thaumictinkerer.common.blocks.ModBlocks;
import com.nekokittygames.thaumictinkerer.common.compat.botania.BotaniaCompat;
import com.nekokittygames.thaumictinkerer.common.foci.FocusEffectTelekenesis;
import com.nekokittygames.thaumictinkerer.common.items.ItemInfusedSeeds;
import com.nekokittygames.thaumictinkerer.common.items.ItemMobAspect;
import com.nekokittygames.thaumictinkerer.common.items.ModItems;
import com.nekokittygames.thaumictinkerer.common.libs.LibRecipes;
import com.nekokittygames.thaumictinkerer.common.recipes.SpellClothRecipe;
import com.nekokittygames.thaumictinkerer.common.recipes.TTDustTriggerMultiblock;
import com.nekokittygames.thaumictinkerer.common.recipes.ing.TTFocusIngredient;
import com.nekokittygames.thaumictinkerer.common.recipes.ing.TTIngredientNBT;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.Part;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.misc.BlockNitor;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.items.resources.ItemCrystalEssence;

public class ModRecipes {
    private static final ResourceLocation defaultGroup = new ResourceLocation("");

    public static void initializeRecipes(IForgeRegistry<IRecipe> registry) {
        ModRecipes.registerOreDict();
        ModRecipes.initializeCraftingRecipes(registry);
        ModRecipes.initializeCauldronRecipes();
        ModRecipes.initializeArcaneRecipes();
        ModRecipes.initializeInfusionRecipes();
        ModRecipes.initializeMultiblockRecipes();
        BotaniaCompat.addOreDict();
    }

    private static void registerOreDict() {
        OreDictionary.registerOre((String)"blockQuartzDark", (Block)ModBlocks.black_quartz_block);
        OreDictionary.registerOre((String)"quartzDark", (Item)ModItems.black_quartz);
    }

    private static void initializeMultiblockRecipes() {
        Part AB = new Part((Object)BlocksTC.stoneArcaneBrick, (Object)BlocksTC.stoneArcaneBrick);
        Part BQ = new Part((Object)"blockQuartzDark", (Object)ModBlocks.black_quartz_block);
        Part DBQ = new Part((Object)ModBlocks.black_quartz_block, (Object)ModBlocks.black_quartz_block);
        Part[] pillars = new Part[16];
        for (int i = 0; i < 16; ++i) {
            pillars[i] = new Part((Object)BlocksTC.stoneArcane, (Object)new ItemStack((Block)Objects.requireNonNull(ModBlocks.enchantment_pillar), 1, i));
        }
        Part NR = new Part(BlockNitor.class, (Object)"AIR");
        Part DN = new Part((Object)ModBlocks.dummy_nitor, (Object)"AIR");
        Part OE = new Part((Object)ModBlocks.osmotic_enchanter, (Object)ModBlocks.osmotic_enchanter);
        Part[][][] enchanterBP = new Part[][][]{{{null, null, null, NR, null, null, null}, {null, NR, null, null, null, NR, null}, {null, null, null, null, null, null, null}, {NR, null, null, null, null, null, NR}, {null, null, null, null, null, null, null}, {null, NR, null, null, null, NR, null}, {null, null, null, NR, null, null, null}}, {{null, null, null, pillars[15], null, null, null}, {null, pillars[14], null, null, null, pillars[8], null}, {null, null, null, null, null, null, null}, {pillars[13], null, null, null, null, null, pillars[9]}, {null, null, null, null, null, null, null}, {null, pillars[12], null, null, null, pillars[10], null}, {null, null, null, pillars[11], null, null, null}}, {{null, null, null, pillars[7], null, null, null}, {null, pillars[6], null, null, null, pillars[0], null}, {null, null, null, null, null, null, null}, {pillars[5], null, null, OE, null, null, pillars[1]}, {null, null, null, null, null, null, null}, {null, pillars[4], null, null, null, pillars[2], null}, {null, null, null, pillars[3], null, null, null}}, {{null, null, AB, AB, AB, null, null}, {null, AB, AB, BQ, AB, AB, null}, {AB, AB, BQ, BQ, BQ, AB, AB}, {AB, BQ, BQ, BQ, BQ, BQ, AB}, {AB, AB, BQ, BQ, BQ, AB, AB}, {null, AB, AB, BQ, AB, AB, null}, {null, null, AB, AB, AB, null, null}}};
        Part[][][] dummyenchanterBP = new Part[][][]{{{null, null, null, DN, null, null, null}, {null, DN, null, null, null, DN, null}, {null, null, null, null, null, null, null}, {DN, null, null, null, null, null, DN}, {null, null, null, null, null, null, null}, {null, DN, null, null, null, DN, null}, {null, null, null, DN, null, null, null}}, {{null, null, null, pillars[15], null, null, null}, {null, pillars[14], null, null, null, pillars[8], null}, {null, null, null, null, null, null, null}, {pillars[13], null, null, null, null, null, pillars[9]}, {null, null, null, null, null, null, null}, {null, pillars[12], null, null, null, pillars[10], null}, {null, null, null, pillars[11], null, null, null}}, {{null, null, null, pillars[7], null, null, null}, {null, pillars[6], null, null, null, pillars[0], null}, {null, null, null, null, null, null, null}, {pillars[5], null, null, OE, null, null, pillars[1]}, {null, null, null, null, null, null, null}, {null, pillars[4], null, null, null, pillars[2], null}, {null, null, null, pillars[3], null, null, null}}, {{null, null, AB, AB, AB, null, null}, {null, AB, AB, DBQ, AB, AB, null}, {AB, AB, DBQ, DBQ, DBQ, AB, AB}, {AB, DBQ, DBQ, DBQ, DBQ, DBQ, AB}, {AB, AB, DBQ, DBQ, DBQ, AB, AB}, {null, AB, AB, DBQ, AB, AB, null}, {null, null, AB, AB, AB, null, null}}};
        IDustTrigger.registerDustTrigger((IDustTrigger)new TTDustTriggerMultiblock("TT_ENCHANTER", enchanterBP));
        ThaumcraftApi.addMultiblockRecipeToCatalog((ResourceLocation)LibRecipes.OSMOTIC_ENCHANTER_MB, (ThaumcraftApi.BluePrint)new ThaumcraftApi.BluePrint("TT_ENCHANTER", (Part[][][])dummyenchanterBP, new ItemStack[]{new ItemStack((Block)Objects.requireNonNull(ModBlocks.black_quartz_block), 13), new ItemStack(BlocksTC.stoneArcaneBrick, 24), new ItemStack(BlocksTC.stoneArcane, 16), new ItemStack((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW), 8)}));
    }

    private static void initializeCauldronRecipes() {
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.PRISMARINE, (CrucibleRecipe)new CrucibleRecipe("TT_PRISMARINE", new ItemStack(Items.field_179562_cC), (Object)"paneGlass", new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 5)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.SOUL_MOLD, (CrucibleRecipe)new CrucibleRecipe("TT_THAUMIC_MAGNETS", new ItemStack((Item)Objects.requireNonNull(ModItems.soul_mould)), (Object)new ItemStack(Items.field_151079_bi), new AspectList().add(Aspect.BEAST, 5).add(Aspect.MIND, 10).add(Aspect.SENSES, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.SPELLBINDING_CLOTH, (CrucibleRecipe)new CrucibleRecipe("TT_SPELLBINDING_CLOTH", new ItemStack((Item)Objects.requireNonNull(ModItems.spellbinding_cloth)), (Object)new ItemStack(ItemsTC.fabric), new AspectList().add(Aspect.EXCHANGE, 4).add(Aspect.ENTROPY, 6).add(Aspect.MAGIC, 10)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.ENERGETIC_NITOR, (CrucibleRecipe)new CrucibleRecipe("TT_ENERGETIC_NITOR", new ItemStack((Item)ModItems.energetic_nitor), (Object)new ItemStack((Block)BlocksTC.nitor.get(EnumDyeColor.YELLOW)), new AspectList().add(Aspect.FIRE, 30).add(Aspect.AIR, 30).add(Aspect.LIGHT, 45).add(Aspect.ENERGY, 60)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.LIGHT_GAS, (CrucibleRecipe)new CrucibleRecipe("TT_GAS", new ItemStack((Item)ModItems.gas_light_item), (Object)new ItemStack(ItemsTC.phial), new AspectList().add(Aspect.AIR, 10).add(Aspect.LIGHT, 20).add(Aspect.MOTION, 20)));
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)LibRecipes.SHADOW_GAS, (CrucibleRecipe)new CrucibleRecipe("TT_GAS", new ItemStack((Item)ModItems.gas_shadow_item), (Object)new ItemStack(ItemsTC.phial), new AspectList().add(Aspect.AIR, 10).add(Aspect.DARKNESS, 20).add(Aspect.MOTION, 20)));
    }

    private static void initializeCraftingRecipes(IForgeRegistry<IRecipe> registry) {
        registry.register(new SpellClothRecipe().setRegistryName("thaumictinkerer", "spellbinding_cloth"));
    }

    private static void initializeArcaneRecipes() {
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.FUNNEL, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ESSENTIA_FUNNEL", 60, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.funnel)), new Object[]{"STS", Character.valueOf('S'), Blocks.field_150348_b, Character.valueOf('T'), "ingotThaumium"}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.DISSIMULATION, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_DISSIMULATION", 30, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.dissimulation)), new Object[]{"BEB", "PBP", "BEB", Character.valueOf('B'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('E'), new ItemStack(Items.field_151119_aD), Character.valueOf('P'), new ItemStack(Items.field_179562_cC)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.TRANSVECTOR_INTERFACE, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_TRANSVECTOR_INTERFACE@2", 200, new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.transvector_interface)), new Object[]{"BRB", "LEL", "BDB", Character.valueOf('B'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('R'), "dustRedstone", Character.valueOf('L'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('E'), new ItemStack(Items.field_151079_bi), Character.valueOf('D'), new ItemStack((Block)Objects.requireNonNull(ModBlocks.dissimulation))}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.TRANSVECTOR_DISLOCATOR, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_TRANSVECTOR_INTERFACE", 200, new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 5), new ItemStack((Block)Objects.requireNonNull(ModBlocks.transvector_dislocator)), new Object[]{" M ", " T ", " C ", Character.valueOf('M'), new ItemStack(ItemsTC.mirroredGlass), Character.valueOf('T'), new ItemStack((Block)ModBlocks.transvector_interface), Character.valueOf('C'), new ItemStack(Items.field_151132_bS)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.GAS_REMOVER, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_GAS_REMOVER", 10, new AspectList().add(Aspect.AIR, 2).add(Aspect.ORDER, 2), new ItemStack(ModItems.gas_remover), new Object[]{"BBB", "S L", "WWW", Character.valueOf('S'), ModItems.gas_shadow_item, Character.valueOf('L'), ModItems.gas_light_item, Character.valueOf('B'), "quartzDark", Character.valueOf('W'), "gemQuartz"}));
        ItemStack airCrystal = new ItemStack(ItemsTC.crystalEssence);
        ((ItemCrystalEssence)ItemsTC.crystalEssence).setAspects(airCrystal, new AspectList().add(Aspect.AIR, 1));
        ItemStack earthCrystal = new ItemStack(ItemsTC.crystalEssence);
        ((ItemCrystalEssence)ItemsTC.crystalEssence).setAspects(earthCrystal, new AspectList().add(Aspect.EARTH, 1));
        ItemStack focus = new ItemStack(ItemsTC.focus1);
        FocusPackage focusPackage = new FocusPackage();
        focusPackage.addNode((IFocusElement)new FocusEffectTelekenesis());
        ItemFocus.setPackage((ItemStack)focus, (FocusPackage)focusPackage);
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.MOB_MAGNET, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_THAUMIC_MAGNETS", 200, new AspectList().add(Aspect.AIR, 1).add(Aspect.ORDER, 1).add(Aspect.EARTH, 15).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.mob_magnet)), new Object[]{" C ", "ACE", "GFG", Character.valueOf('C'), new ItemStack(ItemsTC.ingots, 1, 0), Character.valueOf('A'), new TTIngredientNBT(airCrystal), Character.valueOf('E'), new TTIngredientNBT(earthCrystal), Character.valueOf('G'), new ItemStack(BlocksTC.logGreatwood), Character.valueOf('F'), new TTFocusIngredient(FocusEffectTelekenesis.class, focus)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.ITEM_MAGNET, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_THAUMIC_MAGNETS@1", 20, new AspectList().add(Aspect.AIR, 1).add(Aspect.ORDER, 1).add(Aspect.EARTH, 15).add(Aspect.ENTROPY, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.magnet)), new Object[]{" C ", "ACE", "GFG", Character.valueOf('C'), "ingotIron", Character.valueOf('A'), new TTIngredientNBT(airCrystal), Character.valueOf('E'), new TTIngredientNBT(earthCrystal), Character.valueOf('G'), new ItemStack(BlocksTC.logGreatwood), Character.valueOf('F'), new TTFocusIngredient(FocusEffectTelekenesis.class, focus)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)LibRecipes.TABLET, (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_TABLET", 20, new AspectList().add(Aspect.AIR, 3).add(Aspect.ORDER, 2).add(Aspect.FIRE, 1), new ItemStack((Block)Objects.requireNonNull(ModBlocks.animation_tablet)), new Object[]{"GIG", "ISI", Character.valueOf('G'), new ItemStack(Items.field_151043_k), Character.valueOf('I'), new ItemStack(Items.field_151042_j), Character.valueOf('S'), new ItemStack(ItemsTC.seals)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "revealing_helm"), (IArcaneRecipe)new ShapelessArcaneRecipe(defaultGroup, "TT_REVEALING", 5, new AspectList(), new ItemStack(ModItems.revealing_helm), new Object[]{new ItemStack(ItemsTC.goggles), new ItemStack(ItemsTC.thaumiumHelm)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichor_cloth"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHOR", 750, new AspectList().add(Aspect.AIR, 10).add(Aspect.WATER, 10).add(Aspect.ORDER, 10).add(Aspect.EARTH, 10).add(Aspect.FIRE, 10).add(Aspect.ENTROPY, 10), new ItemStack((Item)ModItems.kamiresource, 3, 4), new Object[]{"CCC", "III", "DDD", Character.valueOf('C'), new ItemStack(ItemsTC.fabric), Character.valueOf('I'), new ItemStack((Item)ModItems.kamiresource, 1, 2), Character.valueOf('D'), new ItemStack(Items.field_151045_i)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichor_ingot"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHOR", 500, new AspectList().add(Aspect.AIR, 5).add(Aspect.WATER, 5).add(Aspect.ORDER, 5).add(Aspect.EARTH, 5).add(Aspect.FIRE, 5).add(Aspect.ENTROPY, 5), new ItemStack((Item)ModItems.kamiresource, 1, 3), new Object[]{" T ", "IDI", " I ", Character.valueOf('T'), new ItemStack(ItemsTC.ingots, 1, 0), Character.valueOf('I'), new ItemStack((Item)ModItems.kamiresource, 1, 2), Character.valueOf('D'), new ItemStack(Items.field_151045_i)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichorium_sword"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHORIUMTOOLS", 150, new AspectList().add(Aspect.AIR, 3).add(Aspect.WATER, 3).add(Aspect.ORDER, 3).add(Aspect.EARTH, 3).add(Aspect.FIRE, 3).add(Aspect.ENTROPY, 3), new ItemStack((Item)ModItems.ichorium_sword), new Object[]{"I", "I", "S", Character.valueOf('I'), new ItemStack((Item)ModItems.kamiresource, 1, 3), Character.valueOf('S'), new ItemStack(BlocksTC.logSilverwood)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichorium_pick"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHORIUMTOOLS", 150, new AspectList().add(Aspect.AIR, 3).add(Aspect.WATER, 3).add(Aspect.ORDER, 3).add(Aspect.EARTH, 3).add(Aspect.FIRE, 3).add(Aspect.ENTROPY, 3), new ItemStack((Item)ModItems.ichorium_pick), new Object[]{"III", " S ", " S ", Character.valueOf('I'), new ItemStack((Item)ModItems.kamiresource, 1, 3), Character.valueOf('S'), new ItemStack(BlocksTC.logSilverwood)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichorium_shovel"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHORIUMTOOLS", 150, new AspectList().add(Aspect.AIR, 3).add(Aspect.WATER, 3).add(Aspect.ORDER, 3).add(Aspect.EARTH, 3).add(Aspect.FIRE, 3).add(Aspect.ENTROPY, 3), new ItemStack((Item)ModItems.ichorium_shovel), new Object[]{"I", "S", "S", Character.valueOf('I'), new ItemStack((Item)ModItems.kamiresource, 1, 3), Character.valueOf('S'), new ItemStack(BlocksTC.logSilverwood)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichorium_axe"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHORIUMTOOLS", 150, new AspectList().add(Aspect.AIR, 3).add(Aspect.WATER, 3).add(Aspect.ORDER, 3).add(Aspect.EARTH, 3).add(Aspect.FIRE, 3).add(Aspect.ENTROPY, 3), new ItemStack((Item)ModItems.ichorium_axe), new Object[]{"II", "IS", " S", Character.valueOf('I'), new ItemStack((Item)ModItems.kamiresource, 1, 3), Character.valueOf('S'), new ItemStack(BlocksTC.logSilverwood)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichor_helm"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHORARMOR", 150, new AspectList().add(Aspect.AIR, 3).add(Aspect.WATER, 3).add(Aspect.ORDER, 3).add(Aspect.EARTH, 3).add(Aspect.FIRE, 3).add(Aspect.ENTROPY, 3), new ItemStack(ModItems.ichor_helm), new Object[]{"CCC", "C C", Character.valueOf('C'), new ItemStack((Item)ModItems.kamiresource, 1, 4)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichor_chest"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHORARMOR", 150, new AspectList().add(Aspect.AIR, 3).add(Aspect.WATER, 3).add(Aspect.ORDER, 3).add(Aspect.EARTH, 3).add(Aspect.FIRE, 3).add(Aspect.ENTROPY, 3), new ItemStack(ModItems.ichor_chest), new Object[]{"C C", "CCC", "CCC", Character.valueOf('C'), new ItemStack((Item)ModItems.kamiresource, 1, 4)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichor_legs"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHORARMOR", 150, new AspectList().add(Aspect.AIR, 3).add(Aspect.WATER, 3).add(Aspect.ORDER, 3).add(Aspect.EARTH, 3).add(Aspect.FIRE, 3).add(Aspect.ENTROPY, 3), new ItemStack(ModItems.ichor_legs), new Object[]{"CCC", "C C", "C C", Character.valueOf('C'), new ItemStack((Item)ModItems.kamiresource, 1, 4)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichor_boots"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_ICHORARMOR", 150, new AspectList().add(Aspect.AIR, 3).add(Aspect.WATER, 3).add(Aspect.ORDER, 3).add(Aspect.EARTH, 3).add(Aspect.FIRE, 3).add(Aspect.ENTROPY, 3), new ItemStack(ModItems.ichor_boots), new Object[]{"C C", "C C", Character.valueOf('C'), new ItemStack((Item)ModItems.kamiresource, 1, 4)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "sky_pearl_dupe"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_WARP_SERIES", 300, new AspectList().add(Aspect.AIR, 10).add(Aspect.WATER, 10).add(Aspect.ORDER, 10).add(Aspect.EARTH, 10).add(Aspect.FIRE, 10).add(Aspect.ENTROPY, 10), new ItemStack(ModItems.sky_pearl, 2), new Object[]{"DCD", "DED", "DDD", Character.valueOf('C'), new ItemStack(ModItems.sky_pearl), Character.valueOf('D'), "gemDiamond", Character.valueOf('E'), new ItemStack(Items.field_151079_bi)}));
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "summoner"), (IArcaneRecipe)new ShapedArcaneRecipe(defaultGroup, "TT_SUMMONING", 150, new AspectList().add(Aspect.AIR, 1).add(Aspect.WATER, 1).add(Aspect.ORDER, 1).add(Aspect.EARTH, 1).add(Aspect.FIRE, 1).add(Aspect.ENTROPY, 1), new ItemStack((Block)ModBlocks.summoner), new Object[]{"AAA", "OOO", Character.valueOf('A'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z)}));
    }

    private static void initializeInfusionRecipes() {
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)LibRecipes.CLEANSER, (InfusionRecipe)new InfusionRecipe("TT_CLEANING_TALISMAN", (Object)new ItemStack((Item)Objects.requireNonNull(ModItems.cleaning_talisman)), 1, new AspectList().add(Aspect.MAN, 20).add(Aspect.TOOL, 20).add(Aspect.LIFE, 20), (Object)new ItemStack(Items.field_151079_bi), new Object[]{Items.field_151073_bk, "quartzDark", "quartzDark", "quartzDark", "quartzDark", "nitor"}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)LibRecipes.ENCHANTER, (InfusionRecipe)new InfusionRecipe("TT_ENCHANTER", (Object)new ItemStack((Block)Objects.requireNonNull(ModBlocks.osmotic_enchanter)), 10, new AspectList().add(Aspect.ELDRITCH, 60).add(Aspect.MIND, 30).add(Aspect.ENERGY, 60).add(Aspect.MAGIC, 225).add(Aspect.VOID, 45), (Object)new ItemStack(Blocks.field_150381_bn), new Object[]{new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150343_Z), new ItemStack((Item)Objects.requireNonNull(ModItems.spellbinding_cloth)), new ItemStack(ItemsTC.ingots, 1, 0), new ItemStack(ItemsTC.ingots, 1, 0)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)LibRecipes.REPAIRER, (InfusionRecipe)new InfusionRecipe("TT_REPAIRER", (Object)new ItemStack((Block)Objects.requireNonNull(ModBlocks.repairer)), 4, new AspectList().add(Aspect.CRAFT, 60).add(Aspect.TOOL, 45).add(Aspect.ORDER, 30).add(Aspect.MAGIC, 30), (Object)new ItemStack(BlocksTC.metalBlockThaumium), new Object[]{"plankWood", new ItemStack(Items.field_151116_aA), new ItemStack(ItemsTC.fabric), new ItemStack(ItemsTC.ingots, 1, 0), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150347_e)}));
        for (Aspect asp : Aspect.getPrimalAspects()) {
            ModRecipes.InfusedSeedsRecipes(asp);
        }
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "experience_charm"), (InfusionRecipe)new InfusionRecipe("TT_EXPERIENCE_CHARM", (Object)new ItemStack((Item)ModItems.experience_charm), 6, new AspectList().add(Aspect.DESIRE, 65).add(Aspect.EXCHANGE, 30).add(Aspect.BEAST, 30).add(Aspect.MECHANISM, 10), (Object)new ItemStack(Items.field_151043_k), new Object[]{new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151128_bU), new ItemStack(ItemsTC.brain), new ItemStack(Items.field_151045_i)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichor_block"), (InfusionRecipe)new InfusionRecipe("TT_ICHOR@1", (Object)new ItemStack((Block)Objects.requireNonNull(ModBlocks.ichor_block)), 8, new AspectList().add(Aspect.LIGHT, 125).add(Aspect.MAN, 125).add(Aspect.SOUL, 250), (Object)new ItemStack(Items.field_151156_bN), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 1), new ItemStack(Items.field_151045_i), new ItemStack((Item)ModItems.kamiresource, 1, 0), new ItemStack(Items.field_151061_bv)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "kami_helm"), (InfusionRecipe)new InfusionRecipe("TT_KAMIHELM", (Object)new ItemStack(ModItems.kami_helm), 32, new AspectList().add(Aspect.WATER, 150).add(Aspect.AURA, 125).add(Aspect.MIND, 60).add(Aspect.LIFE, 60).add(Aspect.LIGHT, 250).add(Aspect.PROTECT, 125), (Object)new ItemStack(ModItems.ichor_helm), new Object[]{new ItemStack(Items.field_151045_i), new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack(ItemsTC.thaumonomicon), new ItemStack(Items.field_185162_cT), new ItemStack((Item)Items.field_151169_ag), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185234_f), new ItemStack(ItemsTC.goggles), new ItemStack(Items.field_151073_bk), new ItemStack(Items.field_151115_aP), new ItemStack(Items.field_151105_aU), new ItemStack(Items.field_151061_bv)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "kami_chest"), (InfusionRecipe)new InfusionRecipe("TT_KAMICHEST", (Object)new ItemStack(ModItems.kami_chest), 32, new AspectList().add(Aspect.AIR, 150).add(Aspect.PROTECT, 125).add(Aspect.FLIGHT, 125).add(Aspect.ORDER, 125).add(Aspect.LIGHT, 250).add(Aspect.ELDRITCH, 60), (Object)new ItemStack(ModItems.ichor_chest), new Object[]{new ItemStack(Items.field_151045_i), new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack(ItemsTC.thaumonomicon), new ItemStack(Items.field_185162_cT), new ItemStack((Item)Items.field_151171_ah), new ItemStack(ItemsTC.ringCloud), new ItemStack(Items.field_185160_cR), new ItemStack(Items.field_185159_cQ), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151073_bk), new ItemStack(Items.field_151032_g)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "kami_legs"), (InfusionRecipe)new InfusionRecipe("TT_KAMILEGS", (Object)new ItemStack(ModItems.kami_legs), 32, new AspectList().add(Aspect.AIR, 150).add(Aspect.PROTECT, 125).add(Aspect.FLIGHT, 125).add(Aspect.ORDER, 125).add(Aspect.LIGHT, 250).add(Aspect.ELDRITCH, 60), (Object)new ItemStack(ModItems.ichor_legs), new Object[]{new ItemStack(Items.field_151045_i), new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack(ItemsTC.thaumonomicon), new ItemStack(Items.field_185162_cT), new ItemStack((Item)Items.field_151149_ai), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185241_m), new ItemStack((Item)Objects.requireNonNull(ModItems.energetic_nitor)), new ItemStack(BlocksTC.lampArcane), new ItemStack(Items.field_151129_at), new ItemStack(Items.field_151059_bz), new ItemStack(Items.field_151072_bj)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "kami_boots"), (InfusionRecipe)new InfusionRecipe("TT_KAMIBOOTS", (Object)new ItemStack(ModItems.kami_boots), 32, new AspectList().add(Aspect.EARTH, 150).add(Aspect.PROTECT, 125).add(Aspect.TOOL, 125).add(Aspect.MOTION, 125).add(Aspect.LIGHT, 250).add(Aspect.PLANT, 60).add(Aspect.FLIGHT, 60), (Object)new ItemStack(ModItems.ichor_boots), new Object[]{new ItemStack(Items.field_151045_i), new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack(ItemsTC.thaumonomicon), new ItemStack(Items.field_185162_cT), new ItemStack((Item)Items.field_151151_aj), new ItemStack((Block)Blocks.field_150349_c), new ItemStack(Items.field_151014_N), new ItemStack(BlocksTC.lampGrowth), new ItemStack(ItemsTC.turretPlacer, 1, 2), new ItemStack(Blocks.field_150325_L), new ItemStack(Items.field_151058_ca)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichorium_pick_adv"), (InfusionRecipe)new InfusionRecipe("TT_ICHOR_PICK_ADV", (Object)new ItemStack((Item)ModItems.ichorium_pick_adv), 40, new AspectList().add(Aspect.FIRE, 150).add(Aspect.DESIRE, 60).add(Aspect.METAL, 125).add(Aspect.TOOL, 250).add(Aspect.SENSES, 60).add(Aspect.EARTH, 125), (Object)new ItemStack((Item)ModItems.ichorium_pick), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 3), new ItemStack((Item)ModItems.kamiresource, 1, 2), ItemsTC.elementalPick, new ItemStack(ItemsTC.mechanismComplex), new ItemStack(Blocks.field_150335_W), new ItemStack(ItemsTC.clusters, 1, 6), new ItemStack(ItemsTC.clusters, 1, 0), new ItemStack(ItemsTC.clusters, 1, 1), new ItemStack(Items.field_151045_i), new ItemStack(ItemsTC.mechanismComplex), ItemsTC.elementalPick, new ItemStack((Item)ModItems.kamiresource, 1, 4)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichorium_shovel_adv"), (InfusionRecipe)new InfusionRecipe("TT_ICHOR_SHOVEL_ADV", (Object)new ItemStack((Item)ModItems.ichorium_shovel_adv), 40, new AspectList().add(Aspect.TOOL, 250).add(Aspect.SENSES, 60).add(Aspect.EARTH, 125).add(Aspect.TRAP, 60), (Object)new ItemStack((Item)ModItems.ichorium_shovel), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 3), new ItemStack((Item)ModItems.kamiresource, 1, 2), ItemsTC.elementalShovel, new ItemStack(ItemsTC.mechanismComplex), new ItemStack(Blocks.field_150335_W), new ItemStack(ItemsTC.clusters, 1, 6), new ItemStack(ItemsTC.clusters, 1, 0), new ItemStack(ItemsTC.clusters, 1, 1), new ItemStack(Items.field_151045_i), new ItemStack(ItemsTC.mechanismComplex), ItemsTC.elementalShovel, new ItemStack((Item)ModItems.kamiresource, 1, 4)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichorium_axe_adv"), (InfusionRecipe)new InfusionRecipe("TT_ICHOR_AXE_ADV", (Object)new ItemStack((Item)ModItems.ichorium_axe_adv), 40, new AspectList().add(Aspect.WATER, 150).add(Aspect.PLANT, 125).add(Aspect.TOOL, 250).add(Aspect.SENSES, 60), (Object)new ItemStack((Item)ModItems.ichorium_axe), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 3), new ItemStack((Item)ModItems.kamiresource, 1, 2), ItemsTC.elementalAxe, new ItemStack(ItemsTC.mechanismComplex), new ItemStack(Blocks.field_150335_W), new ItemStack(ItemsTC.clusters, 1, 6), new ItemStack(ItemsTC.clusters, 1, 0), new ItemStack(ItemsTC.clusters, 1, 1), new ItemStack(Items.field_151045_i), new ItemStack(ItemsTC.mechanismComplex), ItemsTC.elementalAxe, new ItemStack((Item)ModItems.kamiresource, 1, 4)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichorium_sword_adv"), (InfusionRecipe)new InfusionRecipe("TT_ICHOR_SWORD_ADV", (Object)new ItemStack((Item)ModItems.ichorium_sword_adv), 40, new AspectList().add(Aspect.AIR, 150).add(Aspect.DESIRE, 250).add(Aspect.ORDER, 60).add(Aspect.ENERGY, 125).add(Aspect.CRYSTAL, 60).add(Aspect.SOUL, 125).add(Aspect.AVERSION, 125), (Object)new ItemStack((Item)ModItems.ichorium_sword), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 3), new ItemStack((Item)ModItems.kamiresource, 1, 2), ItemsTC.elementalSword, new ItemStack(ItemsTC.mechanismComplex), new ItemStack((Block)Blocks.field_150434_aF), new ItemStack(ItemsTC.clusters, 1, 6), new ItemStack(ItemsTC.clusters, 1, 0), new ItemStack(ItemsTC.clusters, 1, 1), new ItemStack(Items.field_151045_i), new ItemStack(ItemsTC.mechanismComplex), ItemsTC.elementalSword, new ItemStack((Item)ModItems.kamiresource, 1, 4)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "block_talisman"), (InfusionRecipe)new InfusionRecipe("TT_BLACKHOLE_RING", (Object)new ItemStack(ModItems.block_talisman), 9, new AspectList().add(Aspect.ELDRITCH, 125).add(Aspect.MAGIC, 200).add(Aspect.DARKNESS, 125).add(Aspect.VOID, 250), (Object)new ItemStack(ItemsTC.focus2), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack(Blocks.field_150477_bB), new ItemStack(Items.field_151045_i), new ItemStack((Item)ModItems.kamiresource, 1, 2), ThaumcraftApiHelper.makeCrystal((Aspect)Aspect.FLUX), new ItemStack(BlocksTC.jarVoid)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "proto_clay"), (InfusionRecipe)new InfusionRecipe("TT_PROTO_CLAY", (Object)new ItemStack((Item)ModItems.proto_clay), 4, new AspectList().add(Aspect.TOOL, 30).add(Aspect.MAN, 30), (Object)new ItemStack(Items.field_151119_aD), new Object[]{new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150364_r), new ItemStack(Blocks.field_150348_b), new ItemStack((Item)ModItems.kamiresource, 1, 0)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "ichor_pouch"), (InfusionRecipe)new InfusionRecipe("TT_ICHOR_POUCH", (Object)new ItemStack(ModItems.focus_pouch), 7, new AspectList().add(Aspect.AIR, 250).add(Aspect.ELDRITCH, 125).add(Aspect.MAN, 125).add(Aspect.CRAFT, 125).add(Aspect.VOID, 250), (Object)new ItemStack(ItemsTC.focusPouch), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 4), new ItemStack(BlocksTC.hungryChest), "gemDiamond", new ItemStack((Item)ModItems.kamiresource, 1, 4), new ItemStack(ItemsTC.focus2), new ItemStack(BlocksTC.jarVoid)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "cat_amulet"), (InfusionRecipe)new InfusionRecipe("TT_CAT_AMULET", (Object)new ItemStack(ModItems.cat_amulet), 8, new AspectList().add(Aspect.DARKNESS, 75).add(Aspect.ORDER, 125).add(Aspect.MIND, 75), (Object)new ItemStack(Blocks.field_150371_ca), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151100_aR, 1, 3), new ItemStack((Block)Blocks.field_150362_t, 1, 3), new ItemStack(Items.field_151115_aP)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "placement_mirror"), (InfusionRecipe)new InfusionRecipe("TT_PLACEMENT_MIRROR", (Object)new ItemStack(ModItems.placement_mirror), 12, new AspectList().add(Aspect.CRAFT, 65).add(Aspect.CRYSTAL, 32).add(Aspect.MAGIC, 50).add(Aspect.MIND, 32), (Object)new ItemStack(ModItems.block_talisman), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack(Blocks.field_150409_cd), new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150359_w), new ItemStack(Items.field_151065_br), new ItemStack((Item)ModItems.kamiresource, 1, 2)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "sky_pearl"), (InfusionRecipe)new InfusionRecipe("TT_WARP_SERIES@0", (Object)new ItemStack(ModItems.sky_pearl), 6, new AspectList().add(Aspect.MOTION, 125).add(Aspect.ELDRITCH, 125).add(Aspect.FLIGHT, 125).add(Aspect.AIR, 65), (Object)new ItemStack(Items.field_151079_bi), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack((Item)ModItems.kamiresource, 1, 0), new ItemStack(Blocks.field_150368_y), new ItemStack(Items.field_151045_i)}));
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "warp_gate"), (InfusionRecipe)new InfusionRecipe("TT_WARP_SERIES", (Object)new ItemStack((Block)ModBlocks.warp_gate), 8, new AspectList().add(Aspect.MOTION, 250).add(Aspect.ELDRITCH, 50).add(Aspect.FLIGHT, 50), (Object)new ItemStack(BlocksTC.pavingStoneTravel), new Object[]{new ItemStack((Item)ModItems.kamiresource, 1, 2), new ItemStack((Item)ModItems.kamiresource, 1, 1), new ItemStack((Block)ModBlocks.transvector_dislocator), new ItemStack((Item)ModItems.kamiresource), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151008_G)}));
        for (Aspect aspect : Aspect.aspects.values()) {
            ItemStack output = new ItemStack((Item)ModItems.condensed_mob_aspect);
            ItemMobAspect.setAspectType(output, aspect);
            ItemStack input = new ItemStack((Item)ModItems.mob_aspect);
            ItemMobAspect.setAspectType(input, aspect);
            ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation(LibRecipes.CONDENSED_MOB_SOUL.func_110624_b(), LibRecipes.CONDENSED_MOB_SOUL.func_110623_a() + aspect.getTag()), (InfusionRecipe)new InfusionRecipe("TT_SUMMONING", (Object)output, 2, new AspectList().add(aspect, 30), (Object)input, new Object[]{input, input, input, input, input, input, input, input}));
        }
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)LibRecipes.BLOOD_SWORD, (InfusionRecipe)new InfusionRecipe("TT_SUMMONING", (Object)new ItemStack((Item)ModItems.blood_sword), 3, new AspectList().add(Aspect.DARKNESS, 5).add(Aspect.SOUL, 10).add(Aspect.MAN, 6).add(Aspect.DEATH, 10), (Object)new ItemStack(ItemsTC.thaumiumSword), new Object[]{new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151147_al), new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151045_i), new ItemStack(Items.field_151073_bk)}));
    }

    public static void InfusedSeedsRecipes(Aspect asp) {
        System.out.print(asp.getName());
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumictinkerer", "infused_seeds_" + asp.getName()), (InfusionRecipe)new InfusionRecipe("TT_INFUSED_CROPS", (Object)ItemInfusedSeeds.getStackFromAspect(asp), 5, new AspectList().add(asp, 100).add(Aspect.EXCHANGE, 100).add(Aspect.PLANT, 100), (Object)Items.field_151014_N, new Object[]{ThaumcraftApiHelper.makeCrystal((Aspect)asp), ThaumcraftApiHelper.makeCrystal((Aspect)asp), ThaumcraftApiHelper.makeCrystal((Aspect)asp), ThaumcraftApiHelper.makeCrystal((Aspect)asp)}));
    }
}

