/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.nekokittygames.thaumictinkerer.ThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.api.MobAspect;
import com.nekokittygames.thaumictinkerer.api.MobAspects;
import com.nekokittygames.thaumictinkerer.common.items.ItemMobAspect;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityThaumicTinkerer;
import com.nekokittygames.thaumictinkerer.common.utils.CombinationGenerator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.tiles.crafting.TilePedestal;

public class TileEntitySummon
extends TileEntityThaumicTinkerer
implements ITickable {
    @Override
    public boolean respondsToPulses() {
        return false;
    }

    private boolean pedestalAvailable(TileEntity tile) {
        return tile instanceof TilePedestal && ((TilePedestal)tile).func_70301_a(0) != null && ((TilePedestal)tile).func_70301_a(0).func_77973_b() instanceof ItemMobAspect && ItemMobAspect.getAspectType(((TilePedestal)tile).func_70301_a(0)) != null && ItemMobAspect.isReadyForSummon(((TilePedestal)tile).func_70301_a(0), this.field_145850_b.func_82737_E());
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_82737_E() % 100L != 0L || this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        ArrayList<TilePedestal> pedestals = new ArrayList<TilePedestal>();
        HashMap<String, Short> aspectUsageMap = new HashMap<String, Short>();
        int[] dx = new int[]{1, 0, -1, 0};
        int[] dz = new int[]{0, 1, 0, -1};
        for (int radius = 1; radius < 6; ++radius) {
            int z;
            int x = this.field_174879_c.func_177958_n() - radius + 1;
            int endX = x - 1;
            int endZ = z - 1;
            int direction = 0;
            for (z = this.field_174879_c.func_177952_p() - radius; x != endX || z != endZ; x += dx[direction], z += dz[direction]) {
                TileEntity tile = this.field_145850_b.func_175625_s(new BlockPos(x, this.field_174879_c.func_177956_o(), z));
                if (this.pedestalAvailable(tile)) {
                    String aspectName = ((TilePedestal)tile).func_70301_a(0).func_77978_p().func_74779_i(ItemMobAspect.ASPECT_NAME);
                    aspectUsageMap.put(aspectName, (short)(aspectUsageMap.getOrDefault(aspectName, (short)0) + 1));
                    if ((Short)aspectUsageMap.get(aspectName) <= 3) {
                        pedestals.add((TilePedestal)tile);
                    }
                }
                if (x != this.field_174879_c.func_177958_n() + radius && direction == 0 || z != this.field_174879_c.func_177952_p() + radius && direction == 1 || x != this.field_174879_c.func_177958_n() - radius && direction == 2 || direction == 3) continue;
                direction = (direction + 1) % 4;
            }
        }
        int maxCombinationSearchCount = CombinationGenerator.combination(pedestals.size(), 3);
        for (int i = 0; i < maxCombinationSearchCount; ++i) {
            boolean isInfused;
            ArrayList<Short> indices = CombinationGenerator.getIncreasingCombinations(i, (short)3);
            AspectList aspects = new AspectList();
            TilePedestal ped1 = (TilePedestal)pedestals.get(indices.get(0).shortValue());
            TilePedestal ped2 = (TilePedestal)pedestals.get(indices.get(1).shortValue());
            TilePedestal ped3 = (TilePedestal)pedestals.get(indices.get(2).shortValue());
            aspects.add(ItemMobAspect.getAspectType(ped1.func_70301_a(0)), 1);
            aspects.add(ItemMobAspect.getAspectType(ped2.func_70301_a(0)), 1);
            aspects.add(ItemMobAspect.getAspectType(ped3.func_70301_a(0)), 1);
            MobAspect aspect = MobAspects.getByAspects(aspects);
            if (aspect == null) continue;
            boolean bl = isInfused = ItemMobAspect.isInfused(ped1.func_70301_a(0)) && ItemMobAspect.isInfused(ped2.func_70301_a(0)) && ItemMobAspect.isInfused(ped3.func_70301_a(0));
            if (isInfused && this.field_145850_b.func_82737_E() % 400L != 0L) continue;
            if (!isInfused) {
                ped1.func_70299_a(0, ItemStack.field_190927_a);
                ped2.func_70299_a(0, ItemStack.field_190927_a);
                ped3.func_70299_a(0, ItemStack.field_190927_a);
            } else {
                ItemMobAspect.markNextSummon(ped1.func_70301_a(0), this.field_145850_b.func_82737_E() + 400L);
                ItemMobAspect.markNextSummon(ped2.func_70301_a(0), this.field_145850_b.func_82737_E() + 400L);
                ItemMobAspect.markNextSummon(ped3.func_70301_a(0), this.field_145850_b.func_82737_E() + 400L);
            }
            if (!this.field_145850_b.field_72995_K) {
                ResourceLocation entityToSpawn = aspect.getEntityName();
                ThaumicTinkerer.logger.info("Spawning a " + entityToSpawn.toString());
                this.spawnMob(entityToSpawn);
            }
            if (!this.field_145850_b.field_72995_K) break;
            break;
        }
    }

    private void spawnMob(ResourceLocation entityToSpawn) {
        Entity spawn = EntityList.func_188429_b((ResourceLocation)entityToSpawn, (World)this.field_145850_b);
        if (spawn != null) {
            spawn.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 0.0f, 0.0f);
            this.field_145850_b.func_72838_d(spawn);
            ((EntityLiving)spawn).func_180482_a(this.field_145850_b.func_175649_E(this.field_174879_c), null);
            ((EntityLiving)spawn).func_70642_aH();
        }
    }

    private void ShowSparks(TilePedestal pedastal) {
        ItemStack stack = pedastal.func_70301_a(0);
        Aspect aspect = ItemMobAspect.getAspectType(stack);
        if (aspect != null) {
            Color color = new Color(aspect.getColor());
            if (this.field_145850_b.field_72995_K) {
                FXDispatcher.INSTANCE.arcLightning((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (double)((float)pedastal.func_174877_v().func_177958_n() + 0.5f), (double)(pedastal.func_174877_v().func_177956_o() + 1), (double)((float)pedastal.func_174877_v().func_177952_p() + 0.5f), (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.1f);
            }
        }
    }
}

