/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.utils;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public final class ToolModeHUDHandler {
    private static String currentTooltip;
    private static int tooltipDisplayTicks;

    public static void setTooltip(String tooltip) {
        if (!tooltip.equals(currentTooltip)) {
            currentTooltip = tooltip;
            tooltipDisplayTicks = 400;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void clientTick() {
        if (tooltipDisplayTicks > 0) {
            --tooltipDisplayTicks;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawDislocationFocusHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && tooltipDisplayTicks > 0 && currentTooltip.length() != 0) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution var5 = new ScaledResolution(mc);
            int var6 = var5.func_78326_a();
            int var7 = var5.func_78328_b();
            FontRenderer var8 = mc.field_71466_p;
            int tooltipStartX = (var6 - var8.func_78256_a(currentTooltip)) / 2;
            int tooltipStartY = var7 - 72;
            int opacity = (int)((float)tooltipDisplayTicks * 256.0f / 10.0f);
            if (opacity > 160) {
                opacity = 160;
            }
            if (opacity > 0) {
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                int color = Color.getHSBColor((float)Math.cos(0.08), 0.6f, 1.0f).getRGB();
                var8.func_175063_a(currentTooltip, (float)tooltipStartX, (float)tooltipStartY, color + (opacity << 24));
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
        }
    }
}

