/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jei;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.init.InitIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag.LootBagCategory;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag.LootBagEntry;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag.LootBagWrapper;
import com.invadermonky.justenoughmagiculture.integrations.jei.mods.JEIErebusPlugin;
import com.invadermonky.justenoughmagiculture.integrations.jer.mods.JERAtum;
import com.invadermonky.justenoughmagiculture.registry.LootBagRegistry;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;

@JEIPlugin
public class JEICategories
implements IModPlugin {
    public static final String LOOT_BAG = "justenoughmagiculture.loot_bag";
    private static IJeiHelpers jeiHelpers;
    private static IJeiRuntime jeiRuntime;

    public void register(IModRegistry registry) {
        InitIntegration.jeiInit();
        if (JEMConfig.MODULE_JEI.enableLootBagCategory) {
            registry.handleRecipes(LootBagEntry.class, LootBagWrapper::new, LOOT_BAG);
            registry.addRecipes(LootBagRegistry.getInstance().getAllLootBags(), LOOT_BAG);
        }
        if (ModIds.EREBUS.isLoaded) {
            JEIErebusPlugin.getInstance().register(registry);
        }
        this.registerInfoPages(registry);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEICategories.jeiRuntime = jeiRuntime;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new LootBagCategory()});
        if (ModIds.EREBUS.isLoaded) {
            JEIErebusPlugin.getInstance().registerCategories(registry);
        }
    }

    public static IJeiHelpers getJeiHelpers() {
        return jeiHelpers;
    }

    private void registerInfoPages(IModRegistry registry) {
        if (ModIds.ATUM.isLoaded && JEMConfig.ATUM.enableJEIInfoPages) {
            JERAtum.getInstance().registerJEIInfoPages(registry);
        }
    }
}

