/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jei.categories.erebus.composter;

import com.invadermonky.justenoughmagiculture.integrations.jei.JEICategories;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.erebus.composter.ComposterWrapper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class ComposterCategory
implements IRecipeCategory<ComposterWrapper> {
    private final IDrawable BACKGROUND;
    private final IDrawableAnimated FUEL;
    private final IDrawableAnimated COMPOST;

    public ComposterCategory() {
        ResourceLocation location = new ResourceLocation(ModIds.EREBUS.MOD_ID, "textures/gui/container/composter.png");
        this.BACKGROUND = JEICategories.getJeiHelpers().getGuiHelper().createDrawable(location, 55, 16, 85, 54);
        this.FUEL = JEICategories.getJeiHelpers().getGuiHelper().drawableBuilder(location, 176, 0, 16, 14).buildAnimated(400, IDrawableAnimated.StartDirection.TOP, true);
        this.COMPOST = JEICategories.getJeiHelpers().getGuiHelper().drawableBuilder(location, 176, 14, 30, 30).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return "justenoughmagiculture.erebus.composter";
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.justenoughmagiculture:erebus_composter.title", (Object[])new Object[0]);
    }

    @Nonnull
    public String getModName() {
        return ModIds.EREBUS.MOD_NAME;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public void drawExtras(Minecraft minecraft) {
        this.FUEL.draw(minecraft, 1, 20);
        this.COMPOST.draw(minecraft, 21, 12);
    }

    public void setRecipe(IRecipeLayout recipeLayout, @Nonnull ComposterWrapper composterWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(1, true, 0, 36);
        guiItemStacks.init(2, false, 60, 18);
        guiItemStacks.set(ingredients);
    }
}

