/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.init.InitIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.plant.CustomPlantWrapper;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.CustomVillagerWrapper;
import com.invadermonky.justenoughmagiculture.registry.CustomPlantRegistry;
import com.invadermonky.justenoughmagiculture.registry.CustomVillagerRegistry;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jeresources.entry.PlantEntry;
import jeresources.entry.VillagerEntry;
import jeresources.jei.plant.PlantWrapper;
import jeresources.jei.villager.VillagerWrapper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.collect.SetMultiMap;

public class CustomJEIConfig {
    public static void injectRegister(IModRegistry registry) {
        LogHelper.info("Registering Custom JER entries.");
        if (CustomJEIConfig.registerCustomPlants(registry)) {
            registry.addRecipes(CustomPlantRegistry.getInstance().getAllPlants(), "jeresources.plant");
        } else {
            LogHelper.warn("failed to register custom plants.");
        }
        if (CustomJEIConfig.registerCustomVillagers(registry)) {
            CustomJEIConfig.removeBuggedVillagers(registry);
            registry.addRecipes(CustomVillagerRegistry.getInstance().getVillagers(), "jeresources.villager");
        } else {
            LogHelper.warn("Failed to register custom villagers.");
        }
        InitIntegration.lateInit();
    }

    public static boolean registerCustomPlants(IModRegistry registry) {
        try {
            Field recipeHandlerClassesField = registry.getClass().getDeclaredField("recipeHandlerClasses");
            Field recipeHandlersField = registry.getClass().getDeclaredField("recipeHandlers");
            recipeHandlerClassesField.setAccessible(true);
            recipeHandlersField.setAccessible(true);
            SetMultiMap recipeHandlerClasses = (SetMultiMap)recipeHandlerClassesField.get(registry);
            ListMultiMap recipeHandlers = (ListMultiMap)recipeHandlersField.get(registry);
            if (!recipeHandlerClasses.contains((Object)"jeresources.plant", PlantEntry.class)) {
                throw new NoSuchFieldException();
            }
            IRecipeHandler<PlantEntry> recipeHandler = new IRecipeHandler<PlantEntry>(){

                public Class<PlantEntry> getRecipeClass() {
                    return PlantEntry.class;
                }

                public String getRecipeCategoryUid(PlantEntry plantEntry) {
                    return "jeresources.plant";
                }

                public IRecipeWrapper getRecipeWrapper(PlantEntry plantEntry) {
                    return new CustomPlantWrapper(plantEntry);
                }

                public boolean isRecipeValid(PlantEntry plantEntry) {
                    return true;
                }
            };
            List plantHandlers = (List)recipeHandlers.get((Object)"jeresources.plant");
            if (plantHandlers.size() > 0) {
                plantHandlers.removeIf(handler -> handler.getRecipeWrapper(null) instanceof PlantWrapper);
            }
            plantHandlers.add(recipeHandler);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LogHelper.error("Could not access ModRegistry, custom plants will not work properly.");
            return false;
        }
    }

    public static boolean registerCustomVillagers(IModRegistry registry) {
        try {
            Field recipeHandlerClassesField = registry.getClass().getDeclaredField("recipeHandlerClasses");
            Field recipeHandlersField = registry.getClass().getDeclaredField("recipeHandlers");
            recipeHandlerClassesField.setAccessible(true);
            recipeHandlersField.setAccessible(true);
            SetMultiMap recipeHandlerClasses = (SetMultiMap)recipeHandlerClassesField.get(registry);
            ListMultiMap recipeHandlers = (ListMultiMap)recipeHandlersField.get(registry);
            if (!recipeHandlerClasses.contains((Object)"jeresources.villager", VillagerEntry.class)) {
                throw new NoSuchFieldException();
            }
            IRecipeHandler<VillagerEntry> recipeHandler = new IRecipeHandler<VillagerEntry>(){

                public Class<VillagerEntry> getRecipeClass() {
                    return VillagerEntry.class;
                }

                public String getRecipeCategoryUid(VillagerEntry entry) {
                    return "jeresources.villager";
                }

                public IRecipeWrapper getRecipeWrapper(VillagerEntry entry) {
                    return new CustomVillagerWrapper(entry);
                }

                public boolean isRecipeValid(VillagerEntry entry) {
                    return true;
                }
            };
            List villagerHandlers = (List)recipeHandlers.get((Object)"jeresources.villager");
            if (villagerHandlers.size() > 0) {
                villagerHandlers.removeIf(handler -> handler.getRecipeWrapper(null) instanceof VillagerWrapper);
            }
            villagerHandlers.add(recipeHandler);
            return true;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LogHelper.error("Could not access ModRegistry, custom villager trades will not work properly.");
            return false;
        }
    }

    public static void removeBuggedVillagers(IModRegistry registry) {
        try {
            Field recipesField = registry.getClass().getDeclaredField("recipes");
            recipesField.setAccessible(true);
            ListMultiMap recipes = (ListMultiMap)recipesField.get(registry);
            if (recipes.containsKey((Object)"jeresources.villager")) {
                Collection villagerEntriesObj = recipes.get((Object)"jeresources.villager");
                ArrayList villagerEntries = (ArrayList)villagerEntriesObj;
                ArrayList<String> removeVillagers = new ArrayList<String>();
                ArrayList<VillagerEntry> toRemove = new ArrayList<VillagerEntry>();
                if (ModIds.RATS.isLoaded && JEMConfig.RATS.fixJERVillagers) {
                    removeVillagers.addAll(Arrays.asList("pet_shop_owner", "plague_doctor"));
                }
                for (VillagerEntry entry : villagerEntries) {
                    if (!removeVillagers.contains(entry.getName())) continue;
                    toRemove.add(entry);
                }
                villagerEntries.removeAll(toRemove);
            }
        }
        catch (Exception e) {
            LogHelper.warn("Failed to remove erroring villager trades. Some villagers may not display correctly.");
            e.printStackTrace();
        }
    }
}

