/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import jeresources.api.drop.LootDrop;
import jeresources.util.LootTableHelper;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraftforge.items.ItemHandlerHelper;

public class LootBagEntry {
    private final ItemStack lootBag;
    private final List<LootDrop> drops = new ArrayList<LootDrop>();
    private final int minStacks;
    private final int maxStacks;

    public LootBagEntry(ItemStack lootBag, LootTable lootTable) {
        this.lootBag = lootBag;
        float[] minStacks = new float[]{0.0f};
        float[] maxStacks = new float[]{0.0f};
        LootTableManager manager = LootTableHelper.getManager();
        this.handleTable(lootTable, manager, minStacks, maxStacks);
        this.minStacks = MathHelper.func_76141_d((float)minStacks[0]);
        this.maxStacks = MathHelper.func_76141_d((float)maxStacks[0]);
    }

    private void handleTable(LootTable lootTable, LootTableManager manager, float[] tmpMinStacks, float[] tmpMaxStacks) {
        List pools = LootTableHelper.getPools((LootTable)lootTable);
        for (LootPool pool : pools) {
            tmpMinStacks[0] = tmpMinStacks[0] + pool.getRolls().func_186509_a();
            tmpMaxStacks[0] = tmpMaxStacks[0] + (pool.getRolls().func_186512_b() + pool.getBonusRolls().func_186512_b());
            float totalWeight = LootTableHelper.getEntries((LootPool)pool).stream().mapToInt(entry -> entry.func_186361_a(0.0f)).sum();
            List entries = LootTableHelper.getEntries((LootPool)pool);
            for (LootEntry entry2 : entries) {
                if (entry2 instanceof LootEntryItem) {
                    LootEntryItem entryItem = (LootEntryItem)entry2;
                    this.drops.add(new LootDrop(LootTableHelper.getItem((LootEntryItem)entryItem), (float)entryItem.func_186361_a(0.0f) / totalWeight, LootTableHelper.getFunctions((LootEntryItem)entryItem)));
                    continue;
                }
                if (!(entry2 instanceof LootEntryTable)) continue;
                LootEntryTable entryTable = (LootEntryTable)entry2;
                LootTable table = manager.func_186521_a(entryTable.field_186371_a);
                this.handleTable(table, manager, tmpMinStacks, tmpMaxStacks);
            }
        }
    }

    public boolean containsItem(ItemStack itemStack) {
        return this.drops.stream().anyMatch(drop -> drop.item.func_77969_a(itemStack));
    }

    public ItemStack getLootBag() {
        return this.lootBag;
    }

    public List<ItemStack> getItemStacks(IFocus<ItemStack> focus) {
        return this.drops.stream().map(drop -> drop.item).filter(stack -> focus == null || ItemStack.func_77989_b((ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)((ItemStack)focus.getValue()).func_190916_E()), (ItemStack)((ItemStack)focus.getValue()))).collect(Collectors.toList());
    }

    public int getMaxStacks() {
        return this.maxStacks;
    }

    public int getMinStacks() {
        return this.minStacks;
    }

    public LootDrop getBagDrop(ItemStack ingredient) {
        return this.drops.stream().filter(drop -> ItemStack.func_179545_c((ItemStack)drop.item, (ItemStack)ingredient)).findFirst().orElse(null);
    }
}

