/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jei.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.erebus.composter.ComposterCategory;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.erebus.composter.ComposterWrapper;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.erebus.offeringtable.OfferingAltarCategory;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.erebus.offeringtable.OfferingAltarWrapper;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.erebus.smoothiemaker.SmoothieMakerCategory;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.erebus.smoothiemaker.SmoothieMakerWrapper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import erebus.ModBlocks;
import erebus.recipes.ComposterRegistry;
import erebus.recipes.OfferingAltarRecipe;
import erebus.recipes.SmoothieMakerRecipe;
import java.util.Collection;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class JEIErebusPlugin {
    private static JEIErebusPlugin instance;
    private final boolean canLoad;
    public static final String EREBUS_COMPOSTER = "justenoughmagiculture.erebus.composter";
    public static final String EREBUS_OFFERING_ALTAR = "justenoughmagiculture.erebus.offering_altar";
    public static final String EREBUS_SMOOTHIE_MAKER = "justenoughmagiculture.erebus.smoothie_maker";

    public JEIErebusPlugin() {
        this.canLoad = !ModIds.MORETWEAKER.isLoaded || JEMConfig.EREBUS.JUST_ENOUGH_ITEMS.forceLoadCategories;
    }

    public static JEIErebusPlugin getInstance() {
        return instance != null ? instance : (instance = new JEIErebusPlugin());
    }

    public void register(IModRegistry registry) {
        if (this.canLoad) {
            if (JEMConfig.EREBUS.JUST_ENOUGH_ITEMS.enableCompostCategory) {
                registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.COMPOSTER), new String[]{EREBUS_COMPOSTER});
                registry.handleRecipes(ItemStack.class, ComposterWrapper::new, EREBUS_COMPOSTER);
                NonNullList compost = NonNullList.func_191196_a();
                IForgeRegistry itemRegistry = GameRegistry.findRegistry(Item.class);
                for (Item item : itemRegistry.getValuesCollection()) {
                    CreativeTabs tab = item.func_77640_w();
                    if (tab == null) continue;
                    item.func_150895_a(tab, compost);
                }
                compost.removeIf(stack -> {
                    ItemStack compostable = ComposterRegistry.isCompostable((ItemStack)stack);
                    return compostable == null || stack.func_190926_b();
                });
                registry.addRecipes((Collection)compost, EREBUS_COMPOSTER);
            }
            if (JEMConfig.EREBUS.JUST_ENOUGH_ITEMS.enableOfferingAltarCategory) {
                registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.ALTAR_OFFERING), new String[]{EREBUS_OFFERING_ALTAR});
                registry.handleRecipes(OfferingAltarRecipe.class, OfferingAltarWrapper::new, EREBUS_OFFERING_ALTAR);
                registry.addRecipes((Collection)OfferingAltarRecipe.getRecipeList(), EREBUS_OFFERING_ALTAR);
            }
            if (JEMConfig.EREBUS.JUST_ENOUGH_ITEMS.enableSmoothieCategory) {
                registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.SMOOTHIE_MAKER), new String[]{EREBUS_SMOOTHIE_MAKER});
                registry.handleRecipes(SmoothieMakerRecipe.class, SmoothieMakerWrapper::new, EREBUS_SMOOTHIE_MAKER);
                registry.addRecipes((Collection)SmoothieMakerRecipe.getRecipeList(), EREBUS_SMOOTHIE_MAKER);
            }
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (this.canLoad) {
            registry.addRecipeCategories(new IRecipeCategory[]{new ComposterCategory(), new OfferingAltarCategory(), new SmoothieMakerCategory()});
        }
    }
}

