/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigAtum;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.plant.CustomPlantEntry;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.CustomVillagerEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.CustomVillagerRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import com.teammetallurgy.atum.blocks.vegetation.BlockAnputsFingers;
import com.teammetallurgy.atum.entity.animal.EntityCamel;
import com.teammetallurgy.atum.entity.animal.EntityDesertRabbit;
import com.teammetallurgy.atum.entity.animal.EntityDesertWolf;
import com.teammetallurgy.atum.entity.animal.EntityScarab;
import com.teammetallurgy.atum.entity.animal.EntityTarantula;
import com.teammetallurgy.atum.entity.bandit.EntityAssassin;
import com.teammetallurgy.atum.entity.bandit.EntityBarbarian;
import com.teammetallurgy.atum.entity.bandit.EntityBrigand;
import com.teammetallurgy.atum.entity.bandit.EntityNomad;
import com.teammetallurgy.atum.entity.efreet.EntitySunspeaker;
import com.teammetallurgy.atum.entity.stone.EntityStoneguard;
import com.teammetallurgy.atum.entity.stone.EntityStonewarden;
import com.teammetallurgy.atum.entity.undead.EntityBonestorm;
import com.teammetallurgy.atum.entity.undead.EntityForsaken;
import com.teammetallurgy.atum.entity.undead.EntityMummy;
import com.teammetallurgy.atum.entity.undead.EntityWraith;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.items.ItemLoot;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.IPlantable;

public class JERAtum
extends JERBase
implements IJERIntegration {
    private static JERAtum instance;
    JEMConfigAtum.JER jerConfig;

    private JERAtum() {
        this.jerConfig = JEMConfig.ATUM.JUST_ENOUGH_RESOURCES;
    }

    public JERAtum(boolean enableJERDungeons, boolean enableJERMobs, boolean enableJERPlants, boolean enableJERVillagers) {
        this.jerConfig = JEMConfig.ATUM.JUST_ENOUGH_RESOURCES;
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
        if (enableJERPlants) {
            this.registerModPlants();
        }
        if (enableJERVillagers) {
            this.registerModVillagers();
        }
    }

    public static JERAtum getInstance() {
        return instance != null ? instance : (instance = new JERAtum());
    }

    public void registerJEIInfoPages(IModRegistry registry) {
        ArrayList<ItemStack> dirtyItems = new ArrayList<ItemStack>();
        dirtyItems.add(new ItemStack(AtumItems.DIRTY_COIN));
        ArrayList<ItemStack> cleanedItems = new ArrayList<ItemStack>();
        for (ItemLoot.Quality quality : ItemLoot.Quality.values()) {
            for (ItemLoot.Type type : ItemLoot.Type.values()) {
                Item loot = Item.func_111206_d((String)String.format("%s:loot_%s_%s", ModIds.ATUM.MOD_ID, quality, type));
                if (loot == null) continue;
                if (quality.equals((Object)ItemLoot.Quality.DIRTY)) {
                    dirtyItems.add(new ItemStack(loot));
                    continue;
                }
                cleanedItems.add(new ItemStack(loot));
            }
        }
        registry.addIngredientInfo(dirtyItems, VanillaTypes.ITEM, new String[]{"jei.jem:atum_dirty_loot.info"});
        registry.addIngredientInfo((Object)new ItemStack(AtumItems.GOLD_COIN), VanillaTypes.ITEM, new String[]{"jei.jem:atum_gold_coin.info"});
        if (cleanedItems.size() > 0) {
            registry.addIngredientInfo(cleanedItems, VanillaTypes.ITEM, new String[]{"jei.jem:atum_clean_loot.info"});
        }
    }

    @Override
    public void registerModDungeons() {
        this.registerAtumDungeon("relic_ore", AtumLootTables.RELIC);
        this.registerAtumDungeon("crate", AtumLootTables.CRATE);
        this.registerAtumDungeon("crate_bonus", AtumLootTables.CRATE_BONUS);
        this.registerAtumDungeon("girafi_tomb", AtumLootTables.GIRAFI_TOMB);
        this.registerAtumDungeon("lighthouse", AtumLootTables.LIGHTHOUSE);
        this.registerAtumDungeon("pharaoh", AtumLootTables.PHARAOH);
        this.registerAtumDungeon("pyramid_chest", AtumLootTables.PYRAMID_CHEST);
        this.registerAtumDungeon("sarcophagus_artifact", AtumLootTables.SARCOPHAGUS_ARTIFACT);
        this.registerAtumDungeon("tomb", AtumLootTables.TOMB_CHEST);
    }

    @Override
    public void registerModEntities() {
        this.registerAnimals();
        this.registerBandits();
        this.registerStoneConstructs();
        this.registerUndead();
    }

    @Override
    public void registerModPlants() {
        Item saplingItem;
        if (this.jerConfig.JER_PLANTS.enableAnputsFingers) {
            try {
                Field agePropField = BlockAnputsFingers.class.getDeclaredField("ANPUTS_FINGERS_AGE");
                agePropField.setAccessible(true);
                PropertyInteger ageProp = (PropertyInteger)agePropField.get(BlockAnputsFingers.class);
                CustomPlantEntry plantEntry = new CustomPlantEntry(new ItemStack(AtumItems.ANPUTS_FINGERS_SPORES), (IPlantable)AtumItems.ANPUTS_FINGERS_SPORES, (IProperty<?>)ageProp, new PlantDrop(new ItemStack(AtumItems.ANPUTS_FINGERS_SPORES), 1, 3));
                plantEntry.setSoil(AtumBlocks.FERTILE_SOIL_TILLED.func_176223_P());
                this.registerCustomPlant(plantEntry);
            }
            catch (Exception e) {
                LogHelper.warn("Failed to register Anput's Fingers Spores plant entry.");
            }
        }
        if (this.jerConfig.JER_PLANTS.enableDate && (saplingItem = Item.func_111206_d((String)(ModIds.ATUM.MOD_ID + ":palm_sapling"))) != null) {
            CustomPlantEntry plantEntry = new CustomPlantEntry(new ItemStack(saplingItem), AtumBlocks.DATE_BLOCK.func_176223_P(), new PlantDrop(new ItemStack(AtumItems.DATE), 1, 5));
            plantEntry.setSoil(Blocks.field_150350_a.func_176223_P());
            this.registerCustomPlant(plantEntry);
        }
        if (this.jerConfig.JER_PLANTS.enableEmmer) {
            this.registerPlant((Item)((IPlantable)AtumItems.EMMER_SEEDS), AtumBlocks.FERTILE_SOIL_TILLED.func_176223_P(), new PlantDrop(new ItemStack(AtumItems.EMMER_SEEDS), 0, 2), new PlantDrop(new ItemStack(AtumItems.EMMER), 1, 1));
        }
        if (this.jerConfig.JER_PLANTS.enableFlax) {
            this.registerPlant((Item)((IPlantable)AtumItems.FLAX_SEEDS), AtumBlocks.FERTILE_SOIL_TILLED.func_176223_P(), new PlantDrop(new ItemStack(AtumItems.FLAX_SEEDS), 0, 2), new PlantDrop(new ItemStack(AtumItems.FLAX), 1, 1));
        }
        if (this.jerConfig.JER_PLANTS.enableOasisGrass) {
            PlantEntry plantEntry = new PlantEntry(new ItemStack((Block)AtumBlocks.OASIS_GRASS, 1, 0), new PlantDrop[]{new PlantDrop(new ItemStack(AtumItems.FLAX_SEEDS), 0.05625f), new PlantDrop(new ItemStack(AtumItems.EMMER_SEEDS), 0.05625f), new PlantDrop(new ItemStack(Items.field_151081_bc), 0.0125f)});
            plantEntry.setSoil(AtumBlocks.SAND.func_176223_P());
            this.registerCustomPlant(plantEntry);
        }
    }

    @Override
    public void registerModVillagers() {
        if (this.jerConfig.JER_VILLAGERS.enableSunspeaker) {
            try {
                final EntitySunspeaker sunspeaker = new EntitySunspeaker(this.world);
                Field tradesField = EntitySunspeaker.class.getDeclaredField("TRADES");
                tradesField.setAccessible(true);
                List trades = (List)tradesField.get(EntitySunspeaker.class);
                ArrayList allTrades = new ArrayList();
                for (EntityVillager.ITradeList[] tradeLists : trades) {
                    ArrayList<EntityVillager.ITradeList> tierTrades = new ArrayList<EntityVillager.ITradeList>();
                    for (EntityVillager.ITradeList tradeList : tradeLists) {
                        tierTrades.add(tradeList);
                    }
                    allTrades.add(tierTrades);
                }
                CustomVillagerRegistry.getInstance().addVillagerEntry(new CustomVillagerEntry(sunspeaker.func_70005_c_().toLowerCase(), 0, allTrades){

                    @Override
                    public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                        return sunspeaker;
                    }

                    @Override
                    public String getDisplayName() {
                        return sunspeaker.func_145748_c_().func_150254_d();
                    }
                });
            }
            catch (Exception e) {
                LogHelper.warn("Failed to register Sunspeaker villager.");
                e.printStackTrace();
            }
        }
    }

    private void registerAnimals() {
        String[] spawnBiomes;
        if (this.jerConfig.JER_MOBS.enableCamel) {
            spawnBiomes = BiomeHelper.getBiomeNamesForBiomes(new Biome[]{AtumBiomes.DEAD_OASIS, AtumBiomes.OASIS, AtumBiomes.SAND_DUNES, AtumBiomes.SAND_PLAINS});
            this.registerMob((EntityLivingBase)new EntityCamel(this.world), LightLevel.any, spawnBiomes, AtumLootTables.CAMEL);
        }
        if (this.jerConfig.JER_MOBS.enableDesertRabbit) {
            this.registerMob((EntityLivingBase)new EntityDesertRabbit(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), LootTableList.field_186393_A);
        }
        if (this.jerConfig.JER_MOBS.enableDesertWolf) {
            spawnBiomes = BiomeHelper.getBiomeNamesForBiomes(new Biome[]{AtumBiomes.LIMESTONE_CRAGS, AtumBiomes.LIMESTONE_MOUNTAINS, AtumBiomes.SAND_HILLS});
            this.registerMob((EntityLivingBase)new EntityDesertWolf(this.world), LightLevel.any, spawnBiomes, AtumLootTables.DESERT_WOLF);
        }
        if (this.jerConfig.JER_MOBS.enableDesertWolfAlpha) {
            try {
                EntityDesertWolf alphaWolf = new EntityDesertWolf(this.world);
                Method setVariantMethod = alphaWolf.getClass().getDeclaredMethod("setVariant", Integer.TYPE);
                setVariantMethod.setAccessible(true);
                setVariantMethod.invoke((Object)alphaWolf, 1);
                String[] spawnBiomes2 = BiomeHelper.getBiomeNamesForBiomes(new Biome[]{AtumBiomes.LIMESTONE_CRAGS, AtumBiomes.LIMESTONE_MOUNTAINS, AtumBiomes.SAND_HILLS});
                this.registerMob((EntityLivingBase)alphaWolf, LightLevel.any, spawnBiomes2, AtumLootTables.DESERT_WOLF_ALPHA);
            }
            catch (Exception e) {
                LogHelper.warn("Failed to register Alpha Desert Wolf.");
                e.printStackTrace();
            }
        }
        if (this.jerConfig.JER_MOBS.enableScarab) {
            this.registerMob((EntityLivingBase)new EntityScarab(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.SCARAB);
        }
        if (this.jerConfig.JER_MOBS.enableTarantula) {
            this.registerMob((EntityLivingBase)new EntityTarantula(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.TARANTULA);
        }
    }

    private void registerBandits() {
        if (this.jerConfig.JER_MOBS.enableAssassin) {
            this.registerMob((EntityLivingBase)new EntityAssassin(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.ASSASSIN);
            this.adjustHumanoidRenderHook(EntityAssassin.class);
        }
        if (this.jerConfig.JER_MOBS.enableBarbarian) {
            this.registerMob((EntityLivingBase)new EntityBarbarian(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.BARBARIAN);
            this.adjustHumanoidRenderHook(EntityBarbarian.class);
        }
        if (this.jerConfig.JER_MOBS.enableBrigand) {
            this.registerMob((EntityLivingBase)new EntityBrigand(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.BRIGAND);
            this.adjustHumanoidRenderHook(EntityBrigand.class);
        }
        if (this.jerConfig.JER_MOBS.enableNomad) {
            this.registerMob((EntityLivingBase)new EntityNomad(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.NOMAD);
            this.registerRenderHook(EntityNomad.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.1, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableSunspeaker) {
            this.registerMob((EntityLivingBase)new EntitySunspeaker(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(new Biome[]{AtumBiomes.LIMESTONE_MOUNTAINS}), AtumLootTables.SUNSPEAKER);
            this.adjustHumanoidRenderHook(EntitySunspeaker.class);
        }
    }

    private void registerStoneConstructs() {
        if (this.jerConfig.JER_MOBS.enableStoneguard) {
            this.registerMob((EntityLivingBase)new EntityStoneguard(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.STONEGUARD);
            this.adjustHumanoidRenderHook(EntityStoneguard.class);
        }
        if (this.jerConfig.JER_MOBS.enableStonewarden) {
            this.registerMob((EntityLivingBase)new EntityStonewarden(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.STONEWARDEN);
            this.registerRenderHook(EntityStonewarden.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)-0.6, (double)0.0);
                return renderInfo;
            });
        }
    }

    private void registerUndead() {
        if (this.jerConfig.JER_MOBS.enableBonestorm) {
            this.registerMob((EntityLivingBase)new EntityBonestorm(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.BONESTORM);
            this.adjustHumanoidRenderHook(EntityBonestorm.class);
        }
        if (this.jerConfig.JER_MOBS.enableForsaken) {
            this.registerMob((EntityLivingBase)new EntityForsaken(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.FORSAKEN);
            this.adjustHumanoidRenderHook(EntityForsaken.class);
        }
        if (this.jerConfig.JER_MOBS.enableMummy) {
            this.registerMob((EntityLivingBase)new EntityMummy(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.MUMMY);
            this.adjustHumanoidRenderHook(EntityMummy.class);
        }
        if (this.jerConfig.JER_MOBS.enableWraith) {
            this.registerMob((EntityLivingBase)new EntityWraith(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(AtumBiomes.BiomeTags.ATUM), AtumLootTables.WRAITH);
            this.adjustHumanoidRenderHook(EntityWraith.class);
        }
    }

    private void adjustHumanoidRenderHook(Class<? extends EntityLiving> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.45, (double)0.0);
            return renderInfo;
        });
    }

    private void registerAtumDungeon(String name, ResourceLocation lootTable) {
        JERDungeonStrings dungeon = new JERDungeonStrings(name);
        this.registerDungeonLoot(dungeon.category, dungeon.unlocName, lootTable);
    }

    private static class JERDungeonStrings {
        public final String category;
        public final String unlocName;

        public JERDungeonStrings(String name) {
            this.category = String.format("%s:%s", ModIds.ATUM.MOD_ID, name);
            this.unlocName = StringHelper.getDungeonTranslationKey(ModIds.ATUM.MOD_ID, name);
        }
    }
}

