/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.bewitchment.ModConfig;
import com.bewitchment.common.entity.living.EntityLizard;
import com.bewitchment.common.entity.living.EntityOwl;
import com.bewitchment.common.entity.living.EntityRaven;
import com.bewitchment.common.entity.living.EntitySnake;
import com.bewitchment.common.entity.living.EntityToad;
import com.bewitchment.common.entity.living.EntityWerewolf;
import com.bewitchment.common.entity.spirit.demon.EntityBafometyr;
import com.bewitchment.common.entity.spirit.demon.EntityBaphomet;
import com.bewitchment.common.entity.spirit.demon.EntityCambion;
import com.bewitchment.common.entity.spirit.demon.EntityCleaver;
import com.bewitchment.common.entity.spirit.demon.EntityDemon;
import com.bewitchment.common.entity.spirit.demon.EntityDemoness;
import com.bewitchment.common.entity.spirit.demon.EntityDruden;
import com.bewitchment.common.entity.spirit.demon.EntityFeuerwurm;
import com.bewitchment.common.entity.spirit.demon.EntityHellhound;
import com.bewitchment.common.entity.spirit.demon.EntityImp;
import com.bewitchment.common.entity.spirit.demon.EntityLeonard;
import com.bewitchment.common.entity.spirit.demon.EntityShadowPerson;
import com.bewitchment.common.entity.spirit.ghost.EntityBlackDog;
import com.bewitchment.common.entity.spirit.ghost.EntityGhost;
import com.bewitchment.common.item.ItemModSeeds;
import com.bewitchment.registry.ModObjects;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigBewitchment;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.CustomVillagerEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.CustomVillagerRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.util.LootTableHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class JERBewitchment
extends JERBase
implements IJERIntegration {
    public final JEMConfigBewitchment.JER jerConfig;

    public JERBewitchment(boolean enableJERMobs, boolean enableJERPlants, boolean enableJERVillagers) {
        this.jerConfig = JEMConfig.BEWITCHMENT.JUST_ENOUGH_RESOURCES;
        if (enableJERMobs) {
            this.registerModEntities();
        }
        if (enableJERPlants) {
            this.registerModPlants();
        }
        if (enableJERVillagers) {
            this.registerModVillagers();
        }
    }

    @Override
    public void registerModEntities() {
        if (this.jerConfig.JER_MOBS.enableBafometyr) {
            this.registerMob((EntityLivingBase)new EntityBafometyr(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.bafometyr.bafometyrBiomes), new ResourceLocation("bewitchment", "entities/bafometyr"));
            this.adjustHumanoidRenderHook(EntityBafometyr.class);
        }
        if (this.jerConfig.JER_MOBS.enableBaphomet) {
            EntityBaphomet baphomet = new EntityBaphomet(this.world);
            baphomet.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModObjects.caduceus));
            this.registerMob((EntityLivingBase)baphomet, LightLevel.any, new String[]{"None"}, new ResourceLocation("bewitchment", "entities/baphomet"));
            this.adjustLargeHumanoidRenderHook(baphomet.getClass());
        }
        if (this.jerConfig.JER_MOBS.enableBlackDog) {
            this.registerMob((EntityLivingBase)new EntityBlackDog(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.blackDog.blackDogBiomes), new ResourceLocation("bewitchment", "entities/black_dog"));
            this.adjustCreatureRenderHook(EntityBlackDog.class);
        }
        if (this.jerConfig.JER_MOBS.enableCambion) {
            this.registerMob((EntityLivingBase)new EntityCambion(this.world), LightLevel.any, new ResourceLocation("bewitchment", "entities/cambion"));
            this.adjustHumanoidRenderHook(EntityCambion.class);
        }
        if (this.jerConfig.JER_MOBS.enableCleaver) {
            EntityCleaver cleaver = new EntityCleaver(this.world);
            cleaver.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModObjects.cleaver_sword));
            cleaver.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151169_ag));
            cleaver.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151171_ah));
            this.registerMob((EntityLivingBase)cleaver, LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.cleaver.cleaverBiomes), new ResourceLocation("bewitchment", "entities/cleaver"));
            this.adjustHumanoidRenderHook(cleaver.getClass());
        }
        if (this.jerConfig.JER_MOBS.enableDemon) {
            this.registerMob((EntityLivingBase)new EntityDemon(this.world), LightLevel.any, new String[]{"None"}, this.getDemonDrops());
            this.adjustLargeHumanoidRenderHook(EntityDemon.class);
        }
        if (this.jerConfig.JER_MOBS.enableDemoness) {
            EntityDemoness demoness = new EntityDemoness(this.world);
            this.registerMob((EntityLivingBase)demoness, LightLevel.any, new String[]{"None"}, this.getDemonDrops());
        }
        if (this.jerConfig.JER_MOBS.enableDruden) {
            this.registerMob((EntityLivingBase)new EntityDruden(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.druden.drudenBiomes), new ResourceLocation("bewitchment", "entities/druden"));
            this.adjustHumanoidRenderHook(EntityDruden.class);
        }
        if (this.jerConfig.JER_MOBS.enableFeuerwurm) {
            this.registerMob((EntityLivingBase)new EntityFeuerwurm(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.feuerwurm.feuerwurmBiomes), new ResourceLocation("bewitchment", "entities/feuerwurm"));
        }
        if (this.jerConfig.JER_MOBS.enableGhost) {
            this.registerMob((EntityLivingBase)new EntityGhost(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.ghost.ghostBiomes), new ResourceLocation("bewitchment", "entities/ghost"));
            this.adjustHumanoidRenderHook(EntityGhost.class);
        }
        if (this.jerConfig.JER_MOBS.enableHellhound) {
            this.registerMob((EntityLivingBase)new EntityHellhound(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.hellhound.hellhoundBiomes), new ResourceLocation("bewitchment", "entities/hellhound"));
            this.adjustCreatureRenderHook(EntityHellhound.class);
        }
        if (this.jerConfig.JER_MOBS.enableImp) {
            this.registerMob((EntityLivingBase)new EntityImp(this.world), LightLevel.any, new String[]{"None"}, new ResourceLocation("bewitchment", "entities/imp"));
            this.registerRenderHook(EntityImp.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.4, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableLeonard) {
            EntityLeonard leonard = new EntityLeonard(this.world);
            leonard.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ModObjects.leonards_wand));
            this.registerMob((EntityLivingBase)leonard, LightLevel.any, new String[]{"None"}, new ResourceLocation("bewitchment", "entities/leonard"));
            this.adjustLargeHumanoidRenderHook(leonard.getClass());
        }
        if (this.jerConfig.JER_MOBS.enableLizard) {
            this.registerMob((EntityLivingBase)new EntityLizard(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.lizard.lizardBiomes), new ResourceLocation("bewitchment", "entities/lizard"));
            this.adjustSmallCreatureRenderHook(EntityLizard.class);
        }
        if (this.jerConfig.JER_MOBS.enableOwl) {
            this.registerMob((EntityLivingBase)new EntityOwl(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.owl.owlBiomes), new ResourceLocation("bewitchment", "entities/owl"));
        }
        if (this.jerConfig.JER_MOBS.enableRaven) {
            this.registerMob((EntityLivingBase)new EntityRaven(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.raven.ravenBiomes), new ResourceLocation("bewitchment", "entities/raven"));
        }
        if (this.jerConfig.JER_MOBS.enableShadowPerson) {
            this.registerMob((EntityLivingBase)new EntityShadowPerson(this.world), LightLevel.any, new String[]{"None"}, new ResourceLocation("bewitchment", "entities/shadow_person"));
            this.adjustHumanoidRenderHook(EntityShadowPerson.class);
        }
        if (this.jerConfig.JER_MOBS.enableSnake) {
            EntitySnake snake = new EntitySnake(this.world);
            this.registerMob((EntityLivingBase)snake, LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.snake.snakeBiomes), new ResourceLocation("bewitchment", "entities/snake"));
            this.adjustSmallCreatureRenderHook(snake.getClass());
        }
        if (this.jerConfig.JER_MOBS.enableToad) {
            this.registerMob((EntityLivingBase)new EntityToad(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.toad.toadBiomes), new ResourceLocation("bewitchment", "entities/toad"));
            this.adjustSmallCreatureRenderHook(EntityToad.class);
        }
        if (this.jerConfig.JER_MOBS.enableWerewolf) {
            this.registerMob((EntityLivingBase)new EntityWerewolf(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(ModConfig.mobSpawns.werewolf.werewolfBiomes), new ResourceLocation("bewitchment", "entities/werewolf"));
            this.adjustHumanoidRenderHook(EntityWerewolf.class);
        }
    }

    @Override
    public void registerModVillagers() {
        try {
            final EntityDemon demon = new EntityDemon(this.world);
            VillagerRegistry.VillagerProfession profession = demon.getProfessionForge();
            Field careersField = profession.getClass().getDeclaredField("careers");
            careersField.setAccessible(true);
            List careers = (List)careersField.get(profession);
            for (VillagerRegistry.VillagerCareer career : careers) {
                Field idField = career.getClass().getDeclaredField("id");
                Field tradesField = career.getClass().getDeclaredField("trades");
                idField.setAccessible(true);
                tradesField.setAccessible(true);
                int id = (Integer)idField.get(career);
                List trades = (List)tradesField.get(career);
                CustomVillagerEntry demonVillager = new CustomVillagerEntry(career.getName(), id, trades){

                    @Override
                    public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                        return demon;
                    }

                    @Override
                    public String getDisplayName() {
                        return super.getDisplayName();
                    }

                    @Override
                    public float getRenderScale() {
                        return 20.0f;
                    }
                };
                CustomVillagerRegistry.getInstance().addVillagerEntry(demonVillager);
            }
        }
        catch (Exception e) {
            LogHelper.warn("Failed to register Demon trades.");
        }
    }

    private LootDrop[] getDemonDrops() {
        ArrayList<LootDrop> demonDrops = new ArrayList<LootDrop>();
        for (int i = 0; i < 4; ++i) {
            ResourceLocation loc = new ResourceLocation(ModIds.BEWITCHMENT.MOD_ID, "entities/demon" + i);
            for (LootDrop drop : LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(loc))) {
                if (demonDrops.contains(drop)) continue;
                demonDrops.add(drop);
            }
        }
        return demonDrops.toArray(new LootDrop[0]);
    }

    private void adjustSmallCreatureRenderHook(Class<? extends EntityLiving> entity) {
        this.registerRenderHook(entity, (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)2.0, (double)2.0, (double)2.0);
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            return renderInfo;
        });
    }

    private void adjustCreatureRenderHook(Class<? extends EntityLiving> entity) {
        this.registerRenderHook(entity, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.4, (double)0.0);
            return renderInfo;
        });
    }

    private void adjustHumanoidRenderHook(Class<? extends EntityLiving> entity) {
        this.registerRenderHook(entity, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.6, (double)0.0);
            return renderInfo;
        });
    }

    private void adjustLargeHumanoidRenderHook(Class<? extends EntityLiving> entity) {
        this.registerRenderHook(entity, (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
            GlStateManager.func_179137_b((double)-0.05, (double)-0.8, (double)0.0);
            return renderInfo;
        });
    }

    @Override
    public void registerModPlants() {
        if (this.jerConfig.JER_PLANTS.enableAconitum) {
            this.registerPlant((ItemModSeeds)ModObjects.aconitum_seeds, new PlantDrop(new ItemStack(ModObjects.aconitum), 1, 1), new PlantDrop(new ItemStack(ModObjects.aconitum_seeds), 0, 1));
        }
        if (this.jerConfig.JER_PLANTS.enableBelladonna) {
            this.registerPlant((ItemModSeeds)ModObjects.belladonna_seeds, new PlantDrop(new ItemStack(ModObjects.belladonna), 1, 1), new PlantDrop(new ItemStack(ModObjects.belladonna_seeds), 0, 1));
        }
        if (this.jerConfig.JER_PLANTS.enableGarlic) {
            this.registerPlant((ItemModSeeds)ModObjects.garlic_seeds, new PlantDrop(new ItemStack(ModObjects.garlic), 1, 1), new PlantDrop(new ItemStack(ModObjects.garlic_seeds), 0, 1));
        }
        if (this.jerConfig.JER_PLANTS.enableHellebore) {
            this.registerPlant((ItemModSeeds)ModObjects.hellebore_seeds, new PlantDrop(new ItemStack(ModObjects.hellebore), 1, 1), new PlantDrop(new ItemStack(ModObjects.hellebore_seeds), 0, 1));
        }
        if (this.jerConfig.JER_PLANTS.enableMandrake) {
            this.registerPlant((ItemModSeeds)ModObjects.mandrake_seeds, new PlantDrop(new ItemStack(ModObjects.mandrake_root), 1, 1), new PlantDrop(new ItemStack(ModObjects.mandrake_seeds), 0, 1));
        }
        if (this.jerConfig.JER_PLANTS.enableWhiteSage) {
            this.registerPlant((ItemModSeeds)ModObjects.white_sage_seeds, new PlantDrop(new ItemStack(ModObjects.white_sage), 1, 1), new PlantDrop(new ItemStack(ModObjects.white_sage_seeds), 0, 1));
        }
        if (this.jerConfig.JER_PLANTS.enableWormwood) {
            this.registerPlant((ItemModSeeds)ModObjects.wormwood_seeds, new PlantDrop(new ItemStack(ModObjects.wormwood), 1, 1), new PlantDrop(new ItemStack(ModObjects.wormwood_seeds), 0, 1));
        }
    }
}

