/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigEBWizardry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityRemnant;
import electroblob.wizardry.registry.WizardryItems;
import java.lang.reflect.Method;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class JEREBWizardry
extends JERBase
implements IJERIntegration {
    JEMConfigEBWizardry.JER jerConfig;

    public JEREBWizardry(boolean enableJERDungeons, boolean enableJERMobs) {
        this.jerConfig = JEMConfig.EB_WIZARDRY.JUST_ENOUGH_RESOURCES;
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    @Override
    public void registerModDungeons() {
        this.registerEBDungeon("library_ruins_bookshelf");
        this.registerEBDungeon("obelisk");
        this.registerEBDungeon("shrine");
        this.registerEBDungeon("wizard_tower");
    }

    @Override
    public void registerModEntities() {
        Method getLootMethod;
        if (this.jerConfig.enableEvilWizard) {
            try {
                EntityEvilWizard evilWizard = new EntityEvilWizard(this.world);
                evilWizard.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(WizardryItems.wizard_hat));
                evilWizard.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(WizardryItems.wizard_robe));
                evilWizard.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(WizardryItems.wizard_leggings));
                evilWizard.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(WizardryItems.wizard_boots));
                evilWizard.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(WizardryItems.magic_wand));
                getLootMethod = evilWizard.getClass().getDeclaredMethod("getLootTable", new Class[0]);
                getLootMethod.setAccessible(true);
                this.registerMob((EntityLivingBase)evilWizard, LightLevel.hostile, (ResourceLocation)getLootMethod.invoke((Object)evilWizard, new Object[0]));
                this.registerRenderHook(evilWizard.getClass(), (renderInfo, e) -> {
                    GlStateManager.func_179137_b((double)-0.05, (double)-0.4, (double)0.0);
                    return renderInfo;
                });
            }
            catch (Exception e2) {
                LogHelper.warn("Failed to register Evil Wizard.");
                e2.printStackTrace();
            }
        }
        if (this.jerConfig.enableRemnantEarth) {
            try {
                EntityRemnant earthRemnant = new EntityRemnant(this.world);
                earthRemnant.setElement(Element.EARTH);
                getLootMethod = earthRemnant.getClass().getDeclaredMethod("getLootTable", new Class[0]);
                getLootMethod.setAccessible(true);
                this.registerMob((EntityLivingBase)earthRemnant, LightLevel.hostile, (ResourceLocation)getLootMethod.invoke((Object)earthRemnant, new Object[0]));
            }
            catch (Exception e3) {
                LogHelper.warn("Failed to register Earth Remnant.");
                e3.printStackTrace();
            }
        }
        if (this.jerConfig.enableRemnantFire) {
            try {
                EntityRemnant fireRemnant = new EntityRemnant(this.world);
                fireRemnant.setElement(Element.FIRE);
                getLootMethod = fireRemnant.getClass().getDeclaredMethod("getLootTable", new Class[0]);
                getLootMethod.setAccessible(true);
                this.registerMob((EntityLivingBase)fireRemnant, LightLevel.hostile, (ResourceLocation)getLootMethod.invoke((Object)fireRemnant, new Object[0]));
            }
            catch (Exception e4) {
                LogHelper.warn("Failed to register Fire Remnant.");
                e4.printStackTrace();
            }
        }
        if (this.jerConfig.enableRemnantHealing) {
            try {
                EntityRemnant healingRemnant = new EntityRemnant(this.world);
                healingRemnant.setElement(Element.HEALING);
                getLootMethod = healingRemnant.getClass().getDeclaredMethod("getLootTable", new Class[0]);
                getLootMethod.setAccessible(true);
                this.registerMob((EntityLivingBase)healingRemnant, LightLevel.hostile, (ResourceLocation)getLootMethod.invoke((Object)healingRemnant, new Object[0]));
            }
            catch (Exception e5) {
                LogHelper.warn("Failed to register Healing Remnant.");
                e5.printStackTrace();
            }
        }
        if (this.jerConfig.enableRemnantIce) {
            try {
                EntityRemnant iceRemanant = new EntityRemnant(this.world);
                iceRemanant.setElement(Element.ICE);
                getLootMethod = iceRemanant.getClass().getDeclaredMethod("getLootTable", new Class[0]);
                getLootMethod.setAccessible(true);
                this.registerMob((EntityLivingBase)iceRemanant, LightLevel.hostile, (ResourceLocation)getLootMethod.invoke((Object)iceRemanant, new Object[0]));
            }
            catch (Exception e6) {
                LogHelper.warn("Failed to register Ice Remnant.");
                e6.printStackTrace();
            }
        }
        if (this.jerConfig.enableRemnantLightning) {
            try {
                EntityRemnant lightningRemnant = new EntityRemnant(this.world);
                lightningRemnant.setElement(Element.LIGHTNING);
                getLootMethod = lightningRemnant.getClass().getDeclaredMethod("getLootTable", new Class[0]);
                getLootMethod.setAccessible(true);
                this.registerMob((EntityLivingBase)lightningRemnant, LightLevel.hostile, (ResourceLocation)getLootMethod.invoke((Object)lightningRemnant, new Object[0]));
            }
            catch (Exception e7) {
                LogHelper.warn("Failed to register Lightning Remnant.");
                e7.printStackTrace();
            }
        }
        if (this.jerConfig.enableRemnantNecromancy) {
            try {
                EntityRemnant necromancyRemnant = new EntityRemnant(this.world);
                necromancyRemnant.setElement(Element.NECROMANCY);
                getLootMethod = necromancyRemnant.getClass().getDeclaredMethod("getLootTable", new Class[0]);
                getLootMethod.setAccessible(true);
                this.registerMob((EntityLivingBase)necromancyRemnant, LightLevel.hostile, (ResourceLocation)getLootMethod.invoke((Object)necromancyRemnant, new Object[0]));
            }
            catch (Exception e8) {
                LogHelper.warn("Failed to register Necromancy Remnant.");
                e8.printStackTrace();
            }
        }
        if (this.jerConfig.enableRemnantSorcery) {
            try {
                EntityRemnant sorceryRemnant = new EntityRemnant(this.world);
                sorceryRemnant.setElement(Element.SORCERY);
                getLootMethod = sorceryRemnant.getClass().getDeclaredMethod("getLootTable", new Class[0]);
                getLootMethod.setAccessible(true);
                this.registerMob((EntityLivingBase)sorceryRemnant, LightLevel.hostile, (ResourceLocation)getLootMethod.invoke((Object)sorceryRemnant, new Object[0]));
            }
            catch (Exception e9) {
                LogHelper.warn("Failed to register Sorcery Remnant.");
                e9.printStackTrace();
            }
        }
    }

    @Override
    public void registerModVillagers() {
    }

    private void registerEBDungeon(String name) {
        JERDungeonStrings dungeon = new JERDungeonStrings(name);
        this.registerDungeonLoot(dungeon.category, dungeon.unlocName, dungeon.lootTable);
    }

    private class JERDungeonStrings {
        public final String category;
        public final String unlocName;
        public final ResourceLocation lootTable;

        public JERDungeonStrings(String name) {
            this.category = ModIds.EB_WIZARDRY.MOD_ID + ":" + name;
            this.unlocName = StringHelper.getDungeonTranslationKey(ModIds.EB_WIZARDRY.MOD_ID, name);
            this.lootTable = new ResourceLocation(ModIds.EB_WIZARDRY.MOD_ID, "chests/" + name);
        }
    }
}

