/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigFutureMC;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.plant.CustomPlantEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.PlantDrop;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thedarkcolour.futuremc.config.FConfig;
import thedarkcolour.futuremc.entity.fish.cod.EntityCod;
import thedarkcolour.futuremc.entity.fish.pufferfish.EntityPufferfish;
import thedarkcolour.futuremc.entity.fish.salmon.EntitySalmon;
import thedarkcolour.futuremc.entity.fish.tropical.EntityTropicalFish;
import thedarkcolour.futuremc.registry.FBlocks;
import thedarkcolour.futuremc.registry.FItems;

public class JERFutureMC
extends JERBase
implements IJERIntegration {
    private static final JEMConfigFutureMC.JER jerConfig = JEMConfig.FUTURE_MC.JUST_ENOUGH_RESOURCES;

    public JERFutureMC(boolean enableJERMobs, boolean enableJERPlants) {
        if (enableJERMobs) {
            this.registerModEntities();
        }
        if (enableJERPlants) {
            this.registerModPlants();
        }
    }

    @Override
    public void registerModEntities() {
        FConfig.UpdateAquatic.FishConfig fish = FConfig.INSTANCE.getUpdateAquatic().fish;
        if (JERFutureMC.jerConfig.JER_MOBS.enableCod && fish.cod.enabled) {
            ResourceLocation codTable = new ResourceLocation(ModIds.FUTURE_MC.MOD_ID, "entities/cod");
            this.registerMob((EntityLivingBase)new EntityCod(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(FConfig.INSTANCE.getUpdateAquatic().fish.cod.validBiomes), codTable);
        }
        if (JERFutureMC.jerConfig.JER_MOBS.enablePufferfish && fish.pufferfish.enabled) {
            ResourceLocation pufferfishTable = new ResourceLocation(ModIds.FUTURE_MC.MOD_ID, "entities/pufferfish");
            this.registerMob((EntityLivingBase)new EntityPufferfish(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(FConfig.INSTANCE.getUpdateAquatic().fish.pufferfish.validBiomes), pufferfishTable);
        }
        if (JERFutureMC.jerConfig.JER_MOBS.enableSalmon && fish.salmon.enabled) {
            ResourceLocation salmonTable = new ResourceLocation(ModIds.FUTURE_MC.MOD_ID, "entities/salmon");
            this.registerMob((EntityLivingBase)new EntitySalmon(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(FConfig.INSTANCE.getUpdateAquatic().fish.salmon.validBiomes), salmonTable);
        }
        if (JERFutureMC.jerConfig.JER_MOBS.enableTropicalFish && fish.tropicalFish.enabled) {
            EntityTropicalFish tropicalFish = new EntityTropicalFish(this.world);
            tropicalFish.generateVariant();
            ResourceLocation tropicalFishTable = new ResourceLocation(ModIds.FUTURE_MC.MOD_ID, "entities/tropical_fish");
            this.registerMob((EntityLivingBase)tropicalFish, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(FConfig.INSTANCE.getUpdateAquatic().fish.tropicalFish.validBiomes), tropicalFishTable);
        }
    }

    @Override
    public void registerModPlants() {
        if (JERFutureMC.jerConfig.JER_PLANTS.enableSweetBerry && FConfig.INSTANCE.getVillageAndPillage().sweetBerryBush.enabled) {
            CustomPlantEntry sweetBerryEntry = new CustomPlantEntry(new ItemStack((Item)FItems.INSTANCE.getSWEET_BERRIES()), FBlocks.INSTANCE.getSWEET_BERRY_BUSH().func_176223_P(), new PlantDrop(new ItemStack((Item)FItems.INSTANCE.getSWEET_BERRIES()), 1, 3));
            sweetBerryEntry.setSoil(Blocks.field_150349_c.func_176223_P());
            this.registerCustomPlant(sweetBerryEntry);
        }
    }
}

