/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigGrimoireOfGaia;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag.LootBagEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.integrations.jer.conditionals.JEMConditional;
import com.invadermonky.justenoughmagiculture.registry.LootBagRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import gaia.GaiaConfig;
import gaia.entity.monster.EntityGaiaAnt;
import gaia.entity.monster.EntityGaiaAntRanger;
import gaia.entity.monster.EntityGaiaAnubis;
import gaia.entity.monster.EntityGaiaArachne;
import gaia.entity.monster.EntityGaiaBanshee;
import gaia.entity.monster.EntityGaiaBaphomet;
import gaia.entity.monster.EntityGaiaBee;
import gaia.entity.monster.EntityGaiaBeholder;
import gaia.entity.monster.EntityGaiaBoneKnight;
import gaia.entity.monster.EntityGaiaCecaelia;
import gaia.entity.monster.EntityGaiaCentaur;
import gaia.entity.monster.EntityGaiaCobbleGolem;
import gaia.entity.monster.EntityGaiaCobblestoneGolem;
import gaia.entity.monster.EntityGaiaCreep;
import gaia.entity.monster.EntityGaiaDeathword;
import gaia.entity.monster.EntityGaiaDhampir;
import gaia.entity.monster.EntityGaiaDryad;
import gaia.entity.monster.EntityGaiaDullahan;
import gaia.entity.monster.EntityGaiaDwarf;
import gaia.entity.monster.EntityGaiaEnderDragonGirl;
import gaia.entity.monster.EntityGaiaEnderEye;
import gaia.entity.monster.EntityGaiaFleshLich;
import gaia.entity.monster.EntityGaiaGelatinousSlime;
import gaia.entity.monster.EntityGaiaGoblin;
import gaia.entity.monster.EntityGaiaGoblinFeral;
import gaia.entity.monster.EntityGaiaGryphon;
import gaia.entity.monster.EntityGaiaHarpy;
import gaia.entity.monster.EntityGaiaHarpyWizard;
import gaia.entity.monster.EntityGaiaHunter;
import gaia.entity.monster.EntityGaiaIllagerButler;
import gaia.entity.monster.EntityGaiaIllagerFire;
import gaia.entity.monster.EntityGaiaIllagerInquisitor;
import gaia.entity.monster.EntityGaiaKikimora;
import gaia.entity.monster.EntityGaiaKobold;
import gaia.entity.monster.EntityGaiaMandragora;
import gaia.entity.monster.EntityGaiaMatango;
import gaia.entity.monster.EntityGaiaMermaid;
import gaia.entity.monster.EntityGaiaMimic;
import gaia.entity.monster.EntityGaiaMinotaur;
import gaia.entity.monster.EntityGaiaMinotaurus;
import gaia.entity.monster.EntityGaiaMite;
import gaia.entity.monster.EntityGaiaMonoeye;
import gaia.entity.monster.EntityGaiaMummy;
import gaia.entity.monster.EntityGaiaNaga;
import gaia.entity.monster.EntityGaiaNineTails;
import gaia.entity.monster.EntityGaiaOni;
import gaia.entity.monster.EntityGaiaOrc;
import gaia.entity.monster.EntityGaiaSatyress;
import gaia.entity.monster.EntityGaiaSelkie;
import gaia.entity.monster.EntityGaiaShaman;
import gaia.entity.monster.EntityGaiaSharko;
import gaia.entity.monster.EntityGaiaSiren;
import gaia.entity.monster.EntityGaiaSludgeGirl;
import gaia.entity.monster.EntityGaiaSphinx;
import gaia.entity.monster.EntityGaiaSporeling;
import gaia.entity.monster.EntityGaiaSpriggan;
import gaia.entity.monster.EntityGaiaSuccubus;
import gaia.entity.monster.EntityGaiaToad;
import gaia.entity.monster.EntityGaiaValkyrie;
import gaia.entity.monster.EntityGaiaVampire;
import gaia.entity.monster.EntityGaiaWerecat;
import gaia.entity.monster.EntityGaiaWitch;
import gaia.entity.monster.EntityGaiaWitherCow;
import gaia.entity.monster.EntityGaiaYeti;
import gaia.entity.monster.EntityGaiaYukiOnna;
import gaia.init.GaiaBlocks;
import gaia.init.GaiaItems;
import gaia.init.GaiaLootTables;
import java.util.ArrayList;
import java.util.List;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.util.LootTableHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.oredict.OreDictionary;

public class JERGrimoireOfGaia
extends JERBase
implements IJERIntegration {
    private static JERGrimoireOfGaia instance;
    private final JEMConfigGrimoireOfGaia.JER jerConfig;
    private String[] validUnderground;
    private String[] invalidUnderground;

    private JERGrimoireOfGaia() {
        this.jerConfig = JEMConfig.GRIMOIRE_OF_GAIA.JUST_ENOUGH_RESOURCES;
        this.validUnderground = new String[]{"CONIFEROUS", "DENSE", "FOREST", "JUNGLE", "MESA", "MOUNTAIN", "PLAINS", "SANDY", "SAVANNA", "SNOWY", "SPOOKY", "SWAMP"};
        this.invalidUnderground = new String[]{"BEACH", "COLD", "HOT", "OCEAN", "RIVER", "SPARSE"};
    }

    public JERGrimoireOfGaia(boolean enableJERMobs) {
        this.jerConfig = JEMConfig.GRIMOIRE_OF_GAIA.JUST_ENOUGH_RESOURCES;
        this.validUnderground = new String[]{"CONIFEROUS", "DENSE", "FOREST", "JUNGLE", "MESA", "MOUNTAIN", "PLAINS", "SANDY", "SAVANNA", "SNOWY", "SPOOKY", "SWAMP"};
        this.invalidUnderground = new String[]{"BEACH", "COLD", "HOT", "OCEAN", "RIVER", "SPARSE"};
        if (enableJERMobs) {
            this.registerModEntities();
        }
        JERGrimoireOfGaia.getInstance();
    }

    public static JERGrimoireOfGaia getInstance() {
        return instance != null ? instance : (instance = new JERGrimoireOfGaia());
    }

    public void registerLootBagEntries() {
        if (JEMConfig.GRIMOIRE_OF_GAIA.JUST_ENOUGH_ITEMS.enableJEILootBags) {
            LootBagRegistry registry = LootBagRegistry.getInstance();
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BAG_ARROW), this.manager.func_186521_a(GaiaLootTables.BAG_ARROW)));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BOX_IRON), this.manager.func_186521_a(GaiaLootTables.BOXES_IRON)));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BOX_GOLD), this.manager.func_186521_a(GaiaLootTables.BOXES_GOLD)));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BOX_DIAMOND), this.manager.func_186521_a(GaiaLootTables.BOXES_DIAMOND)));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BOX, 1, 0), this.manager.func_186521_a(GaiaLootTables.BOXES_OVERWORLD)));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BOX, 1, 1), this.manager.func_186521_a(GaiaLootTables.BOXES_NETHER)));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BOX, 1, 2), this.manager.func_186521_a(GaiaLootTables.BOXES_END)));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BAG_RECORD), this.getRecordBagDrops()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.SPAWN), this.getSpawnBagDrops()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BOX_OLD), this.getOldBoxDrops()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(GaiaItems.BOX_HAT), this.getHatBoxDrops()));
        }
    }

    @Override
    public void registerModEntities() {
        this.registerAssistMobs();
        this.registerAssistDayMobs();
        this.registerHostileMobs();
        this.registerHostileDayMobs();
    }

    private LootTable getRecordBagDrops() {
        LootPool pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "main");
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151096_cd));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151093_ce));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151094_cf));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151091_cg));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151092_ch));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151089_ci));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151090_cj));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151087_ck));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151088_cl));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151085_cm));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151086_cn));
        pool.addEntry((LootEntry)this.getSingleLootEntry(Items.field_151084_co));
        return new LootTable(new LootPool[]{pool});
    }

    private LootTable getSpawnBagDrops() {
        LootPool pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "main");
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.SPAWN_CREEPER_GIRL));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.SPAWN_ENDER_GIRL));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.SPAWN_HOLSTAURUS));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.SPAWN_SLIME_GIRL));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.SPAWN_TRADER));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.SPAWN_WERESHEEP));
        return new LootTable(new LootPool[]{pool});
    }

    private LootTable getOldBoxDrops() {
        LootPool pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "main");
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.MISC_GIGA_GEAR));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.WEAPON_BOOK_WITHER));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.SPAWN));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.BAG_BOOK));
        return new LootTable(new LootPool[]{pool});
    }

    private LootTable getHatBoxDrops() {
        LootPool pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "main");
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.ACCESSORY_HEADGEAR));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.ACCESSORY_HEADGEAR_MOB));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.ACCESSORY_HEADGEAR_BOLT));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.ACCESSORY_HEADGEAR_ARROW));
        pool.addEntry((LootEntry)this.getSingleLootEntry(GaiaItems.ACCESSORY_HEADGEAR_DOLL));
        return new LootTable(new LootPool[]{pool});
    }

    private LootEntryItem getSingleLootEntry(Item item) {
        return new LootEntryItem(item, 1, 1, new LootFunction[]{new SetCount(new LootCondition[0], new RandomValueRange(0.0f, 1.0f))}, new LootCondition[0], item.delegate.name().toString());
    }

    private void registerAssistMobs() {
        if (this.jerConfig.enableEnderDragonGirl) {
            this.registerEnderDragonGirl();
        }
        if (this.jerConfig.enableEnderEye) {
            this.registerEnderEye();
        }
        if (this.jerConfig.enableHarpyWizard) {
            this.registerHarpyWizard();
        }
        if (this.jerConfig.enableMermaid) {
            this.registerMermaid();
        }
    }

    private void registerAssistDayMobs() {
        if (this.jerConfig.enableBee) {
            this.registerBee();
        }
        if (this.jerConfig.enableCentaur) {
            this.registerCentaur();
        }
        if (this.jerConfig.enableCobbleGolem) {
            this.registerCobbleGolem();
        }
        if (this.jerConfig.enableDryad) {
            this.registerDryad();
        }
        if (this.jerConfig.enableDwarf) {
            this.registerDwarf();
        }
        if (this.jerConfig.enableDwarfArcher) {
            this.registerDwarfArcher();
        }
        if (this.jerConfig.enableDwarfMiner) {
            this.registerDwarfMiner();
        }
        if (this.jerConfig.enableGoblin) {
            this.registerGoblin();
        }
        if (this.jerConfig.enableGoblinArcher) {
            this.registerGoblinArcher();
        }
        if (this.jerConfig.enableGryphon) {
            this.registerGryphon();
        }
        if (this.jerConfig.enableHunter) {
            this.registerHunter();
        }
        if (this.jerConfig.enableKikimora) {
            this.registerKikimora();
        }
        if (this.jerConfig.enableCyclops) {
            this.registerMonoeye();
        }
        if (this.jerConfig.enableSatyress) {
            this.registerSatyress();
        }
        if (this.jerConfig.enableValkyrie) {
            this.registerValkyrie();
        }
        if (this.jerConfig.enableYukiOnna) {
            this.registerYukiOnna();
        }
    }

    private void registerHostileMobs() {
        if (this.jerConfig.enableAnubis) {
            this.registerAnubis();
        }
        if (this.jerConfig.enableArachne) {
            this.registerArachne();
        }
        if (this.jerConfig.enableBanshee) {
            this.registerBanshee();
        }
        if (this.jerConfig.enableBaphomet) {
            this.registerBaphomet();
        }
        if (this.jerConfig.enableBeholder) {
            this.registerBeholder();
        }
        if (this.jerConfig.enableBoneKnight) {
            this.registerBoneKnight();
        }
        if (this.jerConfig.enableCecaelia) {
            this.registerCecaelia();
        }
        if (this.jerConfig.enableCobblestoneGolem) {
            this.registerCobblestoneGolem();
        }
        if (this.jerConfig.enableCreep) {
            this.registerCreep();
        }
        if (this.jerConfig.enableDeathword) {
            this.registerDeathword();
        }
        if (this.jerConfig.enableDhampir) {
            this.registerDhampir();
        }
        if (this.jerConfig.enableDullahan) {
            this.registerDullahan();
        }
        if (this.jerConfig.enableFleshLich) {
            this.registerFleshLich();
        }
        if (this.jerConfig.enableGelatinousSlime) {
            this.registerGelatinousSlime();
        }
        if (this.jerConfig.FERAL_GOBLIN.enableMobJER) {
            this.registerGoblinFeral();
        }
        if (this.jerConfig.FERAL_GOBLIN_ARCHER.enableMobJER) {
            this.registerGoblinFeralArcher();
        }
        if (this.jerConfig.FERAL_GOBLIN_BOMBER.enableMobJER) {
            this.registerGoblinFeralBomber();
        }
        if (this.jerConfig.enableGravemite) {
            this.registerGravemite();
        }
        if (this.jerConfig.enableHarpy) {
            this.registerHarpy();
        }
        if (this.jerConfig.ILLAGER_BUTLER.enableMobJER) {
            this.registerIllagerButler();
        }
        if (this.jerConfig.ILLAGER_INCINERATOR.enableMobJER) {
            this.registerIllagerFire();
        }
        if (this.jerConfig.ILLAGER_INQUISITOR.enableMobJER) {
            this.registerIllagerInquisitor();
        }
        if (this.jerConfig.enableKobold) {
            this.registerKobold();
        }
        if (this.jerConfig.enableMimic) {
            this.registerMimic();
        }
        if (this.jerConfig.enableMinotaur) {
            this.registerMinotaur();
        }
        if (this.jerConfig.enableMinotaurus) {
            this.registerMinotaurus();
        }
        if (this.jerConfig.enableMinotaurusArcher) {
            this.registerMinotaurusArcher();
        }
        if (this.jerConfig.enableMummy) {
            this.registerMummy();
        }
        if (this.jerConfig.enableNineTails) {
            this.registerNineTails();
        }
        if (this.jerConfig.enableOni) {
            this.registerOni();
        }
        if (this.jerConfig.enableOrc) {
            this.registerOrc();
        }
        if (this.jerConfig.enableOrcWizard) {
            this.registerOrcRanged();
        }
        if (this.jerConfig.enableSHAMAN) {
            this.registerShaman();
        }
        if (this.jerConfig.enableSHARKO) {
            this.registerSharko();
        }
        if (this.jerConfig.enableSludgeGirl) {
            this.registerSludgeGirl();
        }
        if (this.jerConfig.enableSphinx) {
            this.registerSphinx();
        }
        if (this.jerConfig.enableSporeling) {
            this.registerSporeling();
        }
        if (this.jerConfig.enableSpriggan) {
            this.registerSpriggan();
        }
        if (this.jerConfig.enableSuccubus) {
            this.registerSuccubus();
        }
        if (this.jerConfig.enableVampire) {
            this.registerVampire();
        }
        if (this.jerConfig.enableWerecat) {
            this.registerWerecat();
        }
        if (this.jerConfig.enableWitch) {
            this.registerWitch();
        }
        if (this.jerConfig.enableWitherCow) {
            this.registerWitherCow();
        }
        if (this.jerConfig.enableYeti) {
            this.registerYeti();
        }
    }

    private void registerHostileDayMobs() {
        if (this.jerConfig.enableAntWorker) {
            this.registerAnt();
        }
        if (this.jerConfig.enableAntScavenger) {
            this.registerAntRanger();
        }
        if (this.jerConfig.enableMandragora) {
            this.registerMandragora();
        }
        if (this.jerConfig.enableMatango) {
            this.registerMatango();
        }
        if (this.jerConfig.enableNaga) {
            this.registerNaga();
        }
        if (this.jerConfig.enableSelkie) {
            this.registerSelkie();
        }
        if (this.jerConfig.enableSiren) {
            this.registerSiren();
        }
        if (this.jerConfig.enableToad) {
            this.registerToad();
        }
    }

    private void registerEnderDragonGirl() {
        EntityGaiaEnderDragonGirl entity = new EntityGaiaEnderDragonGirl(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"END"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ENDER_DRAGON_GIRL;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151079_bi, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 2));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.SPAWN_ENDER_GIRL));
            loot.add(this.getRareDrop(GaiaItems.MISC_ELYTRA));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerEnderEye() {
        EntityGaiaEnderEye entity = new EntityGaiaEnderEye(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.validUnderground, this.invalidUnderground);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ENDER_EYE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151079_bi, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DOLL_ENDER_GIRL));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerHarpyWizard() {
        EntityGaiaHarpyWizard entity = new EntityGaiaHarpyWizard(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_HARPY_WIZARD;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_SOUL_FIRE, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getUncommonDrop(GaiaItems.MISC_BOOK));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerMermaid() {
        EntityGaiaMermaid entity = new EntityGaiaMermaid(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"BEACH", "OCEAN", "RIVER"}, new String[]{"MUSHROOM"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MERMAID;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_PEARL, 0, 2, this.getDropChance(2, 3), true));
            loot.add(this.getCommonDrop(Items.field_179562_cC, 0, 1, this.getDropChance(1, 4), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.BOX_OLD));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DOLL_MERMAID));
            loot.add(this.getRareDrop(GaiaItems.ACCESSORY_TRINKET_WATER_BREATHING));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerBee() {
        EntityGaiaBee entity = new EntityGaiaBee(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"DENSE", "FOREST", "RARE"}, new String[]{"CONIFEROUS", "COLD", "HOT", "SPARSE", "SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_BEE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151100_aR, 15, 0, 1, this.getDropChance(1, 2), true));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_HONEY, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerCentaur() {
        EntityGaiaCentaur entity = new EntityGaiaCentaur(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"PLAINS", "MESA"}, new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_CENTAUR;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151116_aA, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDrop(GaiaItems.BAG_ARROW));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)0.0, (double)-0.2, (double)0.0);
            return renderInfo;
        });
    }

    private void registerCobbleGolem() {
        EntityGaiaCobbleGolem entity = new EntityGaiaCobbleGolem(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"JUNGLE"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_COBBLE_GOLEM;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerDryad() {
        EntityGaiaDryad entity = new EntityGaiaDryad(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"DENSE", "FOREST", "RARE"}, new String[]{"CONIFEROUS", "COLD", "HOT", "SPARSE", "SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_DRYAD;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_ROOT, 0, 1, this.getDropChance(1, 2), true));
            loot.add(this.getCommonDrop(Item.func_150898_a((Block)Blocks.field_150364_r), 0, 1, this.getDropChance(1, 2), false, JEMConditional.killedWithAxe));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DOLL_DRYAD));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerDwarf() {
        EntityGaiaDwarf entity = new EntityGaiaDwarf(this.world);
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_AXE_STONE));
        entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.SHIELD_PROP, 1, 1));
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"MOUNTAIN"}, new String[]{"COLD", "DENSE", "HOT"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_DWARF_MELEE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_MEAT, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.BAG_ARROW));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerDwarfArcher() {
        EntityGaiaDwarf entity = new EntityGaiaDwarf(this.world);
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"MOUNTAIN"}, new String[]{"COLD", "DENSE", "HOT"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_DWARF_RANGED;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151032_g, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.BAG_ARROW));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
    }

    private void registerDwarfMiner() {
        EntityGaiaDwarf entity = new EntityGaiaDwarf(this.world);
        entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151050_s));
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"MOUNTAIN"}, new String[]{"COLD", "DENSE", "HOT"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_DWARF_MINER;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_191525_da, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.BAG_ARROW));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
    }

    private void registerGoblin() {
        EntityGaiaGoblin entity = new EntityGaiaGoblin(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_GOBLIN_MELEE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_MEAT, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerGoblinArcher() {
        EntityGaiaGoblin entity = new EntityGaiaGoblin(this.world);
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROJECTILE_BOMB));
        entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_151033_d));
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_GOBLIN_RANGED;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_MEAT, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDrop(GaiaItems.BAG_ARROW));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
    }

    private void registerGryphon() {
        EntityGaiaGryphon entity = new EntityGaiaGryphon(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"MOUNTAIN"}, new String[]{"COLD", "DENSE", "HOT"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_GRYPHON;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151008_G, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerHunter() {
        EntityGaiaHunter entity = new EntityGaiaHunter(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"JUNGLE"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_HUNTER;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_ROTTEN_HEART, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDrop(GaiaItems.BAG_ARROW));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerKikimora() {
        EntityGaiaKikimora entity = new EntityGaiaKikimora(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"CONIFEROUS", "SNOWY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_KIKIMORA;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_FUR, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerMonoeye() {
        EntityGaiaMonoeye entity = new EntityGaiaMonoeye(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"CONIFEROUS"}, new String[]{"SNOWY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MONOEYE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_FUR, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            if (Enchantments.field_185302_k != null) {
                ItemStack enchantedBook = new ItemStack(Items.field_151134_bR);
                ItemEnchantedBook.func_92115_a((ItemStack)enchantedBook, (EnchantmentData)new EnchantmentData(Enchantments.field_185302_k, 1));
                loot.add(this.getRareDrop(enchantedBook));
            }
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerSatyress() {
        EntityGaiaSatyress entity = new EntityGaiaSatyress(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"PLAINS", "MESA"}, new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SATYRESS;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_MEAT, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerValkyrie() {
        EntityGaiaValkyrie entity = new EntityGaiaValkyrie(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"MOUNTAIN"}, new String[]{"COLD", "DENSE", "HOT"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_VALKYRIE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_SMALL_APPLE_GOLD, 0, 1, this.getDropChance(1, 4), true));
            loot.add(this.getCommonDrop(this.unifyNugget(3), 1, 3, 1.0f, false));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_DIAMOND));
            loot.add(this.getRareDecoDrop(GaiaBlocks.BUST_VALKYRIE));
            loot.add(this.getRareDrop(GaiaItems.MISC_RING, 0));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)1.35, (double)1.35, (double)1.35);
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            return renderInfo;
        });
    }

    private void registerYukiOnna() {
        EntityGaiaYukiOnna entity = new EntityGaiaYukiOnna(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"CONIFEROUS"}, new String[]{"SNOWY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_YUKI_ONNA;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_FUR, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            ItemStack fanIce = new ItemStack(GaiaItems.WEAPON_FAN_ICE);
            if (Enchantments.field_180313_o != null) {
                fanIce.func_77966_a(Enchantments.field_180313_o, 4);
            }
            loot.add(this.getRareDrop(fanIce));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerAnubis() {
        EntityGaiaAnubis entity = new EntityGaiaAnubis(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SANDY"}, new String[]{"MESA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ANUBIS;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.MISC_BOOK));
            loot.add(this.getRareDrop(GaiaItems.SPAWN_WERESHEEP));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerArachne() {
        EntityGaiaArachne entity = new EntityGaiaArachne(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.validUnderground, this.invalidUnderground);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ARACHNE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_FURNACE_FUEL, 0, 1, this.getDropChance(1, 4), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getRareDrop(GaiaItems.MISC_BOOK));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerBanshee() {
        EntityGaiaBanshee entity = new EntityGaiaBanshee(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"MOUNTAIN"}, new String[]{"COLD", "DENSE", "HOT"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_BANSHEE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_SOUL_FIRE, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.WEAPON_BOOK_NIGHTMARE));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)0.0, (double)0.1, (double)0.0);
            return renderInfo;
        });
    }

    private void registerBaphomet() {
        EntityGaiaBaphomet entity = new EntityGaiaBaphomet(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"NETHER"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_BAPHOMET;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151065_br, 0, 2, this.getDropChance(2, 3), true));
            loot.add(this.getCommonDrop(GaiaItems.MISC_SOUL_FIRE, 0, 2, this.getDropChance(2, 3), true));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_NETHER_WART, 0, 1, this.getDropChance(1, 4), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 1));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.ACCESSORY_TRINKET_WITHER));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerBeholder() {
        EntityGaiaBeholder entity = new EntityGaiaBeholder(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"END"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_BEHOLDER;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_SOUL_FIRE, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.WEAPON_BOOK_NIGHTMARE));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerBoneKnight() {
        EntityGaiaBoneKnight entity = new EntityGaiaBoneKnight(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.validUnderground, this.invalidUnderground);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_BONE_KNIGHT;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151137_ax, 0, 2, this.getDropChance(2, 3), false));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getUncommonDrop(Item.func_150898_a((Block)Blocks.field_150451_bX)));
            loot.add(this.getRareDrop(Items.field_151144_bL, 0));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerCecaelia() {
        EntityGaiaCecaelia entity = new EntityGaiaCecaelia(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"BEACH", "OCEAN", "RIVER"}, new String[]{"MUSHROOM"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_CECAELIA;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_PEARL, 0, 1, this.getDropChance(1, 2), true));
            loot.add(this.getCommonDrop(Items.field_151119_aD, 0, 1, this.getDropChance(1, 4), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            if (Enchantments.field_151370_z != null) {
                ItemStack enchantedBook = new ItemStack(Items.field_151134_bR);
                ItemEnchantedBook.func_92115_a((ItemStack)enchantedBook, (EnchantmentData)new EnchantmentData(Enchantments.field_151370_z, 1));
                loot.add(this.getRareDrop(enchantedBook));
            }
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerCobblestoneGolem() {
        EntityGaiaCobblestoneGolem entity = new EntityGaiaCobblestoneGolem(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"JUNGLE"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_COBBLESTONE_GOLEM;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_191525_da, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.CHEST, 1));
            loot.add(this.getRareDrop(GaiaItems.SHARD_MISC, 0));
            loot.add(this.getRareDrop(GaiaItems.WEAPON_BOOK_METAL));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerCreep() {
        EntityGaiaCreep entity = new EntityGaiaCreep(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.validUnderground, this.invalidUnderground);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_CREEP;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151016_H, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getRareDrop(GaiaItems.SPAWN_CREEPER_GIRL));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DOLL_CREEPER_GIRL));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
            GlStateManager.func_179137_b((double)0.0, (double)0.3, (double)0.0);
            return renderInfo;
        });
    }

    private void registerDeathword() {
        EntityGaiaDeathword entity = new EntityGaiaDeathword(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.validUnderground, this.invalidUnderground);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_DEATHWORD;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151121_aF, 1, 3, 1.0f, false));
            loot.add(this.getCommonDrop(Items.field_151122_aG, 0, 1, this.getDropChance(1, 4), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getRareDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.WEAPON_BOOK));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerDhampir() {
        EntityGaiaDhampir entity = new EntityGaiaDhampir(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"CONIFEROUS", "SNOWY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_DHAMPIR;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_SOUL_FIRE, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DOLL_MAID));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerDullahan() {
        EntityGaiaDullahan entity = new EntityGaiaDullahan(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"MOUNTAIN"}, new String[]{"COLD", "DENSE", "HOT"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_DULLAHAN;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_SOUL_FIRE, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DOLL_DULLAHAN));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerFleshLich() {
        EntityGaiaFleshLich entity = new EntityGaiaFleshLich(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.validUnderground, this.invalidUnderground);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_FLESH_LICH;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151100_aR, 4, 1, 3, 1.0f, false));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getUncommonDrop(Item.func_150898_a((Block)Blocks.field_150368_y)));
            loot.add(this.getRareDrop(Items.field_151144_bL, 2));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerGelatinousSlime() {
        EntityGaiaGelatinousSlime entity = new EntityGaiaGelatinousSlime(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SWAMP"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_GELATINOUS_SLIME;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151123_aH, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.SPAWN_SLIME_GIRL));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DOLL_SLIME_GIRL));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
            GlStateManager.func_179137_b((double)0.0, (double)0.15, (double)0.0);
            return renderInfo;
        });
    }

    private void registerGoblinFeral() {
        EntityGaiaGoblinFeral entity = new EntityGaiaGoblinFeral(this.world);
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP_SWORD_WOOD));
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.jerConfig.FERAL_GOBLIN);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_GOBLIN_FERAL_MELEE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getUncommonDrop(Items.field_191525_da));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerGoblinFeralBomber() {
        EntityGaiaGoblinFeral entity = new EntityGaiaGoblinFeral(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.jerConfig.FERAL_GOBLIN_BOMBER);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_GOBLIN_FERAL_BOMBER;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getUncommonDrop(Items.field_191525_da));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerGoblinFeralArcher() {
        EntityGaiaGoblinFeral entity = new EntityGaiaGoblinFeral(this.world);
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.jerConfig.FERAL_GOBLIN_ARCHER);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_GOBLIN_FERAL_RANGED;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getUncommonDrop(Items.field_191525_da));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerGravemite() {
        EntityGaiaMite entity = new EntityGaiaMite(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SANDY"}, new String[]{"MESA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MITE;
        this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
    }

    private void registerHarpy() {
        EntityGaiaHarpy entity = new EntityGaiaHarpy(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"PLAINS", "MESA"}, new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_HARPY;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151008_G, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DECO_NEST_HARPY));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerIllagerButler() {
        EntityGaiaIllagerButler entity = new EntityGaiaIllagerButler(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.jerConfig.ILLAGER_BUTLER);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_BUTLER;
        this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerIllagerFire() {
        EntityGaiaIllagerFire entity = new EntityGaiaIllagerFire(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.jerConfig.ILLAGER_INCINERATOR);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ILLAGER_FIRE;
        this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
    }

    private void registerIllagerInquisitor() {
        EntityGaiaIllagerInquisitor entity = new EntityGaiaIllagerInquisitor(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.jerConfig.ILLAGER_INQUISITOR);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ILLAGER_INQUISITOR;
        this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerKobold() {
        EntityGaiaKobold entity = new EntityGaiaKobold(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SNOWY"}, new String[]{"OCEAN", "RIVER", "BEACH", "FOREST"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_KOBOLD;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_FUR, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDrop(GaiaItems.BAG_ARROW));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerMimic() {
        EntityGaiaMimic entity = new EntityGaiaMimic(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(this.validUnderground, this.invalidUnderground);
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MIMIC;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getRareDrop(GaiaItems.FOOD_MONSTER_FEED_PREMIUM));
            loot.add(this.getRareDrop(GaiaItems.SPAWN_TRADER));
            loot.add(this.getRareDrop(GaiaItems.BAG_RECORD));
            loot.add(this.getRareDrop(GaiaItems.WEAPON_BOOK_HUNGER));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerMinotaur() {
        EntityGaiaMinotaur entity = new EntityGaiaMinotaur(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"PLAINS", "MESA"}, new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MINOTAUR;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_SMALL_APPLE_GOLD, 0, 1, this.getDropChance(1, 4), true));
            loot.add(this.getCommonDrop(this.unifyNugget(2), 1, 3, 1.0f, false));
            loot.add(this.getCommonDrop(this.unifyNugget(3), 1, 3, 1.0f, false));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_DIAMOND));
            loot.add(this.getRareDrop(GaiaItems.ACCESSORY_CURSED));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DECO_BUST_MINOTAUR));
            loot.add(this.getRareDrop(GaiaItems.MISC_RING, 1));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerMinotaurus() {
        EntityGaiaMinotaurus entity = new EntityGaiaMinotaurus(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"PLAINS", "MESA"}, new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MINOTAURUS;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151116_aA, 0, 3, this.getDropChance(3, 4), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.SPAWN_HOLSTAURUS));
            loot.add(this.getRareDrop(GaiaItems.WEAPON_BOOK_BATTLE));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerMinotaurusArcher() {
        EntityGaiaMinotaurus entity = new EntityGaiaMinotaurus(this.world);
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"PLAINS", "MESA"}, new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MINOTAURUS;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151032_g, 0, 3, this.getDropChance(3, 4), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.SPAWN_HOLSTAURUS));
            loot.add(this.getRareDrop(GaiaItems.BAG_ARROW));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerMummy() {
        EntityGaiaMummy entity = new EntityGaiaMummy(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SANDY"}, new String[]{"MESA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MUMMY;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151103_aS, 0, 1, this.getDropChance(1, 2), false));
            loot.add(this.getCommonDrop(Items.field_151078_bh, 0, 1, this.getDropChance(1, 2), false));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerNineTails() {
        EntityGaiaNineTails entity = new EntityGaiaNineTails(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"CONIFEROUS"}, new String[]{"SNOWY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_NINETAILS;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_SOUL_FIRE, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            ItemStack fanFire = new ItemStack(GaiaItems.WEAPON_FAN_FIRE);
            if (Enchantments.field_77334_n != null) {
                fanFire.func_77966_a(Enchantments.field_77334_n, 2);
            }
            if (Enchantments.field_180313_o != null) {
                fanFire.func_77966_a(Enchantments.field_180313_o, 1);
            }
            loot.add(this.getRareDrop(fanFire));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DOLL_NINE_TAILS));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerOni() {
        EntityGaiaOni entity = new EntityGaiaOni(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"CONIFEROUS"}, new String[]{"SNOWY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ONI;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_SOUL_FIRE, 0, 1, this.getDropChance(1, 4), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            if (Enchantments.field_185302_k != null) {
                ItemStack enchantedBook = new ItemStack(Items.field_151134_bR);
                enchantedBook.func_77966_a(Enchantments.field_185302_k, 1);
                loot.add(this.getRareDrop(enchantedBook));
            }
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerOrc() {
        EntityGaiaOrc entity = new EntityGaiaOrc(this.world);
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151049_t));
        entity.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(GaiaItems.SHIELD_PROP, 1, 1));
        entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151026_S));
        entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151027_R));
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ORC_MELEE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_MEAT, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerOrcRanged() {
        EntityGaiaOrc entity = new EntityGaiaOrc(this.world);
        entity.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(GaiaItems.WEAPON_PROP, 1, 0));
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SAVANNA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ORC_RANGED;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_MEAT, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDrop(GaiaItems.BAG_BOOK));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerShaman() {
        EntityGaiaShaman entity = new EntityGaiaShaman(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"JUNGLE"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SHAMAN;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_ROTTEN_HEART, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.MISC_BOOK));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerSharko() {
        EntityGaiaSharko entity = new EntityGaiaSharko(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"BEACH", "OCEAN", "RIVER"}, new String[]{"MUSHROOM"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SHARKO;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_PEARL, 0, 2, this.getDropChance(2, 3), true));
            loot.add(this.getCommonDrop(Items.field_179562_cC, 0, 1, this.getDropChance(1, 4), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 0));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.BOOK_BUFF));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerSludgeGirl() {
        EntityGaiaSludgeGirl entity = new EntityGaiaSludgeGirl(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SWAMP"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SLUDGE_GIRL;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151123_aH, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerSphinx() {
        EntityGaiaSphinx entity = new EntityGaiaSphinx(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SANDY"}, new String[]{"MESA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SPHINX;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_SMALL_APPLE_GOLD, 0, 1, this.getDropChance(1, 4), true));
            loot.add(this.getCommonDrop(this.unifyNugget(2), 1, 3, 1.0f, false));
            loot.add(this.getCommonDrop(this.unifyNugget(3), 1, 3, 1.0f, false));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_DIAMOND));
            loot.add(this.getRareDecoDrop(GaiaBlocks.BUST_SPHINX));
            loot.add(this.getRareDrop(GaiaItems.MISC_RING, 2));
            loot.add(this.getRareDrop(GaiaItems.CHEST, 2));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerSporeling() {
        EntityGaiaSporeling entity = new EntityGaiaSporeling(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SPORELING;
        this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
            return renderInfo;
        });
    }

    private void registerSpriggan() {
        EntityGaiaSpriggan entity = new EntityGaiaSpriggan(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"DENSE", "FOREST", "RARE"}, new String[]{"CONIFEROUS", "COLD", "HOT", "SPARSE", "SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SPRIGGAN;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_ROOT, 0, 2, this.getDropChance(2, 3), true));
            loot.add(this.getCommonDrop(Item.func_150898_a((Block)Blocks.field_150364_r), 0, 1, this.getDropChance(1, 2), false, JEMConditional.killedWithAxe));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.WEAPON_BOOK_NATURE));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerSuccubus() {
        EntityGaiaSuccubus entity = new EntityGaiaSuccubus(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"NETHER"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SUCCUBUS;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_SOUL_FIERY, 0, 1, this.getDropChance(1, 2), true));
            loot.add(this.getCommonDrop(Items.field_151128_bU, 0, 1, this.getDropChance(1, 8), true));
            loot.add(this.getCommonDrop(Items.field_151114_aO, 0, 1, this.getDropChance(1, 8), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 1));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerVampire() {
        EntityGaiaVampire entity = new EntityGaiaVampire(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"CONIFEROUS", "SNOWY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_VAMPIRE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_SMALL_APPLE_GOLD, 0, 1, this.getDropChance(1, 4), true));
            loot.add(this.getCommonDrop(this.unifyNugget(2), 1, 3, 1.0f, false));
            loot.add(this.getCommonDrop(this.unifyNugget(3), 1, 3, 1.0f, false));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_DIAMOND));
            loot.add(this.getRareDecoDrop(GaiaBlocks.BUST_VAMPIRE));
            loot.add(this.getRareDrop(GaiaItems.MISC_RING, 3));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)1.3, (double)1.3, (double)1.3);
            GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)0.0);
            return renderInfo;
        });
    }

    private void registerWerecat() {
        EntityGaiaWerecat entity = new EntityGaiaWerecat(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"DENSE", "FOREST", "RARE"}, new String[]{"CONIFEROUS", "COLD", "HOT", "SPARSE", "SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_WERECAT;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_MEAT, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerWitch() {
        EntityGaiaWitch entity = new EntityGaiaWitch(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_WITCH;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_NETHER_WART, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.MISC_BOOK));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DECO_MANDRAGORA_POT));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerWitherCow() {
        EntityGaiaWitherCow entity = new EntityGaiaWitherCow(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"NETHER"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_WITHER_COW;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_WITHER, 0, 1, this.getDropChance(1, 2), true));
            loot.add(this.getCommonDrop(Items.field_151128_bU, 0, 1, this.getDropChance(1, 8), true));
            loot.add(this.getCommonDrop(Items.field_151114_aO, 0, 1, this.getDropChance(1, 8), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX, 1));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerYeti() {
        EntityGaiaYeti entity = new EntityGaiaYeti(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SNOWY"}, new String[]{"OCEAN", "RIVER", "BEACH", "FOREST"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_YETI;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_FUR, 0, 2, this.getDropChance(2, 3), true));
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            loot.add(this.getRareDrop(GaiaItems.WEAPON_BOOK_FREEZING));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.hostile, spawnBiomes, lootTable);
        }
    }

    private void registerAnt() {
        EntityGaiaAnt entity = new EntityGaiaAnt(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SANDY"}, new String[]{"MESA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ANT;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151100_aR, 2, 0, 1, this.getDropChance(1, 2), true));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_HONEY, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerAntRanger() {
        EntityGaiaAntRanger entity = new EntityGaiaAntRanger(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SANDY"}, new String[]{"MESA"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_ANT_RANGER;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_MEAT, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            if (Enchantments.field_185304_p != null) {
                ItemStack enchantedBook = new ItemStack(Items.field_151134_bR);
                ItemEnchantedBook.func_92115_a((ItemStack)enchantedBook, (EnchantmentData)new EnchantmentData(Enchantments.field_185304_p, 1));
                loot.add(this.getRareDrop(enchantedBook));
            }
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)0.0, (double)1.0, (double)0.0);
            return renderInfo;
        });
    }

    private void registerMandragora() {
        EntityGaiaMandragora entity = new EntityGaiaMandragora(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"CONIFEROUS", "DENSE", "FOREST", "RARE"}, new String[]{"CONIFEROUS", "COLD", "HOT", "SNOWY", "SPARSE", "SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MANDRAGORA;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.FOOD_ROOT, 0, 1, this.getDropChance(1, 2), true, JEMConditional.killedWithShovel));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDecoDrop(GaiaBlocks.DECO_GARDEN_GNOME));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)1.3, (double)1.3, (double)1.3);
            GlStateManager.func_179137_b((double)0.0, (double)0.25, (double)0.0);
            return renderInfo;
        });
    }

    private void registerMatango() {
        EntityGaiaMatango entity = new EntityGaiaMatango(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_MATANGO;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerNaga() {
        EntityGaiaNaga entity = new EntityGaiaNaga(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SWAMP"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_NAGA;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            LootDrop fishDrop = this.getCommonDrop(Items.field_151115_aP, 0, 2, this.getDropChance(2, 3), true);
            fishDrop.smeltedItem = new ItemStack(Items.field_179566_aV);
            loot.add(fishDrop);
            loot.addAll(this.getNuggetDrops(Items.field_151074_bl));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_GOLD));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_BOOK));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
    }

    private void registerSelkie() {
        EntityGaiaSelkie entity = new EntityGaiaSelkie(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SNOWY"}, new String[]{"OCEAN", "RIVER", "BEACH", "FOREST"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SELKIE;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(GaiaItems.MISC_FUR, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_ARROW));
            if (Enchantments.field_151369_A != null) {
                ItemStack enchantedBook = new ItemStack(Items.field_151134_bR);
                ItemEnchantedBook.func_92115_a((ItemStack)enchantedBook, (EnchantmentData)new EnchantmentData(Enchantments.field_151369_A, 1));
                loot.add(this.getRareDrop(enchantedBook));
            }
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerSiren() {
        EntityGaiaSiren entity = new EntityGaiaSiren(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SWAMP"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_SIREN;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            LootDrop fishDrop = this.getCommonDrop(Items.field_151115_aP, 0, 1, this.getDropChance(1, 2), true);
            fishDrop.smeltedItem = new ItemStack(Items.field_179566_aV);
            loot.add(fishDrop);
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getUncommonDrop(GaiaItems.BAG_ARROW));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.adjustHumanoidRenderHook(entity.getClass());
    }

    private void registerToad() {
        EntityGaiaToad entity = new EntityGaiaToad(this.world);
        String[] spawnBiomes = BiomeHelper.getBiomeNames(new String[]{"SPOOKY"});
        ResourceLocation lootTable = GaiaLootTables.ENTITIES_GAIA_TOAD;
        if (!GaiaConfig.OPTIONS.disableDrops) {
            List loot = LootTableHelper.toDrops((LootTable)this.manager.func_186521_a(lootTable));
            loot.add(this.getCommonDrop(Items.field_151123_aH, 0, 1, this.getDropChance(1, 2), true));
            loot.addAll(this.getNuggetDrops(Items.field_191525_da));
            loot.add(this.getUncommonDrop(GaiaItems.BOX_IRON));
            loot.add(this.getRareDrop(GaiaItems.ACCESSORY_TRINKET_POISON));
            LootDrop[] drops = loot.toArray(new LootDrop[0]);
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, drops);
        } else {
            this.registerMob((EntityLivingBase)entity, LightLevel.any, spawnBiomes, lootTable);
        }
        this.registerRenderHook(entity.getClass(), (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
            GlStateManager.func_179137_b((double)0.0, (double)0.25, (double)0.0);
            return renderInfo;
        });
    }

    private float getDropChance(int min, int max) {
        float chance = (float)min / (float)max;
        return Float.parseFloat(String.format("%.2f", Float.valueOf(chance)));
    }

    private LootDrop getCommonDrop(Item drop, int minDrop, int maxDrop, float chance, boolean affectedByLooting) {
        if (affectedByLooting) {
            return new LootDrop(drop, minDrop, maxDrop, chance, new Conditional[]{Conditional.affectedByLooting});
        }
        return new LootDrop(drop, minDrop, maxDrop, chance, new Conditional[0]);
    }

    private LootDrop getCommonDrop(Item drop, int meta, int minDrop, int maxDrop, float chance, boolean affectedByLooting) {
        if (affectedByLooting) {
            return new LootDrop(drop, meta, minDrop, maxDrop, chance, new Conditional[]{Conditional.affectedByLooting});
        }
        return new LootDrop(drop, meta, minDrop, maxDrop, chance, new Conditional[0]);
    }

    private LootDrop getCommonDrop(Item drop, int minDrop, int maxDrop, float chance, boolean affectedByLooting, Conditional conditional) {
        if (affectedByLooting) {
            return new LootDrop(drop, minDrop, maxDrop, chance, new Conditional[]{Conditional.affectedByLooting, conditional});
        }
        return new LootDrop(drop, minDrop, maxDrop, chance, new Conditional[]{conditional});
    }

    private LootDrop getCommonDrop(ItemStack stack, int minDrop, int maxDrop, float chance, boolean affectedByLooting) {
        if (affectedByLooting) {
            return new LootDrop(stack, minDrop, maxDrop, chance, new Conditional[]{Conditional.affectedByLooting});
        }
        return new LootDrop(stack, minDrop, maxDrop, chance, new Conditional[0]);
    }

    private List<LootDrop> getNuggetDrops(Item nugget) {
        ArrayList<LootDrop> loot = new ArrayList<LootDrop>();
        loot.add(new LootDrop(nugget, 1, 3, 1.0f, new Conditional[0]));
        if (GaiaConfig.OPTIONS.additionalOre) {
            if (nugget.equals(Items.field_151074_bl)) {
                loot.add(new LootDrop(this.unifyNugget(5), 1, 3, 1.0f, new Conditional[0]));
            } else {
                loot.add(new LootDrop(this.unifyNugget(4), 1, 3, 1.0f, new Conditional[0]));
            }
        }
        return loot;
    }

    private ItemStack unifyNugget(int meta) {
        ItemStack stack;
        String oreDict = "";
        switch (meta) {
            case 0: {
                oreDict = "nuggetIron";
                break;
            }
            case 1: {
                oreDict = "nuggetGold";
                break;
            }
            case 2: {
                oreDict = "nuggetDiamond";
                break;
            }
            case 3: {
                oreDict = "nuggetEmerald";
                break;
            }
            case 4: {
                oreDict = "nuggetCopper";
                break;
            }
            case 5: {
                oreDict = "nuggetSilver";
            }
        }
        NonNullList oreEquivalents = OreDictionary.getOres((String)oreDict);
        if (!oreEquivalents.isEmpty() && !((ItemStack)oreEquivalents.get(0)).func_190926_b()) {
            ItemStack unity = (ItemStack)oreEquivalents.get(0);
            Item item = unity.func_77973_b();
            int newMeta = unity.func_77952_i();
            stack = new ItemStack(item, 1, newMeta);
        } else {
            stack = new ItemStack(GaiaItems.SHARD, 1, meta);
        }
        return stack;
    }

    private LootDrop getUncommonDrop(Item drop) {
        return new LootDrop(drop, 0, 1, 0.025f, new Conditional[]{Conditional.rareDrop});
    }

    private LootDrop getUncommonDrop(Item drop, int meta) {
        return new LootDrop(drop, meta, 0, 1, 0.025f, new Conditional[]{Conditional.rareDrop});
    }

    private LootDrop getRareDecoDrop(Block decoBlock) {
        return new LootDrop(Item.func_150898_a((Block)decoBlock), 0, 1, 0.01f, new Conditional[]{Conditional.rareDrop});
    }

    private LootDrop getRareDrop(Item drop) {
        return new LootDrop(drop, 0, 1, 0.01f, new Conditional[]{Conditional.rareDrop});
    }

    private LootDrop getRareDrop(Item drop, int meta) {
        return new LootDrop(drop, meta, 0, 1, 0.01f, new Conditional[]{Conditional.rareDrop});
    }

    private LootDrop getRareDrop(ItemStack drop) {
        return new LootDrop(drop, 0, 1, 0.01f, new Conditional[]{Conditional.rareDrop});
    }

    private void adjustHumanoidRenderHook(Class<? extends EntityLiving> clazz) {
        this.registerRenderHook(clazz, (renderInfo, entity) -> {
            GlStateManager.func_179137_b((double)0.0, (double)0.15, (double)0.0);
            return renderInfo;
        });
    }
}

