/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigMinecraft;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.CustomPlantRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.Reference;
import java.util.List;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import jeresources.util.LootTableHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.IPlantable;

public class JERMinecraft
extends JERBase
implements IJERIntegration {
    private JEMConfigMinecraft.JER jerConfig;

    public JERMinecraft(boolean enableJERMobs, boolean enableJERPlants) {
        this.jerConfig = JEMConfig.MINECRAFT.JUST_ENOUGH_RESOURCES;
        if (enableJERMobs) {
            this.registerModEntities();
        }
        if (enableJERPlants) {
            this.registerModPlants();
        }
    }

    @Override
    public void registerModEntities() {
        if (this.jerConfig.JER_MOBS.enablePolarBear) {
            this.registerMob((EntityLivingBase)new EntityPolarBear(this.world), LightLevel.any, 1, 3, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76774_n, Biomes.field_185445_W), LootTableList.field_189969_E);
        }
        if (this.jerConfig.JER_MOBS.enableWither) {
            List drops = LootTableHelper.toDrops((World)this.world, (ResourceLocation)Reference.FakeTables.WITHER_FAKE_TABLE);
            this.registerMob((EntityLivingBase)new EntityWither(this.world), LightLevel.any, drops.toArray(new LootDrop[0]));
        }
    }

    @Override
    public void registerModPlants() {
        CustomPlantRegistry registry = CustomPlantRegistry.getInstance();
        if (this.jerConfig.JER_PLANTS.enableBeetroot && Items.field_185163_cU instanceof IPlantable) {
            registry.registerPlant(new PlantEntry((Item)((IPlantable)Items.field_185163_cU), new PlantDrop[]{new PlantDrop(new ItemStack(Items.field_185163_cU), 0, 3), new PlantDrop(new ItemStack(Items.field_185164_cV), 1, 1)}));
        }
        if (this.jerConfig.JER_PLANTS.enableNetherWart && Items.field_151075_bm instanceof IPlantable) {
            PlantEntry netherWart = new PlantEntry((Item)((IPlantable)Items.field_151075_bm), new PlantDrop[]{new PlantDrop(new ItemStack(Items.field_151075_bm), 2, 4)});
            netherWart.setSoil(Blocks.field_150425_aM.func_176223_P());
            registry.registerPlant(netherWart);
        }
    }
}

