/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.bobmowzie.mowziesmobs.server.block.BlockHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoana;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.MaskType;
import com.bobmowzie.mowziesmobs.server.entity.foliaath.EntityFoliaath;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.entity.grottol.EntityGrottol;
import com.bobmowzie.mowziesmobs.server.entity.lantern.EntityLantern;
import com.bobmowzie.mowziesmobs.server.entity.naga.EntityNaga;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigMowziesMobs;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.BasicTrade;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.CustomVillagerEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.CustomVillagerRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class JERMowziesMobs
extends JERBase
implements IJERIntegration {
    JEMConfigMowziesMobs.JER jerConfig;

    public JERMowziesMobs(boolean enableJERMobs, boolean enableJERVillagers) {
        this.jerConfig = JEMConfig.MOWZIES_MOBS.JUST_ENOUGH_RESOURCES;
        if (enableJERMobs) {
            this.registerModEntities();
        }
        if (enableJERVillagers) {
            this.registerModVillagers();
        }
    }

    @Override
    public void registerModEntities() {
        LightLevel spawnLight;
        LightLevel spawnLight2;
        if (this.jerConfig.JER_MOBS.enableBarako) {
            this.registerMob((EntityLivingBase)new EntityBarako(this.world), LightLevel.any, this.getSpawnBiomes(ConfigHandler.MOBS.BARAKO.generationData.biomeData), LootTableHandler.BARAKO);
            this.registerRenderHook(EntityBarako.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.3, (double)0.0);
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableBarakoBliss) {
            EntityBarakoana bliss = new EntityBarakoana(this.world);
            bliss.setMask(MaskType.BLISS);
            spawnLight2 = ConfigHandler.MOBS.BARAKOA.spawnData.needsDarkness ? LightLevel.hostile : LightLevel.any;
            this.registerMob((EntityLivingBase)bliss, spawnLight2, this.getSpawnBiomes(ConfigHandler.MOBS.BARAKOA.spawnData.biomeData), LootTableHandler.BARAKOA_FEAR);
        }
        if (this.jerConfig.JER_MOBS.enableBarakoFear) {
            EntityBarakoana fear = new EntityBarakoana(this.world);
            fear.setMask(MaskType.FEAR);
            spawnLight2 = ConfigHandler.MOBS.BARAKOA.spawnData.needsDarkness ? LightLevel.hostile : LightLevel.any;
            this.registerMob((EntityLivingBase)fear, spawnLight2, this.getSpawnBiomes(ConfigHandler.MOBS.BARAKOA.spawnData.biomeData), LootTableHandler.BARAKOA_FEAR);
        }
        if (this.jerConfig.JER_MOBS.enableBarakoFury) {
            EntityBarakoana fury = new EntityBarakoana(this.world);
            fury.setMask(MaskType.FURY);
            spawnLight2 = ConfigHandler.MOBS.BARAKOA.spawnData.needsDarkness ? LightLevel.hostile : LightLevel.any;
            this.registerMob((EntityLivingBase)fury, spawnLight2, this.getSpawnBiomes(ConfigHandler.MOBS.BARAKOA.spawnData.biomeData), LootTableHandler.BARAKOA_FEAR);
        }
        if (this.jerConfig.JER_MOBS.enableBarakoMisery) {
            EntityBarakoana misery = new EntityBarakoana(this.world);
            misery.setMask(MaskType.MISERY);
            spawnLight2 = ConfigHandler.MOBS.BARAKOA.spawnData.needsDarkness ? LightLevel.hostile : LightLevel.any;
            this.registerMob((EntityLivingBase)misery, spawnLight2, this.getSpawnBiomes(ConfigHandler.MOBS.BARAKOA.spawnData.biomeData), LootTableHandler.BARAKOA_FEAR);
        }
        if (this.jerConfig.JER_MOBS.enableBarakoRage) {
            EntityBarakoana rage = new EntityBarakoana(this.world);
            rage.setMask(MaskType.RAGE);
            spawnLight2 = ConfigHandler.MOBS.BARAKOA.spawnData.needsDarkness ? LightLevel.hostile : LightLevel.any;
            this.registerMob((EntityLivingBase)rage, spawnLight2, this.getSpawnBiomes(ConfigHandler.MOBS.BARAKOA.spawnData.biomeData), LootTableHandler.BARAKOA_FEAR);
        }
        if (this.jerConfig.JER_MOBS.enableFerrousWroughtnaut) {
            this.registerMob((EntityLivingBase)new EntityWroughtnaut(this.world), LightLevel.any, this.getSpawnBiomes(ConfigHandler.MOBS.FERROUS_WROUGHTNAUT.generationData.biomeData), LootTableHandler.FERROUS_WROUGHTNAUT);
            this.registerRenderHook(EntityWroughtnaut.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
                GlStateManager.func_179137_b((double)-0.1, (double)-0.8, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableFoliaath) {
            spawnLight = ConfigHandler.MOBS.FOLIAATH.spawnData.needsDarkness ? LightLevel.hostile : LightLevel.any;
            this.registerMob((EntityLivingBase)new EntityFoliaath(this.world), spawnLight, this.getSpawnBiomes(ConfigHandler.MOBS.FOLIAATH.spawnData.biomeData), LootTableHandler.FOLIAATH);
            this.registerRenderHook(EntityFoliaath.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.5, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableFrostmaw) {
            this.registerMob((EntityLivingBase)new EntityFrostmaw(this.world), LightLevel.any, this.getSpawnBiomes(ConfigHandler.MOBS.FROSTMAW.generationData.biomeData), LootTableHandler.FROSTMAW);
            this.registerRenderHook(EntityFrostmaw.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.4, (double)-1.25, (double)0.0);
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableGrottol) {
            spawnLight = ConfigHandler.MOBS.GROTTOL.spawnData.needsDarkness ? LightLevel.hostile : LightLevel.any;
            this.registerMob((EntityLivingBase)new EntityGrottol(this.world), spawnLight, this.getSpawnBiomes(ConfigHandler.MOBS.GROTTOL.spawnData.biomeData), LootTableHandler.GROTTOL);
            this.registerRenderHook(EntityGrottol.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.4, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableLantern) {
            spawnLight = ConfigHandler.MOBS.LANTERN.spawnData.needsDarkness ? LightLevel.hostile : LightLevel.any;
            this.registerMob((EntityLivingBase)new EntityLantern(this.world), spawnLight, this.getSpawnBiomes(ConfigHandler.MOBS.LANTERN.spawnData.biomeData), LootTableHandler.LANTERN);
            this.registerRenderHook(EntityLantern.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.2, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableNaga) {
            spawnLight = ConfigHandler.MOBS.NAGA.spawnData.needsDarkness ? LightLevel.hostile : LightLevel.any;
            this.registerMob((EntityLivingBase)new EntityNaga(this.world), spawnLight, this.getSpawnBiomes(ConfigHandler.MOBS.NAGA.spawnData.biomeData), LootTableHandler.NAGA);
            this.registerRenderHook(EntityNaga.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
                GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                return renderInfo;
            });
        }
    }

    @Override
    public void registerModVillagers() {
        ArrayList<ArrayList<BasicTrade>> allTrades;
        ArrayList<BasicTrade> trades;
        if (this.jerConfig.JER_VILLAGERS.enableBarako) {
            trades = new ArrayList<BasicTrade>();
            trades.add(new BasicTrade(new ItemStack((Item)ItemHandler.GRANT_SUNS_BLESSING, 1), new ItemStack(Blocks.field_150340_R, 7)));
            allTrades = new ArrayList<ArrayList<BasicTrade>>(1);
            allTrades.add(trades);
            final EntityBarako barako = new EntityBarako(this.world);
            CustomVillagerRegistry.getInstance().addVillagerEntry(new CustomVillagerEntry(barako.func_70005_c_(), 0, allTrades){

                @Override
                public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                    return barako;
                }

                @Override
                public String getDisplayName() {
                    return barako.func_145748_c_().func_150254_d();
                }
            });
        }
        if (this.jerConfig.JER_VILLAGERS.enableBarakoana) {
            trades = new ArrayList();
            trades.add(new BasicTrade(new ItemStack((Item)ItemHandler.BLOWGUN, 1), new ItemStack(Items.field_151043_k, 2)));
            trades.add(new BasicTrade(new ItemStack((Item)ItemHandler.DART, 8), new ItemStack(Items.field_151100_aR, 10, EnumDyeColor.BROWN.func_176767_b())));
            trades.add(new BasicTrade(new ItemStack((Item)ItemHandler.SPEAR, 1), new ItemStack(Items.field_151043_k, 3)));
            trades.add(new BasicTrade(new ItemStack(Item.func_150898_a((Block)BlockHandler.PAINTED_ACACIA), 2), new ItemStack(Items.field_151074_bl, 5)));
            trades.add(new BasicTrade(new ItemStack(Item.func_150898_a((Block)BlockHandler.PAINTED_ACACIA), 1), new ItemStack(Items.field_151100_aR, 16, EnumDyeColor.BROWN.func_176767_b())));
            trades.add(new BasicTrade(new ItemStack(Items.field_151077_bg, 2), new ItemStack(Items.field_151100_aR, 10, EnumDyeColor.BROWN.func_176767_b())));
            trades.add(new BasicTrade(new ItemStack(Items.field_151077_bg, 1), new ItemStack(Items.field_151074_bl, 8)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151157_am, 2), new ItemStack(Items.field_151100_aR, 14, EnumDyeColor.BROWN.func_176767_b())));
            trades.add(new BasicTrade(new ItemStack(Items.field_151157_am, 1), new ItemStack(Items.field_151074_bl, 9)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151074_bl, 5), new ItemStack(Items.field_151127_ba, 3)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151074_bl, 3), new ItemStack(Items.field_151076_bf, 1)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151043_k, 2), new ItemStack(Items.field_151040_l, 1)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151043_k, 4), new ItemStack((Item)Items.field_151028_Y, 1)));
            allTrades = new ArrayList(1);
            allTrades.add(trades);
            final EntityBarakoana trader = new EntityBarakoana(this.world);
            trader.setMask(MaskType.FURY);
            CustomVillagerRegistry.getInstance().addVillagerEntry(new CustomVillagerEntry(trader.toString(), 0, allTrades){

                @Override
                public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                    return trader;
                }

                @Override
                public String getDisplayName() {
                    return trader.func_145748_c_().func_150254_d();
                }
            });
        }
    }

    private String[] getSpawnBiomes(ConfigHandler.BiomeData biomeData) {
        String[] stringArray;
        ArrayList<String> spawnBiomes = new ArrayList<String>();
        spawnBiomes.addAll(Arrays.asList(BiomeHelper.getBiomeNamesForTypes(biomeData.biomeTypes)));
        spawnBiomes.addAll(Arrays.asList(BiomeHelper.getBiomeNamesForBiomes(biomeData.biomeWhitelist)));
        spawnBiomes.removeAll(Arrays.asList(BiomeHelper.getBiomeNamesForBiomes(biomeData.biomeBlacklist)));
        if (spawnBiomes.size() > 0) {
            stringArray = spawnBiomes.toArray(new String[0]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "jer.any";
        }
        return stringArray;
    }
}

