/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityBlackDeath;
import com.github.alexthe666.rats.server.entity.EntityFeralRatlantean;
import com.github.alexthe666.rats.server.entity.EntityIllagerPiper;
import com.github.alexthe666.rats.server.entity.EntityMarbleCheeseGolem;
import com.github.alexthe666.rats.server.entity.EntityNeoRatlantean;
import com.github.alexthe666.rats.server.entity.EntityPirat;
import com.github.alexthe666.rats.server.entity.EntityPlagueBeast;
import com.github.alexthe666.rats.server.entity.EntityPlagueDoctor;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntityRatlanteanSpirit;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.world.RatsWorldRegistry;
import com.github.alexthe666.rats.server.world.village.RatsVillageRegistry;
import com.github.alexthe666.rats.server.world.village.WorldGenPetShop;
import com.github.alexthe666.rats.server.world.village.WorldGenPlagueDoctor;
import com.invadermonky.justenoughmagiculture.client.render.entity.mods.rats.JERRenderPirat;
import com.invadermonky.justenoughmagiculture.client.render.entity.mods.rats.JERRenderRat;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigRats;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.CustomVanillaVillagerEntry;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.CustomVillagerEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.CustomVillagerRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nonnull;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public class JERRats
extends JERBase
implements IJERIntegration {
    private static JERRats instance;
    JEMConfigRats.JER jerConfig;

    private JERRats() {
        this.jerConfig = JEMConfig.RATS.JUST_ENOUGH_RESOURCES;
    }

    public JERRats(boolean enableJERDungeons, boolean enableJERMobs) {
        this.jerConfig = JEMConfig.RATS.JUST_ENOUGH_RESOURCES;
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
        this.registerModVillagers();
        JERRats.getInstance();
    }

    public static JERRats getInstance() {
        return instance != null ? instance : (instance = new JERRats());
    }

    @Override
    public void registerModDungeons() {
        this.registerRatsDungeon("pet_shop", WorldGenPetShop.LOOT);
        this.registerRatsDungeon("pet_shop_upstairs", WorldGenPetShop.UPSTAIRS_LOOT);
        this.registerRatsDungeon("plague_doctor_house", WorldGenPlagueDoctor.LOOT);
    }

    @Override
    public void registerModEntities() {
        String[] stringArray;
        if (!RatsMod.CONFIG_OPTIONS.disableRatlantis) {
            stringArray = BiomeHelper.getBiomeNamesForBiomes(RatsWorldRegistry.RATLANTIS_BIOME);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "None";
        }
        String[] ratlantisBiome = stringArray;
        if (this.jerConfig.enableBlackDeath) {
            this.registerMob((EntityLivingBase)new EntityBlackDeath(this.world), LightLevel.hostile, EntityBlackDeath.LOOT);
            this.adjustHumanoidRenderHook(EntityBlackDeath.class);
        }
        if (this.jerConfig.enableFeralRatlantean) {
            this.registerMob((EntityLivingBase)new EntityFeralRatlantean(this.world), LightLevel.hostile, ratlantisBiome, EntityFeralRatlantean.LOOT);
        }
        if (this.jerConfig.enableIllagerPiper) {
            EntityIllagerPiper piper = new EntityIllagerPiper(this.world);
            piper.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(RatsItemRegistry.RAT_FLUTE));
            this.registerMob((EntityLivingBase)piper, LightLevel.hostile, EntityIllagerPiper.LOOT);
            this.adjustHumanoidRenderHook(piper.getClass());
        }
        if (this.jerConfig.enableRatlanteanAutomation) {
            this.registerMob((EntityLivingBase)new EntityMarbleCheeseGolem(this.world), LightLevel.any, EntityMarbleCheeseGolem.LOOT);
            this.registerRenderHook(EntityMarbleCheeseGolem.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-1.1, (double)0.0);
                GlStateManager.func_179139_a((double)0.8, (double)0.8, (double)0.8);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableNeoRatlantean) {
            this.registerMob((EntityLivingBase)new EntityNeoRatlantean(this.world), LightLevel.any, EntityNeoRatlantean.LOOT);
        }
        if (this.jerConfig.enablePirat) {
            EntityPirat pirat = new EntityPirat(this.world);
            pirat.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(RatsItemRegistry.PIRAT_CUTLASS));
            pirat.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(RatsItemRegistry.PIRAT_HAT));
            this.registerMob((EntityLivingBase)pirat, LightLevel.any, EntityPirat.LOOT);
        }
        if (this.jerConfig.enablePlagueBeast) {
            this.registerMob((EntityLivingBase)new EntityPlagueBeast(this.world), LightLevel.any, EntityPlagueBeast.LOOT);
        }
        if (this.jerConfig.enablePlagueDoctor) {
            this.registerMob((EntityLivingBase)new EntityPlagueDoctor(this.world), LightLevel.any, EntityPlagueDoctor.LOOT);
            this.adjustHumanoidRenderHook(EntityPlagueDoctor.class);
        }
        if (this.jerConfig.enableRat) {
            EntityRat rat = new EntityRat(this.world);
            this.registerMob((EntityLivingBase)rat, LightLevel.any, EntityRat.LOOT);
        }
        if (this.jerConfig.enableRatlanteanSpirit) {
            this.registerMob((EntityLivingBase)new EntityRatlanteanSpirit(this.world), LightLevel.hostile, ratlantisBiome, EntityRatlanteanSpirit.LOOT);
        }
    }

    @Override
    public void registerModVillagers() {
        if (JEMConfig.RATS.fixJERVillagers) {
            this.registerPetShopOwner();
            this.registerPlagueDoctorVillager();
        }
    }

    public void registerRenderOverrides() {
        if (JEMConfig.RATS.enableRenderFixes) {
            RenderingRegistry.registerEntityRenderingHandler(EntityRat.class, (Render)new JERRenderRat(Minecraft.func_71410_x().func_175598_ae()));
            RenderingRegistry.registerEntityRenderingHandler(EntityPirat.class, (Render)new JERRenderPirat(Minecraft.func_71410_x().func_175598_ae()));
        }
    }

    private void registerPetShopOwner() {
        try {
            final EntityVillager villager = new EntityVillager(this.world);
            villager.setProfession(RatsVillageRegistry.PET_SHOP_OWNER);
            villager.func_70946_n();
            VillagerRegistry.VillagerCareer career = RatsVillageRegistry.PET_SHOP_OWNER.getCareer(0);
            Field tradesField = career.getClass().getDeclaredField("trades");
            tradesField.setAccessible(true);
            List trades = (List)tradesField.get(career);
            CustomVillagerRegistry.getInstance().addVillagerEntry(new CustomVanillaVillagerEntry(RatsVillageRegistry.PET_SHOP_OWNER.getRegistryName().toString(), 0, trades){

                @Override
                public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                    return villager;
                }
            });
        }
        catch (Exception e) {
            LogHelper.warn("Failed to register Pet Shop Owner villager.");
            e.printStackTrace();
        }
    }

    private void registerPlagueDoctorVillager() {
        try {
            VillagerRegistry.VillagerCareer career = RatsVillageRegistry.PLAGUE_DOCTOR.getCareer(0);
            Field tradesField = career.getClass().getDeclaredField("trades");
            tradesField.setAccessible(true);
            List trades = (List)tradesField.get(career);
            CustomVillagerRegistry.getInstance().addVillagerEntry(new CustomVillagerEntry(RatsVillageRegistry.PLAGUE_DOCTOR.getRegistryName().toString(), 0, trades){

                @Override
                public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                    return new EntityPlagueDoctor(JERRats.this.world);
                }
            });
        }
        catch (Exception e) {
            LogHelper.warn("Failed to register Plague Doctor villager.");
            e.printStackTrace();
        }
    }

    private void adjustHumanoidRenderHook(Class<? extends EntityLiving> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.45, (double)0.0);
            return renderInfo;
        });
    }

    private void registerRatsDungeon(String name, ResourceLocation lootTable) {
        JERDungeonStrings dungeon = new JERDungeonStrings(name);
        this.registerDungeonLoot(dungeon.category, dungeon.unlocName, lootTable);
    }

    private static class JERDungeonStrings {
        public final String category;
        public final String unlocName;

        public JERDungeonStrings(String name) {
            this.category = ModIds.RATS.MOD_ID + ":" + name;
            this.unlocName = StringHelper.getDungeonTranslationKey(ModIds.RATS.MOD_ID, name);
        }
    }
}

