/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.google.common.collect.Sets;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import fathertoast.specialmobs.bestiary.EnumMobFamily;
import gnu.trove.set.hash.THashSet;
import java.util.Collection;
import java.util.List;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.util.LootTableHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class JERSpecialMobs
extends JERBase
implements IJERIntegration {
    public JERSpecialMobs(boolean enableJERMobs) {
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    @Override
    public void registerModEntities() {
        THashSet disabledMobs = new THashSet((Collection)Sets.newHashSet((Object[])JEMConfig.SPECIAL_MOBS.JUST_ENOUGH_RESOURCES.disableMobs));
        for (EnumMobFamily mobFamily : EnumMobFamily.values()) {
            for (EnumMobFamily.Species variant : mobFamily.variants) {
                try {
                    if (disabledMobs.contains((Object)variant.unlocalizedName)) continue;
                    EntityLiving entity = (EntityLiving)variant.constructor.newInstance(this.world);
                    ResourceLocation lootTable = new ResourceLocation(ModIds.SPECIAL_MOBS.MOD_ID, "entities/" + variant.family.name.toLowerCase() + "/" + variant.name.toLowerCase());
                    List drops = LootTableHelper.toDrops((World)this.world, (ResourceLocation)lootTable);
                    if (variant.bestiaryInfo.weight > 0) {
                        this.registerMob((EntityLivingBase)entity, LightLevel.hostile, drops.toArray(new LootDrop[0]));
                    }
                    if (variant.name.equals("Mini")) {
                        this.registerRenderHook(variant.variantClass, (renderInfo, e) -> {
                            GlStateManager.func_179139_a((double)0.4, (double)0.4, (double)0.4);
                            return renderInfo;
                        });
                        continue;
                    }
                    if (variant.name.equals("Giant")) {
                        this.registerRenderHook(variant.variantClass, (renderInfo, e) -> {
                            GlStateManager.func_179139_a((double)1.6, (double)1.6, (double)1.6);
                            return renderInfo;
                        });
                        continue;
                    }
                    if (!variant.unlocalizedName.equals("FighterGhast") && !variant.unlocalizedName.equals("UnholyGhast")) continue;
                    this.registerRenderHook(variant.variantClass, (renderInfo, e) -> {
                        GlStateManager.func_179139_a((double)0.4, (double)0.4, (double)0.4);
                        return renderInfo;
                    });
                }
                catch (Exception e2) {
                    LogHelper.warn(String.format("Failed to register %s %s.", variant.family, variant.name));
                    e2.printStackTrace();
                }
            }
        }
    }
}

