/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigThaumcraft;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag.LootBagEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.LootBagRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import java.util.ArrayList;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.api.render.TextModifier;
import jeresources.util.LootTableHelper;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.common.BiomeDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.internal.WeightedRandomLoot;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.blocks.world.BlockLoot;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.entities.monster.EntityEldritchCrab;
import thaumcraft.common.entities.monster.EntityFireBat;
import thaumcraft.common.entities.monster.EntityGiantBrainyZombie;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.entities.monster.EntityThaumicSlime;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.entities.monster.boss.EntityCultistLeader;
import thaumcraft.common.entities.monster.boss.EntityCultistPortalGreater;
import thaumcraft.common.entities.monster.boss.EntityEldritchGolem;
import thaumcraft.common.entities.monster.boss.EntityEldritchWarden;
import thaumcraft.common.entities.monster.boss.EntityTaintacleGiant;
import thaumcraft.common.entities.monster.cult.EntityCultist;
import thaumcraft.common.entities.monster.cult.EntityCultistCleric;
import thaumcraft.common.entities.monster.cult.EntityCultistKnight;
import thaumcraft.common.entities.monster.tainted.EntityTaintCrawler;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeed;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeedPrime;
import thaumcraft.common.entities.monster.tainted.EntityTaintSwarm;
import thaumcraft.common.entities.monster.tainted.EntityTaintacle;
import thaumcraft.common.entities.monster.tainted.EntityTaintacleSmall;
import thecodex6824.thaumicaugmentation.api.TALootTables;

public class JERThaumcraft
extends JERBase
implements IJERIntegration {
    private static JERThaumcraft instance;
    private static final JEMConfigThaumcraft.JER jerConfig;
    private static final boolean forceLoad;

    public JERThaumcraft(boolean enableJERDungeons, boolean enableJERMobs) {
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    private JERThaumcraft() {
    }

    public static JERThaumcraft getInstance() {
        return instance != null ? instance : (instance = new JERThaumcraft());
    }

    public void registerLootBagEntries() {
        if (JEMConfig.THAUMCRAFT.JUST_ENOUGH_ITEMS.enableJEILootBags) {
            LootBagRegistry registry = LootBagRegistry.getInstance();
            registry.registerLootBag(new LootBagEntry(new ItemStack(ItemsTC.lootBag, 1, 0), JERThaumcraft.getCommonLoot()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(ItemsTC.lootBag, 1, 1), JERThaumcraft.getUncommonLoot()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(ItemsTC.lootBag, 1, 2), JERThaumcraft.getRareLoot()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(BlocksTC.lootCrateCommon), JERThaumcraft.getCommonLoot()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(BlocksTC.lootCrateUncommon), JERThaumcraft.getUncommonLoot()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(BlocksTC.lootCrateRare), JERThaumcraft.getRareLoot()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(BlocksTC.lootUrnCommon), JERThaumcraft.getCommonLoot()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(BlocksTC.lootUrnUncommon), JERThaumcraft.getUncommonLoot()));
            registry.registerLootBag(new LootBagEntry(new ItemStack(BlocksTC.lootUrnRare), JERThaumcraft.getRareLoot()));
        }
    }

    @Override
    public void registerModDungeons() {
        this.registerDungeonLoot("thaumcraft:mound", StringHelper.getDungeonTranslationKey(ModIds.THAUMCRAFT.MOD_ID, "mound"), LootTableList.field_186422_d);
    }

    @Override
    public void registerModEntities() {
        this.registerBosses();
        this.registerCultists();
        this.registerMonsters();
        this.registerTaintMobs();
        ItemStack output = FurnaceRecipes.func_77602_a().func_151395_a(new ItemStack(Items.field_151147_al));
    }

    private void registerBosses() {
        if (JEMConfig.THAUMCRAFT.forceLoadJERMobs || ModIds.CRIMSON_WARFARE.isLoaded) {
            LootDrop pearlDrop = new LootDrop(new ItemStack(ItemsTC.primordialPearl));
            LootDrop bagDrop = new LootDrop(new ItemStack(ItemsTC.lootBag, 1, 2));
            if (JERThaumcraft.jerConfig.enableBossCultistPraetor) {
                EntityCultistLeader cultistLeader = new EntityCultistLeader(this.world);
                cultistLeader.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ItemsTC.crimsonPraetorHelm));
                cultistLeader.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ItemsTC.crimsonPraetorChest));
                cultistLeader.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ItemsTC.crimsonPraetorLegs));
                cultistLeader.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ItemsTC.crimsonBoots));
                cultistLeader.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsTC.crimsonBlade));
                ArrayList<LootDrop> leaderDrops = new ArrayList<LootDrop>();
                leaderDrops.add(bagDrop);
                leaderDrops.add(new LootDrop(new ItemStack(ItemsTC.crimsonPraetorHelm), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
                leaderDrops.add(new LootDrop(new ItemStack(ItemsTC.crimsonPraetorChest), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
                leaderDrops.add(new LootDrop(new ItemStack(ItemsTC.crimsonPraetorLegs), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
                leaderDrops.add(new LootDrop(new ItemStack(ItemsTC.crimsonBoots), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
                leaderDrops.add(new LootDrop(new ItemStack(ItemsTC.voidSword), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting, new Conditional(I18n.func_135052_a((String)Conditional.gameDifficulty.toString(), (Object[])new Object[]{EnumDifficulty.EASY.toString()}), new TextModifier[0])}));
                leaderDrops.add(new LootDrop(new ItemStack(ItemsTC.crimsonBlade), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting, new Conditional(I18n.func_135052_a((String)Conditional.notGameDifficulty.toString(), (Object[])new Object[]{EnumDifficulty.EASY.toString()}), new TextModifier[0])}));
                this.registerMob((EntityLivingBase)cultistLeader, LightLevel.any, leaderDrops.toArray(new LootDrop[0]));
                this.registerRenderHook(EntityCultistLeader.class, (renderInfo, e) -> {
                    GlStateManager.func_179137_b((double)-0.05, (double)-0.65, (double)0.0);
                    GlStateManager.func_179139_a((double)1.35, (double)1.35, (double)1.35);
                    return renderInfo;
                });
            }
            if (JERThaumcraft.jerConfig.enableBossGreaterCrimsonPortal) {
                this.registerMob((EntityLivingBase)new EntityCultistPortalGreater(this.world), LightLevel.any, pearlDrop);
            }
            if (JERThaumcraft.jerConfig.enableBossEldritchGolem) {
                this.registerMob((EntityLivingBase)new EntityEldritchGolem(this.world), LightLevel.any, pearlDrop, bagDrop);
                this.registerRenderHook(EntityEldritchGolem.class, (renderInfo, e) -> {
                    GlStateManager.func_179137_b((double)-0.05, (double)-0.65, (double)0.0);
                    GlStateManager.func_179139_a((double)1.15, (double)1.15, (double)1.15);
                    return renderInfo;
                });
            }
            if (JERThaumcraft.jerConfig.enableBossEldritchWarden) {
                this.registerMob((EntityLivingBase)new EntityEldritchWarden(this.world), LightLevel.any, pearlDrop, bagDrop);
                this.registerRenderHook(EntityEldritchWarden.class, (renderInfo, e) -> {
                    GlStateManager.func_179137_b((double)-0.05, (double)-0.8, (double)0.0);
                    GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                    return renderInfo;
                });
            }
            if (JERThaumcraft.jerConfig.enableBossTaintacleGiant) {
                ArrayList<LootDrop> taintacleDrops = new ArrayList<LootDrop>();
                taintacleDrops.add(pearlDrop);
                if (ModIds.THAUMIC_AUGMENTATION.isLoaded) {
                    taintacleDrops.addAll(LootTableHelper.toDrops((World)this.world, (ResourceLocation)TALootTables.TAINT_MOB));
                }
                this.registerMob((EntityLivingBase)new EntityTaintacleGiant(this.world), LightLevel.any, taintacleDrops.toArray(new LootDrop[0]));
            }
        }
    }

    private void registerCultists() {
        ArrayList<LootDrop> drops;
        if (JERThaumcraft.jerConfig.enableCultistCleric) {
            EntityCultistCleric cleric = new EntityCultistCleric(this.world);
            cleric.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ItemsTC.crimsonRobeHelm));
            cleric.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ItemsTC.crimsonRobeChest));
            cleric.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ItemsTC.crimsonRobeLegs));
            cleric.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ItemsTC.crimsonBoots));
            drops = new ArrayList<LootDrop>(LootTableHelper.toDrops((World)this.world, (ResourceLocation)EntityCultist.LOOT));
            drops.add(new LootDrop(new ItemStack(ItemsTC.crimsonRobeHelm), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
            drops.add(new LootDrop(new ItemStack(ItemsTC.crimsonRobeChest), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
            drops.add(new LootDrop(new ItemStack(ItemsTC.crimsonRobeLegs), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
            drops.add(new LootDrop(new ItemStack(ItemsTC.crimsonBoots), 0, 1, 0.015f, new Conditional[]{Conditional.affectedByLooting}));
            this.registerMob((EntityLivingBase)cleric, LightLevel.any, drops.toArray(new LootDrop[0]));
        }
        if (JERThaumcraft.jerConfig.enableCultistKnight) {
            EntityCultistKnight knight = new EntityCultistKnight(this.world);
            knight.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ItemsTC.crimsonPlateHelm));
            knight.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ItemsTC.crimsonPlateChest));
            knight.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ItemsTC.crimsonPlateLegs));
            knight.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ItemsTC.crimsonBoots));
            knight.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemsTC.voidSword));
            drops = new ArrayList(LootTableHelper.toDrops((World)this.world, (ResourceLocation)EntityCultist.LOOT));
            drops.add(new LootDrop(new ItemStack(ItemsTC.crimsonPlateHelm), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
            drops.add(new LootDrop(new ItemStack(ItemsTC.crimsonPlateChest), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
            drops.add(new LootDrop(new ItemStack(ItemsTC.crimsonPlateLegs), 0, 1, 0.05f, new Conditional[]{Conditional.affectedByLooting}));
            drops.add(new LootDrop(new ItemStack(ItemsTC.crimsonBoots), 0, 1, 0.025f, new Conditional[]{Conditional.affectedByLooting}));
            drops.add(new LootDrop(new ItemStack(ItemsTC.voidSword), 0, 1, 0.005f, new Conditional[]{Conditional.affectedByLooting}));
            drops.add(new LootDrop(new ItemStack(ItemsTC.thaumiumSword), 0, 1, 0.02f, new Conditional[]{Conditional.affectedByLooting}));
            this.registerMob((EntityLivingBase)knight, LightLevel.any, drops.toArray(new LootDrop[0]));
        }
        if (JERThaumcraft.jerConfig.enableCultistCleric || JERThaumcraft.jerConfig.enableCultistKnight) {
            this.registerRenderHook(EntityCultist.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)-0.45, (double)0.0);
                return renderInfo;
            });
        }
    }

    private void registerMonsters() {
        ArrayList<LootDrop> drops;
        if (JERThaumcraft.jerConfig.enableAngryZombie) {
            drops = new ArrayList<LootDrop>(LootTableHelper.toDrops((World)this.world, (ResourceLocation)LootTableList.field_186383_ah));
            drops.add(new LootDrop(new ItemStack(ItemsTC.brain), 0, 1, 0.5f, new Conditional[]{Conditional.affectedByLooting}));
            this.registerMob((EntityLivingBase)new EntityBrainyZombie(this.world), LightLevel.hostile, drops.toArray(new LootDrop[0]));
        }
        if (JERThaumcraft.jerConfig.enableEldrichCrab && (ModIds.THAUMIC_AUGMENTATION.isLoaded || forceLoad)) {
            this.registerMob((EntityLivingBase)new EntityEldritchCrab(this.world), LightLevel.hostile, new LootDrop(new ItemStack(Items.field_151079_bi), 1, 1, 0.33333334f, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (JERThaumcraft.jerConfig.enableFireBat) {
            this.registerMob((EntityLivingBase)new EntityFireBat(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.NETHER.toString()), new LootDrop(Items.field_151016_H, 1, 1, new Conditional[]{Conditional.affectedByLooting}));
        }
        if (JERThaumcraft.jerConfig.enableFuriousZombie) {
            drops = new ArrayList(LootTableHelper.toDrops((World)this.world, (ResourceLocation)LootTableList.field_186383_ah));
            drops.add(new LootDrop(new ItemStack(ItemsTC.brain), 0, 1, 0.5f, new Conditional[]{Conditional.affectedByLooting}));
            this.registerMob((EntityLivingBase)new EntityGiantBrainyZombie(this.world), LightLevel.hostile, drops.toArray(new LootDrop[0]));
        }
        if (JERThaumcraft.jerConfig.enablePech) {
            this.registerMob((EntityLivingBase)new EntityPech(this.world), LightLevel.hostile, EntityPech.LOOT);
            this.registerRenderHook(EntityPech.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)-0.4, (double)0.0);
                return renderInfo;
            });
        }
        if (JERThaumcraft.jerConfig.enableThaumicSlime) {
            drops = new ArrayList(LootTableHelper.toDrops((World)this.world, (ResourceLocation)LootTableList.field_186378_ac));
            drops.add(new LootDrop(ConfigItems.FLUX_CRYSTAL.func_77946_l()));
            this.registerMob((EntityLivingBase)new EntityThaumicSlime(this.world), LightLevel.any, drops.toArray(new LootDrop[0]));
        }
        if (JERThaumcraft.jerConfig.enableWisp) {
            ArrayList primals = Aspect.getPrimalAspects();
            ArrayList<LootDrop> drops2 = new ArrayList<LootDrop>(primals.size());
            float chance = 1.0f / (float)primals.size();
            for (Aspect aspect : primals) {
                drops2.add(new LootDrop(ThaumcraftApiHelper.makeCrystal((Aspect)aspect), 1, 1, chance, new Conditional[0]));
            }
            this.registerMob((EntityLivingBase)new EntityWisp(this.world), LightLevel.any, drops2.toArray(new LootDrop[0]));
        }
    }

    private void registerTaintMobs() {
        ArrayList<LootDrop> taintDrops = new ArrayList<LootDrop>(2);
        taintDrops.add(new LootDrop(ConfigItems.FLUX_CRYSTAL.func_77946_l()));
        if (ModIds.THAUMIC_AUGMENTATION.isLoaded) {
            taintDrops.addAll(LootTableHelper.toDrops((World)this.world, (ResourceLocation)TALootTables.TAINT_MOB));
        }
        if (JERThaumcraft.jerConfig.enableTaintacle || JERThaumcraft.jerConfig.enableTaintacleSmall) {
            if (JERThaumcraft.jerConfig.enableTaintacle) {
                this.registerMob((EntityLivingBase)new EntityTaintacle(this.world), LightLevel.any, taintDrops.toArray(new LootDrop[0]));
                this.registerRenderHook(EntityTaintacle.class, (renderInfo, e) -> {
                    GlStateManager.func_179137_b((double)0.0, (double)2.2, (double)0.0);
                    return renderInfo;
                });
            }
            if (JERThaumcraft.jerConfig.enableTaintacleSmall) {
                this.registerMob((EntityLivingBase)new EntityTaintacleSmall(this.world), LightLevel.any, taintDrops.toArray(new LootDrop[0]));
                this.registerRenderHook(EntityTaintacleSmall.class, (renderInfo, e) -> {
                    GlStateManager.func_179137_b((double)0.0, (double)(JERThaumcraft.jerConfig.enableTaintacle ? -1.6 : 0.6), (double)0.0);
                    return renderInfo;
                });
            }
        }
        if (JERThaumcraft.jerConfig.enableTaintCrawler) {
            this.registerMob((EntityLivingBase)new EntityTaintCrawler(this.world), LightLevel.any, new LootDrop(ConfigItems.FLUX_CRYSTAL.func_77946_l()));
        }
        if (JERThaumcraft.jerConfig.enableTaintSeed) {
            this.registerMob((EntityLivingBase)new EntityTaintSeed(this.world), LightLevel.any, taintDrops.toArray(new LootDrop[0]));
            this.registerRenderHook(EntityTaintSeed.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)0.6, (double)0.0);
                return renderInfo;
            });
        }
        if (JERThaumcraft.jerConfig.enableTaintSeedPrime) {
            this.registerMob((EntityLivingBase)new EntityTaintSeedPrime(this.world), LightLevel.any, taintDrops.toArray(new LootDrop[0]));
            this.registerRenderHook(EntityTaintSeedPrime.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)(JERThaumcraft.jerConfig.enableTaintSeed ? 0.6 : 1.2), (double)0.0);
                return renderInfo;
            });
        }
        if (JERThaumcraft.jerConfig.enableTaintSwarm) {
            this.registerMob((EntityLivingBase)new EntityTaintSwarm(this.world), LightLevel.any, taintDrops.toArray(new LootDrop[0]));
        }
    }

    private static LootTable getCommonLoot() {
        int minRolls = BlockLoot.LootType.COMMON.ordinal() + 1;
        return JERThaumcraft.getLoot(WeightedRandomLoot.lootBagCommon, minRolls);
    }

    private static LootTable getUncommonLoot() {
        int minRolls = BlockLoot.LootType.UNCOMMON.ordinal() + 1;
        return JERThaumcraft.getLoot(WeightedRandomLoot.lootBagUncommon, minRolls);
    }

    private static LootTable getRareLoot() {
        int minRolls = BlockLoot.LootType.RARE.ordinal() + 1;
        return JERThaumcraft.getLoot(WeightedRandomLoot.lootBagRare, minRolls);
    }

    private static LootTable getLoot(ArrayList<WeightedRandomLoot> lootList, int minRolls) {
        ArrayList<LootEntryItem> entries = new ArrayList<LootEntryItem>();
        int maxRolls = minRolls + 2;
        int potionWeight = 0;
        int splashWeight = 0;
        int lingeringWeight = 0;
        for (WeightedRandomLoot randomLoot : lootList) {
            ItemStack stack = randomLoot.item;
            if (JEMConfig.THAUMCRAFT.JUST_ENOUGH_ITEMS.removePotionLoot) {
                if (stack.func_77973_b() == Items.field_151068_bn) {
                    potionWeight += randomLoot.field_76292_a;
                    continue;
                }
                if (stack.func_77973_b() == Items.field_185155_bH) {
                    splashWeight += randomLoot.field_76292_a;
                    continue;
                }
                if (stack.func_77973_b() == Items.field_185156_bI) {
                    lingeringWeight += randomLoot.field_76292_a;
                    continue;
                }
            }
            ArrayList<Object> functions = new ArrayList<Object>();
            functions.add(new SetMetadata(new LootCondition[0], new RandomValueRange((float)stack.func_77952_i(), (float)stack.func_77952_i())));
            functions.add(new SetCount(new LootCondition[0], new RandomValueRange((float)stack.func_190916_E(), (float)stack.func_190916_E())));
            if (stack.func_77942_o()) {
                functions.add(new SetNBT(new LootCondition[0], stack.func_77978_p()));
            }
            entries.add(new LootEntryItem(stack.func_77973_b(), randomLoot.field_76292_a, 0, functions.toArray(new LootFunction[0]), new LootCondition[0], stack.func_77973_b().getRegistryName().toString()));
        }
        if (JEMConfig.THAUMCRAFT.JUST_ENOUGH_ITEMS.removePotionLoot) {
            entries.add(new LootEntryItem((Item)Items.field_151068_bn, potionWeight, 0, new LootFunction[0], new LootCondition[0], Items.field_151068_bn.toString()));
            entries.add(new LootEntryItem((Item)Items.field_185155_bH, splashWeight, 0, new LootFunction[0], new LootCondition[0], Items.field_185155_bH.toString()));
            entries.add(new LootEntryItem((Item)Items.field_185156_bI, lingeringWeight, 0, new LootFunction[0], new LootCondition[0], Items.field_185156_bI.toString()));
        }
        return new LootTable(new LootPool[]{new LootPool(entries.toArray(new LootEntry[0]), new LootCondition[0], new RandomValueRange((float)minRolls, (float)maxRolls), new RandomValueRange(0.0f, 0.0f), "thaumcraft:loot_block")});
    }

    private boolean canSmelt(ItemStack stack) {
        return !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
    }

    static {
        jerConfig = JEMConfig.THAUMCRAFT.JUST_ENOUGH_RESOURCES;
        forceLoad = JEMConfig.THAUMCRAFT.forceLoadJERMobs;
    }
}

