/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import cofh.thermalfoundation.entity.monster.EntityBasalz;
import cofh.thermalfoundation.entity.monster.EntityBlitz;
import cofh.thermalfoundation.entity.monster.EntityBlizz;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigThermalFoundation;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.integrations.jer.conditionals.JEMLightLevel;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import gnu.trove.set.hash.THashSet;
import java.lang.reflect.Field;
import java.util.Collection;
import jeresources.api.render.IMobRenderHook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class JERThermalFoundation
extends JERBase
implements IJERIntegration {
    private final JEMConfigThermalFoundation.JER jerConfig;

    public JERThermalFoundation(boolean enableJERMobs) {
        this.jerConfig = JEMConfig.THERMAL_FOUNDATION.JUST_ENOUGH_RESOURCES;
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    @Override
    public void registerModEntities() {
        if (this.jerConfig.enableBasalzMob) {
            this.registerBasalz();
        }
        if (this.jerConfig.enableBlitzMob) {
            this.registerBlitz();
        }
        if (this.jerConfig.enableBlizzMob) {
            this.registerBlizz();
        }
    }

    protected void registerBasalz() {
        try {
            Field f = EntityBasalz.class.getDeclaredField("spawnLightLevel");
            f.setAccessible(true);
            int lightLevel = (Integer)f.get(EntityBasalz.class);
            THashSet biomes = new THashSet();
            biomes.addAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
            biomes.addAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND));
            biomes.removeAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
            biomes.removeAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
            ResourceLocation lootTable = new ResourceLocation(ModIds.THERMAL_FOUNDATION.MOD_ID, "entities/basalz");
            this.registerMob((EntityLivingBase)new EntityBasalz(this.world), JEMLightLevel.custom(lightLevel, false), BiomeHelper.getBiomeNamesForBiomes((Biome[])biomes.toArray((Object[])new Biome[0])), lootTable);
            this.adjustElementalRenderHook(EntityBasalz.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void registerBlitz() {
        try {
            Field f = EntityBlitz.class.getDeclaredField("spawnLightLevel");
            f.setAccessible(true);
            int lightLevel = (Integer)f.get(EntityBlitz.class);
            THashSet biomes = new THashSet();
            biomes.addAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SANDY));
            biomes.addAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
            biomes.removeAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
            biomes.removeAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
            ResourceLocation lootTable = new ResourceLocation(ModIds.THERMAL_FOUNDATION.MOD_ID, "entities/blitz");
            this.registerMob((EntityLivingBase)new EntityBlitz(this.world), JEMLightLevel.custom(lightLevel, false), BiomeHelper.getBiomeNamesForBiomes((Biome[])biomes.toArray((Object[])new Biome[0])), lootTable);
            this.adjustElementalRenderHook(EntityBlitz.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerBlizz() {
        try {
            Field f = EntityBlizz.class.getDeclaredField("spawnLightLevel");
            f.setAccessible(true);
            int lightLevel = (Integer)f.get(EntityBlizz.class);
            THashSet biomes = new THashSet();
            biomes.addAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.COLD));
            biomes.addAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SNOWY));
            biomes.removeAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER));
            biomes.removeAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.END));
            ResourceLocation lootTable = new ResourceLocation(ModIds.THERMAL_FOUNDATION.MOD_ID, "entities/blizz");
            this.registerMob((EntityLivingBase)new EntityBlizz(this.world), JEMLightLevel.custom(lightLevel, false), BiomeHelper.getBiomeNamesForBiomes((Biome[])biomes.toArray((Object[])new Biome[0])), lootTable);
            this.adjustElementalRenderHook(EntityBlizz.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void adjustElementalRenderHook(Class<? extends EntityLiving> entity) {
        IMobRenderHook RENDER_HOOK = (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)0.0, (double)-0.3, (double)0.0);
            return renderInfo;
        };
        this.registerRenderHook(entity, RENDER_HOOK);
    }
}

